/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.bandit.many_bows.entity.IcicleJavelin;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class IcicleJavelinBow
extends BowItem {
    private static final int MIN_CHARGE_REQUIRED = 10;
    private static final double BASE_DAMAGE = 3.0;
    private boolean hasPlayedPullSound = false;

    public IcicleJavelinBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                ItemStack arrowStack;
                int charge = this.m_8105_(stack) - timeCharged;
                float power = IcicleJavelinBow.m_40661_((int)charge);
                boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                ItemStack itemStack = arrowStack = hasInfinity ? ItemStack.f_41583_ : this.findArrowInInventory(player);
                if (charge >= 10 && power >= 0.1f && (hasInfinity || !arrowStack.m_41619_())) {
                    int punchLevel;
                    IcicleJavelin javelin = new IcicleJavelin(level, (LivingEntity)player);
                    javelin.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.5f, 1.0f);
                    int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                    if (powerLevel > 0) {
                        javelin.m_36781_(3.0 + (double)powerLevel * 0.5);
                    }
                    if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                        javelin.m_36735_(punchLevel);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                        javelin.m_20254_(100);
                    }
                    javelin.f_36705_ = hasInfinity ? AbstractArrow.Pickup.DISALLOWED : AbstractArrow.Pickup.ALLOWED;
                    level.m_7967_((Entity)javelin);
                    this.createIceParticles(level, (LivingEntity)player);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!hasInfinity) {
                        arrowStack.m_41774_(1);
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    }
                }
            }
        }
        this.hasPlayedPullSound = false;
    }

    private ItemStack findArrowInInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != Items.f_42412_) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.many_bows.icicle_javelin_bow.tooltip").m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237115_((String)"item.many_bows.icicle_javelin_bow.tooltip.ability").m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237115_((String)"item.many_bows.icicle_javelin_bow.tooltip.freeze").m_130940_(ChatFormatting.BLUE));
    }

    private void createIceParticles(Level level, LivingEntity entity) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = entity.m_217043_().m_188583_() * 0.3;
            double offsetY = entity.m_217043_().m_188583_() * 0.3;
            double offsetZ = entity.m_217043_().m_188583_() * 0.3;
            level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, entity.m_20185_() + offsetX, entity.m_20186_() + (double)entity.m_20206_() / 1.5 + offsetY, entity.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

