/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class IroncladBow
extends BowItem {
    private static final double PULL_RADIUS = 10.0;
    private static final double PULL_STRENGTH = 0.15;

    public IroncladBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                this.createPullingEffect(level, player);
            }
        }
        super.m_5929_(level, entity, stack, count);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            int charge;
            float power;
            Player player = (Player)entity;
            if (!level.m_5776_() && (power = IroncladBow.m_40661_((int)(charge = this.m_8105_(stack) - timeCharged))) >= 0.1f) {
                ItemStack arrowStack;
                boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                ItemStack itemStack = arrowStack = hasInfinity ? ItemStack.f_41583_ : this.findArrowInInventory(player);
                if (hasInfinity || !arrowStack.m_41619_()) {
                    int punchLevel;
                    Arrow arrow = new Arrow(level, (LivingEntity)player);
                    arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.0f, 1.0f);
                    int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                    if (powerLevel > 0) {
                        arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 1.5);
                    }
                    if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                        arrow.m_36735_(punchLevel);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                        arrow.m_20254_(100);
                    }
                    arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                    level.m_7967_((Entity)arrow);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12559_, SoundSource.PLAYERS, 1.0f, 1.2f);
                    if (!hasInfinity) {
                        arrowStack.m_41774_(1);
                    }
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                }
            }
        }
    }

    private void createPullingEffect(Level level, Player player) {
        AABB pullArea = new AABB(player.m_20185_() - 10.0, player.m_20186_() - 10.0, player.m_20189_() - 10.0, player.m_20185_() + 10.0, player.m_20186_() + 10.0, player.m_20189_() + 10.0);
        List entities = level.m_45976_(LivingEntity.class, pullArea);
        for (LivingEntity target : entities) {
            if (target == player) continue;
            Vec3 direction = player.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_(0.15);
            target.m_20256_(target.m_20184_().m_82549_(direction));
        }
    }

    private ItemStack findArrowInInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != Items.f_42412_) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41663_(Enchantments.f_44952_, 1);
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.ironclad_bow.tooltip").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.ironclad_bow.tooltip.ability").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.ironclad_bow.tooltip.legend").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC}));
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 15;
    }
}

