/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ScatterBow
extends BowItem {
    private static final int NUM_ARROWS = 8;

    public ScatterBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                int arrowsToShoot;
                int charge = this.m_8105_(stack) - timeCharged;
                float power = ScatterBow.m_40661_((int)charge);
                boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                int n = arrowsToShoot = hasInfinity ? 8 : Math.min(8, this.countArrows(player));
                if (power >= 0.1f && (hasInfinity || this.consumeArrow(player, arrowsToShoot))) {
                    for (int i = 0; i < arrowsToShoot; ++i) {
                        int punchLevel;
                        Arrow arrow = new Arrow(level, (LivingEntity)player);
                        arrow.m_36781_(1.0);
                        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                        if (powerLevel > 0) {
                            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
                        }
                        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                            arrow.m_36735_(punchLevel);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                            arrow.m_20254_(100);
                        }
                        if (hasInfinity) {
                            arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                        }
                        float yawOffset = (level.m_213780_().m_188501_() - 0.5f) * 20.0f;
                        float pitchOffset = (level.m_213780_().m_188501_() - 0.5f) * 10.0f;
                        arrow.m_37251_((Entity)player, player.m_146909_() + pitchOffset, player.m_146908_() + yawOffset, 0.0f, power * 3.0f, 1.0f);
                        level.m_7967_((Entity)arrow);
                    }
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                } else {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    private boolean consumeArrow(Player player, int count) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        int arrowsRemoved = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != Items.f_42412_ || arrowsRemoved >= count) continue;
            int removeAmount = Math.min(stack.m_41613_(), count - arrowsRemoved);
            stack.m_41774_(removeAmount);
            arrowsRemoved += removeAmount;
        }
        return arrowsRemoved >= count;
    }

    private int countArrows(Player player) {
        int arrowCount = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != Items.f_42412_) continue;
            arrowCount += stack.m_41613_();
        }
        return arrowCount;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.many_bows.scatter_bow.tooltip").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237115_((String)"item.many_bows.scatter_bow.tooltip.ability").m_130940_(ChatFormatting.DARK_GREEN));
    }
}

