/*
 * Decompiled with CFR 0.152.
 */
package tfar.laserrelays;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import tfar.laserrelays.ExampleMod;
import tfar.laserrelays.NBTUtil;
import tfar.laserrelays.NodeBlock;
import tfar.laserrelays.NodeBlockEntity;
import tfar.laserrelays.NodeType;
import tfar.laserrelays.item.ColorFilterItem;

public class Client
extends RenderType {
    public static final RenderType LINES2 = Client.func_228632_a_((String)"lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(2.0))).func_228718_a_(field_239235_M_).func_228726_a_(field_228515_g_).func_228721_a_(field_241712_U_).func_228727_a_(field_228495_E_).func_228728_a_(false));
    public static final Minecraft mc = Minecraft.func_71410_x();

    public static RenderType getCubeType() {
        RenderType.State renderTypeState = RenderType.State.func_228694_a_().func_228726_a_(field_228515_g_).func_228714_a_(RenderState.CullState.field_228491_A_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"cube", (VertexFormat)DefaultVertexFormats.field_181712_l, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)renderTypeState);
    }

    public Client(String nameIn, VertexFormat formatIn, int drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
        super(nameIn, formatIn, drawModeIn, bufferSizeIn, useDelegateIn, needsSortingIn, setupTaskIn, clearTaskIn);
    }

    public static void render(RenderWorldLastEvent e) {
        BlockPos pos;
        List nodes = Minecraft.func_71410_x().field_71441_e.field_147482_g.stream().filter(NodeBlockEntity.class::isInstance).map(NodeBlockEntity.class::cast).collect(Collectors.toList());
        MatrixStack matrices = e.getMatrixStack();
        Vector3d vec3d = TileEntityRendererDispatcher.field_147556_a.field_217666_g.func_216785_c();
        matrices.func_227861_a_(-vec3d.field_72450_a, -vec3d.field_72448_b, -vec3d.field_72449_c);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(LINES2);
        for (NodeBlockEntity terminalBlockEntity : nodes) {
            boolean gas;
            BlockState state = terminalBlockEntity.func_195044_w();
            NodeType whitelistNode = NodeType.getNodeFromStack(Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.MAIN_HAND));
            boolean items = (Boolean)state.func_177229_b((Property)NodeBlock.ITEM_INPUT) != false && (whitelistNode == null || whitelistNode == NodeType.ITEM);
            boolean fluids = (Boolean)state.func_177229_b((Property)NodeBlock.FLUID_INPUT) != false && (whitelistNode == null || whitelistNode == NodeType.FLUID);
            boolean energy = (Boolean)state.func_177229_b((Property)NodeBlock.ENERGY_INPUT) != false && (whitelistNode == null || whitelistNode == NodeType.ENERGY);
            boolean bl = gas = (Boolean)state.func_177229_b((Property)NodeBlock.GAS_INPUT) != false && (whitelistNode == null || whitelistNode == NodeType.GAS);
            if (items && ((Boolean)state.func_177229_b((Property)NodeBlock.ITEM)).booleanValue()) {
                for (BlockPos pos2 : terminalBlockEntity.connections.get((Object)NodeType.ITEM)) {
                    Client.renderline(matrices, builder, terminalBlockEntity, pos2, NodeType.ITEM);
                }
            }
            if (fluids && ((Boolean)state.func_177229_b((Property)NodeBlock.FLUID)).booleanValue()) {
                for (BlockPos pos2 : terminalBlockEntity.connections.get((Object)NodeType.FLUID)) {
                    Client.renderline(matrices, builder, terminalBlockEntity, pos2, NodeType.FLUID);
                }
            }
            if (energy && ((Boolean)state.func_177229_b((Property)NodeBlock.ENERGY)).booleanValue()) {
                for (BlockPos pos2 : terminalBlockEntity.connections.get((Object)NodeType.ENERGY)) {
                    Client.renderline(matrices, builder, terminalBlockEntity, pos2, NodeType.ENERGY);
                }
            }
            if (!gas || !((Boolean)state.func_177229_b((Property)NodeBlock.GAS)).booleanValue()) continue;
            for (BlockPos pos2 : terminalBlockEntity.connections.get((Object)NodeType.GAS)) {
                Client.renderline(matrices, builder, terminalBlockEntity, pos2, NodeType.GAS);
            }
        }
        Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(LINES2);
        ItemStack stack1 = Client.mc.field_71439_g.func_184586_b(Hand.MAIN_HAND);
        if (stack1.func_77973_b().func_206844_a(ExampleMod.HIGHLIGHT) && stack1.func_77978_p() != null && stack1.func_77978_p().func_74764_b("node_type") && (pos = NBTUtil.readBlockPos(stack1.func_77978_p())) != null) {
            builder = buffer.getBuffer(Client.getCubeType());
            Client.renderCubeOutline(matrices, builder, pos, NodeType.valueOf((String)stack1.func_77978_p().func_74779_i((String)"node_type")).color);
            Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(Client.getCubeType());
        }
    }

    public static void renderCubeOutline(MatrixStack matrices, IVertexBuilder builder, BlockPos pos, int color) {
        Matrix4f matrix4f = matrices.func_227866_c_().func_227870_a_();
        int alpha = Integer.MIN_VALUE;
        Client.drawVerticalFace(builder, matrix4f, pos.func_177958_n(), 1.0f, pos.func_177956_o(), 1.0f, pos.func_177952_p(), 0.0f, alpha | color);
        Client.drawVerticalFace(builder, matrix4f, pos.func_177958_n(), 1.0f, pos.func_177956_o(), 1.0f, pos.func_177952_p() + 1, 0.0f, alpha | color);
        Client.drawVerticalFace(builder, matrix4f, pos.func_177958_n() + 1, 0.0f, pos.func_177956_o(), 1.0f, pos.func_177952_p(), 1.0f, alpha | color);
        Client.drawVerticalFace(builder, matrix4f, pos.func_177958_n(), 0.0f, pos.func_177956_o(), 1.0f, pos.func_177952_p(), 1.0f, alpha | color);
        Client.drawHorizontalFace(builder, matrix4f, pos.func_177958_n(), 1.0f, pos.func_177956_o() + 1, pos.func_177952_p(), 1.0f, alpha | color);
        Client.drawHorizontalFace(builder, matrix4f, pos.func_177958_n(), 1.0f, pos.func_177956_o(), pos.func_177952_p(), 1.0f, alpha | color);
    }

    public static void drawVerticalFace(IVertexBuilder builder, Matrix4f matrix4f, float u, float width, float v, float height, float z, float depth, int aarrggbb) {
        float a = (float)(aarrggbb >> 24 & 0xFF) / 255.0f;
        float r = (float)(aarrggbb >> 16 & 0xFF) / 255.0f;
        float g = (float)(aarrggbb >> 8 & 0xFF) / 255.0f;
        float b = (float)(aarrggbb & 0xFF) / 255.0f;
        Client.drawVerticalFace(builder, matrix4f, u, width, v, height, z, depth, r, g, b, a);
    }

    public static void drawVerticalFace(IVertexBuilder builder, Matrix4f matrix4f, float x, float width, float y, float height, float z, float depth, float r, float g, float b, float a) {
        builder.func_227888_a_(matrix4f, x, y, z).func_225583_a_(0.0f, 0.0f).func_227885_a_(r, g, b, a).func_225584_a_(Vector3f.field_229181_d_.func_195899_a(), Vector3f.field_229181_d_.func_195900_b(), Vector3f.field_229181_d_.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, x, y + height, z).func_225583_a_(0.0f, 0.5f).func_227885_a_(r, g, b, a).func_225584_a_(Vector3f.field_229181_d_.func_195899_a(), Vector3f.field_229181_d_.func_195900_b(), Vector3f.field_229181_d_.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, x + width, y + height, z + depth).func_225583_a_(1.0f, 0.5f).func_227885_a_(r, g, b, a).func_225584_a_(Vector3f.field_229181_d_.func_195899_a(), Vector3f.field_229181_d_.func_195900_b(), Vector3f.field_229181_d_.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, x + width, y, z + depth).func_225583_a_(1.0f, 0.0f).func_227885_a_(r, g, b, a).func_225584_a_(Vector3f.field_229181_d_.func_195899_a(), Vector3f.field_229181_d_.func_195900_b(), Vector3f.field_229181_d_.func_195902_c()).func_181675_d();
    }

    public static void drawHorizontalFace(IVertexBuilder builder, Matrix4f matrix4f, float u, float width, float v, float z, float depth, int aarrggbb) {
        float a = (float)(aarrggbb >> 24 & 0xFF) / 255.0f;
        float r = (float)(aarrggbb >> 16 & 0xFF) / 255.0f;
        float g = (float)(aarrggbb >> 8 & 0xFF) / 255.0f;
        float b = (float)(aarrggbb & 0xFF) / 255.0f;
        Client.drawHorizontalFace(builder, matrix4f, u, width, v, z, depth, r, g, b, a);
    }

    public static void drawHorizontalFace(IVertexBuilder builder, Matrix4f matrix4f, float x, float width, float y, float z, float depth, float r, float g, float b, float a) {
        builder.func_227888_a_(matrix4f, x, y, z).func_225583_a_(0.0f, 0.0f).func_227885_a_(r, g, b, a).func_225584_a_(Vector3f.field_229181_d_.func_195899_a(), Vector3f.field_229181_d_.func_195900_b(), Vector3f.field_229181_d_.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, x + width, y, z).func_225583_a_(0.0f, 0.5f).func_227885_a_(r, g, b, a).func_225584_a_(Vector3f.field_229181_d_.func_195899_a(), Vector3f.field_229181_d_.func_195900_b(), Vector3f.field_229181_d_.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, x + width, y, z + depth).func_225583_a_(1.0f, 0.0f).func_227885_a_(r, g, b, a).func_225584_a_(Vector3f.field_229181_d_.func_195899_a(), Vector3f.field_229181_d_.func_195900_b(), Vector3f.field_229181_d_.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, x, y, z + depth).func_225583_a_(1.0f, 0.5f).func_227885_a_(r, g, b, a).func_225584_a_(Vector3f.field_229181_d_.func_195899_a(), Vector3f.field_229181_d_.func_195900_b(), Vector3f.field_229181_d_.func_195902_c()).func_181675_d();
    }

    private static void renderline(MatrixStack matrices, IVertexBuilder bufferIn, NodeBlockEntity nodeBlockEntity, BlockPos to, NodeType nodeType) {
        float red = nodeType == NodeType.ENERGY || nodeType == NodeType.GAS ? 1.0f : 0.0f;
        float green = nodeType == NodeType.ITEM || nodeType == NodeType.GAS ? 1.0f : 0.0f;
        float blue = nodeType == NodeType.FLUID ? 1.0f : 0.0f;
        float alpha = 1.0f;
        BlockPos from = nodeBlockEntity.func_174877_v();
        BlockState stateFrom = nodeBlockEntity.func_195044_w();
        BlockState stateTo = Minecraft.func_71410_x().field_71441_e.func_180495_p(to);
        if (stateTo.func_177230_c() instanceof NodeBlock) {
            double x1 = (double)from.func_177958_n() + Client.getXOffSet((Direction)stateFrom.func_177229_b((Property)NodeBlock.FACING), nodeType);
            double y1 = (double)from.func_177956_o() + Client.getYOffSet((Direction)stateFrom.func_177229_b((Property)NodeBlock.FACING), nodeType);
            double z1 = (double)from.func_177952_p() + Client.getZOffSet((Direction)stateFrom.func_177229_b((Property)NodeBlock.FACING), nodeType);
            double x2 = (double)to.func_177958_n() + Client.getXOffSet((Direction)stateTo.func_177229_b((Property)NodeBlock.FACING), nodeType);
            double y2 = (double)to.func_177956_o() + Client.getYOffSet((Direction)stateTo.func_177229_b((Property)NodeBlock.FACING), nodeType);
            double z2 = (double)to.func_177952_p() + Client.getZOffSet((Direction)stateTo.func_177229_b((Property)NodeBlock.FACING), nodeType);
            Matrix4f matrix4f = matrices.func_227866_c_().func_227870_a_();
            bufferIn.func_227888_a_(matrix4f, (float)x1, (float)y1, (float)z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
            bufferIn.func_227888_a_(matrix4f, (float)x2, (float)y2, (float)z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
    }

    public static double getXOffSet(Direction direction, NodeType nodeType) {
        switch (direction) {
            case UP: {
                switch (nodeType) {
                    case ITEM: 
                    case ENERGY: {
                        return 0.25;
                    }
                    case FLUID: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
            case DOWN: {
                switch (nodeType) {
                    case ITEM: 
                    case ENERGY: {
                        return 0.25;
                    }
                    case FLUID: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
            case NORTH: {
                switch (nodeType) {
                    case ITEM: 
                    case ENERGY: {
                        return 0.25;
                    }
                    case FLUID: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
            case EAST: 
            case WEST: {
                return 0.5;
            }
            case SOUTH: {
                switch (nodeType) {
                    case ITEM: 
                    case ENERGY: {
                        return 0.75;
                    }
                    case FLUID: 
                    case GAS: {
                        return 0.25;
                    }
                }
            }
        }
        return 0.0;
    }

    public static double getYOffSet(Direction direction, NodeType nodeType) {
        switch (direction) {
            case UP: 
            case DOWN: {
                return 0.5;
            }
            case NORTH: {
                switch (nodeType) {
                    case ITEM: 
                    case FLUID: {
                        return 0.25;
                    }
                    case ENERGY: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
            case EAST: {
                switch (nodeType) {
                    case ITEM: 
                    case FLUID: {
                        return 0.25;
                    }
                    case ENERGY: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
            case SOUTH: {
                switch (nodeType) {
                    case ITEM: 
                    case FLUID: {
                        return 0.25;
                    }
                    case ENERGY: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
            case WEST: {
                switch (nodeType) {
                    case ITEM: 
                    case FLUID: {
                        return 0.25;
                    }
                    case ENERGY: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
        }
        return 0.0;
    }

    public static double getZOffSet(Direction direction, NodeType nodeType) {
        switch (direction) {
            case UP: {
                switch (nodeType) {
                    case ITEM: 
                    case FLUID: {
                        return 0.25;
                    }
                    case ENERGY: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
            case DOWN: {
                switch (nodeType) {
                    case ITEM: 
                    case FLUID: {
                        return 0.75;
                    }
                    case ENERGY: 
                    case GAS: {
                        return 0.25;
                    }
                }
            }
            case NORTH: 
            case SOUTH: {
                return 0.5;
            }
            case EAST: {
                switch (nodeType) {
                    case ITEM: 
                    case ENERGY: {
                        return 0.25;
                    }
                    case FLUID: 
                    case GAS: {
                        return 0.75;
                    }
                }
            }
            case WEST: {
                switch (nodeType) {
                    case ITEM: 
                    case ENERGY: {
                        return 0.75;
                    }
                    case FLUID: 
                    case GAS: {
                        return 0.25;
                    }
                }
            }
        }
        return 0.0;
    }

    public static void scroll(InputEvent.MouseScrollEvent e) {
        ItemStack held;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (held = player.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof ColorFilterItem && player.func_225608_bj_()) {
            e.setCanceled(true);
        }
    }
}

