/*
 * Decompiled with CFR 0.152.
 */
package tfar.laserrelays;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import tfar.laserrelays.ExampleMod;
import tfar.laserrelays.NBTUtil;
import tfar.laserrelays.NodeBlockEntity;
import tfar.laserrelays.NodeType;
import tfar.laserrelays.item.NodeBlockItem;

public class NodeBlock
extends Block {
    public static final VoxelShape DOWN = Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape BLUE_UP = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)9.0, (double)5.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty ITEM_INPUT = BooleanProperty.func_177716_a((String)"item_input");
    public static final BooleanProperty FLUID_INPUT = BooleanProperty.func_177716_a((String)"fluid_input");
    public static final BooleanProperty ENERGY_INPUT = BooleanProperty.func_177716_a((String)"energy_input");
    public static final BooleanProperty GAS_INPUT = BooleanProperty.func_177716_a((String)"gas_input");
    public static final BooleanProperty ITEM = BooleanProperty.func_177716_a((String)"item");
    public static final BooleanProperty FLUID = BooleanProperty.func_177716_a((String)"fluid");
    public static final BooleanProperty ENERGY = BooleanProperty.func_177716_a((String)"energy");
    public static final BooleanProperty GAS = BooleanProperty.func_177716_a((String)"gas");
    public static final List<BooleanProperty> props = Lists.newArrayList((Object[])new BooleanProperty[]{ITEM, FLUID, ENERGY, ITEM});

    public NodeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ITEM_INPUT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FLUID_INPUT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ENERGY_INPUT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)GAS_INPUT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ITEM, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FLUID, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ENERGY, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)GAS, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        ItemStack stack = player.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            NodeType nodeType;
            NodeBlockEntity otherTerminal;
            NodeBlockEntity thisTerminal;
            BlockPos other;
            NodeType nodeTypeFromWire;
            if (stack.func_77973_b() == ExampleMod.wrench) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((NodeBlockEntity)worldIn.func_175625_s(pos)), (BlockPos)pos);
                return ActionResultType.SUCCESS;
            }
            if (stack.func_77973_b() == ExampleMod.wire) {
                if (stack.func_196082_o().func_74764_b("connected")) {
                    nodeTypeFromWire = NodeType.valueOf(stack.func_77978_p().func_74779_i("node_type"));
                    other = NBTUtil.readBlockPos(stack.func_77978_p());
                    if (!pos.equals((Object)other)) {
                        thisTerminal = (NodeBlockEntity)worldIn.func_175625_s(pos);
                        thisTerminal.connect(other, nodeTypeFromWire);
                        otherTerminal = (NodeBlockEntity)worldIn.func_175625_s(other);
                        otherTerminal.connect(pos, nodeTypeFromWire);
                    }
                    stack.func_77982_d(null);
                } else {
                    nodeType = NodeBlock.getNodeFromTrace(result, (Direction)state.func_177229_b((Property)FACING));
                    NBTUtil.writeBlockPos(stack.func_196082_o(), pos);
                    stack.func_77978_p().func_74778_a("node_type", nodeType.toString());
                }
            }
            if (stack.func_77973_b() == ExampleMod.wire_cutters) {
                if (stack.func_196082_o().func_74764_b("connected")) {
                    nodeTypeFromWire = NodeType.valueOf(stack.func_77978_p().func_74779_i("node_type"));
                    other = NBTUtil.readBlockPos(stack.func_77978_p());
                    if (!pos.equals((Object)other)) {
                        thisTerminal = (NodeBlockEntity)worldIn.func_175625_s(pos);
                        thisTerminal.disconnect(other, nodeTypeFromWire);
                        otherTerminal = (NodeBlockEntity)worldIn.func_175625_s(other);
                        otherTerminal.disconnect(pos, nodeTypeFromWire);
                    }
                    stack.func_77982_d(null);
                } else {
                    nodeType = NodeBlock.getNodeFromTrace(result, (Direction)state.func_177229_b((Property)FACING));
                    NBTUtil.writeBlockPos(stack.func_196082_o(), pos);
                    stack.func_77978_p().func_74778_a("node_type", nodeType.toString());
                }
            } else if (player.func_184586_b(handIn).func_190926_b()) {
                nodeType = NodeBlock.getNodeFromTrace(result, (Direction)state.func_177229_b((Property)FACING));
                switch (nodeType) {
                    case ITEM: {
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ITEM_INPUT, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)ITEM_INPUT) == false)));
                        player.func_145747_a((ITextComponent)new StringTextComponent("changed " + (Object)((Object)nodeType) + " to " + ((Boolean)state.func_177229_b((Property)ITEM_INPUT) != false ? "output" : "input")), Util.field_240973_b_);
                        break;
                    }
                    case FLUID: {
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FLUID_INPUT, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)FLUID_INPUT) == false)));
                        player.func_145747_a((ITextComponent)new StringTextComponent("changed " + (Object)((Object)nodeType) + " to " + ((Boolean)state.func_177229_b((Property)FLUID_INPUT) != false ? "output" : "input")), Util.field_240973_b_);
                        break;
                    }
                    case ENERGY: {
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ENERGY_INPUT, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)ENERGY_INPUT) == false)));
                        player.func_145747_a((ITextComponent)new StringTextComponent("changed " + (Object)((Object)nodeType) + " to " + ((Boolean)state.func_177229_b((Property)ENERGY_INPUT) != false ? "output" : "input")), Util.field_240973_b_);
                        break;
                    }
                    case GAS: {
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)GAS_INPUT, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)GAS_INPUT) == false)));
                        player.func_145747_a((ITextComponent)new StringTextComponent("changed " + (Object)((Object)nodeType) + " to " + ((Boolean)state.func_177229_b((Property)GAS_INPUT) != false ? "output" : "input")), Util.field_240973_b_);
                    }
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static double trim(double a) {
        return a - Math.floor(a);
    }

    public static NodeType getNodeFromTrace(Vector3d hit, Direction stateFacing) {
        Vector3d frac = new Vector3d(NodeBlock.trim(hit.field_72450_a), NodeBlock.trim(hit.field_72448_b), NodeBlock.trim(hit.field_72449_c));
        switch (stateFacing) {
            case WEST: {
                if (frac.field_72448_b > 0.5 && frac.field_72449_c > 0.5) {
                    return NodeType.ENERGY;
                }
                if (frac.field_72448_b > 0.5 && frac.field_72449_c < 0.5) {
                    return NodeType.GAS;
                }
                if (frac.field_72448_b < 0.5 && frac.field_72449_c > 0.5) {
                    return NodeType.ITEM;
                }
                if (frac.field_72448_b < 0.5 && frac.field_72449_c < 0.5) {
                    return NodeType.FLUID;
                }
            }
            case SOUTH: {
                if (frac.field_72450_a > 0.5 && frac.field_72448_b > 0.5) {
                    return NodeType.ENERGY;
                }
                if (frac.field_72450_a > 0.5 && frac.field_72448_b < 0.5) {
                    return NodeType.ITEM;
                }
                if (frac.field_72450_a < 0.5 && frac.field_72448_b > 0.5) {
                    return NodeType.GAS;
                }
                if (frac.field_72450_a < 0.5 && frac.field_72448_b < 0.5) {
                    return NodeType.FLUID;
                }
            }
            case EAST: {
                if (frac.field_72448_b > 0.5 && frac.field_72449_c > 0.5) {
                    return NodeType.GAS;
                }
                if (frac.field_72448_b > 0.5 && frac.field_72449_c < 0.5) {
                    return NodeType.ENERGY;
                }
                if (frac.field_72448_b < 0.5 && frac.field_72449_c > 0.5) {
                    return NodeType.FLUID;
                }
                if (frac.field_72448_b < 0.5 && frac.field_72449_c < 0.5) {
                    return NodeType.ITEM;
                }
            }
            case NORTH: {
                if (frac.field_72450_a > 0.5 && frac.field_72448_b > 0.5) {
                    return NodeType.GAS;
                }
                if (frac.field_72450_a > 0.5 && frac.field_72448_b < 0.5) {
                    return NodeType.FLUID;
                }
                if (frac.field_72450_a < 0.5 && frac.field_72448_b > 0.5) {
                    return NodeType.ENERGY;
                }
                if (frac.field_72450_a < 0.5 && frac.field_72448_b < 0.5) {
                    return NodeType.ITEM;
                }
            }
            case DOWN: {
                if (frac.field_72450_a > 0.5 && frac.field_72449_c > 0.5) {
                    return NodeType.FLUID;
                }
                if (frac.field_72450_a > 0.5 && frac.field_72449_c < 0.5) {
                    return NodeType.GAS;
                }
                if (frac.field_72450_a < 0.5 && frac.field_72449_c > 0.5) {
                    return NodeType.ITEM;
                }
                if (frac.field_72450_a < 0.5 && frac.field_72449_c < 0.5) {
                    return NodeType.ENERGY;
                }
            }
            case UP: {
                if (frac.field_72450_a > 0.5 && frac.field_72449_c < 0.5) {
                    return NodeType.FLUID;
                }
                if (frac.field_72450_a < 0.5 && frac.field_72449_c < 0.5) {
                    return NodeType.ITEM;
                }
                if (frac.field_72450_a < 0.5 && frac.field_72449_c > 0.5) {
                    return NodeType.ENERGY;
                }
                if (!(frac.field_72450_a > 0.5) || !(frac.field_72449_c > 0.5)) break;
                return NodeType.GAS;
            }
        }
        System.out.println("miss");
        return NodeType.ITEM;
    }

    public static NodeType getNodeFromTrace(BlockRayTraceResult result, Direction stateFacing) {
        Vector3d hitVec = result.func_216347_e();
        return NodeBlock.getNodeFromTrace(hitVec, stateFacing);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NodeBlockEntity thisNode = (NodeBlockEntity)worldIn.func_175625_s(pos);
        if (newState.func_177230_c() != state.func_177230_c()) {
            for (NodeType nodeType : NodeType.values()) {
                for (BlockPos otherPos : thisNode.connections.get((Object)nodeType)) {
                    NodeBlockEntity otherNode = (NodeBlockEntity)worldIn.func_175625_s(otherPos);
                    otherNode.disconnect(pos, nodeType);
                }
            }
        } else if (newState != state && this.isBreak(state, newState)) {
            NodeType nodeType = this.getBreak(state, newState);
            for (BlockPos otherPos : thisNode.connections.get((Object)nodeType)) {
                NodeBlockEntity otherNode = (NodeBlockEntity)worldIn.func_175625_s(otherPos);
                otherNode.disconnect(pos, nodeType);
                thisNode.disconnectNode(nodeType);
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean isBreak(BlockState old, BlockState newState) {
        return props.stream().anyMatch(bool -> (Boolean)old.func_177229_b((Property)bool) != false && (Boolean)newState.func_177229_b((Property)bool) == false);
    }

    public NodeType getBreak(BlockState old, BlockState newState) {
        return props.stream().filter(property -> (Boolean)old.func_177229_b((Property)property) != false && (Boolean)newState.func_177229_b((Property)property) == false).findFirst().map(property -> NodeType.valueOf(property.func_177701_a().toUpperCase())).orElseThrow(IllegalStateException::new);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 5);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case UP: {
                if (((Boolean)state.func_177229_b((Property)ITEM)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)9.0, (double)5.0));
                }
                if (((Boolean)state.func_177229_b((Property)FLUID)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)5.0));
                }
                if (((Boolean)state.func_177229_b((Property)ENERGY)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)9.0, (double)13.0));
                }
                if (((Boolean)state.func_177229_b((Property)GAS)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)9.0, (double)13.0));
                }
                return VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape[])shapes.toArray(new VoxelShape[0]));
            }
            case DOWN: {
                if (((Boolean)state.func_177229_b((Property)ITEM)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)3.0, (double)7.0, (double)11.0, (double)5.0, (double)16.0, (double)13.0));
                }
                if (((Boolean)state.func_177229_b((Property)FLUID)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)11.0, (double)7.0, (double)11.0, (double)13.0, (double)16.0, (double)13.0));
                }
                if (((Boolean)state.func_177229_b((Property)ENERGY)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)3.0, (double)7.0, (double)3.0, (double)5.0, (double)16.0, (double)5.0));
                }
                if (((Boolean)state.func_177229_b((Property)GAS)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)11.0, (double)7.0, (double)3.0, (double)13.0, (double)16.0, (double)5.0));
                }
                return VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape[])shapes.toArray(new VoxelShape[0]));
            }
            case NORTH: {
                if (((Boolean)state.func_177229_b((Property)ITEM)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)3.0, (double)3.0, (double)7.0, (double)5.0, (double)5.0, (double)16.0));
                }
                if (((Boolean)state.func_177229_b((Property)FLUID)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)11.0, (double)3.0, (double)7.0, (double)13.0, (double)5.0, (double)16.0));
                }
                if (((Boolean)state.func_177229_b((Property)ENERGY)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)3.0, (double)11.0, (double)7.0, (double)5.0, (double)13.0, (double)16.0));
                }
                if (((Boolean)state.func_177229_b((Property)GAS)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)11.0, (double)11.0, (double)7.0, (double)13.0, (double)13.0, (double)16.0));
                }
                return VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape[])shapes.toArray(new VoxelShape[0]));
            }
            case SOUTH: {
                if (((Boolean)state.func_177229_b((Property)ITEM)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)11.0, (double)3.0, (double)0.0, (double)13.0, (double)5.0, (double)9.0));
                }
                if (((Boolean)state.func_177229_b((Property)FLUID)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)5.0, (double)5.0, (double)9.0));
                }
                if (((Boolean)state.func_177229_b((Property)ENERGY)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)11.0, (double)11.0, (double)0.0, (double)13.0, (double)13.0, (double)9.0));
                }
                if (((Boolean)state.func_177229_b((Property)GAS)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)3.0, (double)11.0, (double)0.0, (double)5.0, (double)13.0, (double)9.0));
                }
                return VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape[])shapes.toArray(new VoxelShape[0]));
            }
            case EAST: {
                if (((Boolean)state.func_177229_b((Property)ITEM)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)9.0, (double)5.0, (double)5.0));
                }
                if (((Boolean)state.func_177229_b((Property)FLUID)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)0.0, (double)3.0, (double)11.0, (double)9.0, (double)5.0, (double)13.0));
                }
                if (((Boolean)state.func_177229_b((Property)ENERGY)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)0.0, (double)11.0, (double)3.0, (double)9.0, (double)13.0, (double)5.0));
                }
                if (((Boolean)state.func_177229_b((Property)GAS)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)0.0, (double)11.0, (double)11.0, (double)9.0, (double)13.0, (double)13.0));
                }
                return VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape[])shapes.toArray(new VoxelShape[0]));
            }
            case WEST: {
                if (((Boolean)state.func_177229_b((Property)ITEM)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)7.0, (double)3.0, (double)11.0, (double)16.0, (double)5.0, (double)13.0));
                }
                if (((Boolean)state.func_177229_b((Property)FLUID)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)7.0, (double)3.0, (double)3.0, (double)16.0, (double)5.0, (double)5.0));
                }
                if (((Boolean)state.func_177229_b((Property)ENERGY)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)7.0, (double)11.0, (double)11.0, (double)16.0, (double)13.0, (double)13.0));
                }
                if (((Boolean)state.func_177229_b((Property)GAS)).booleanValue()) {
                    shapes.add(Block.func_208617_a((double)7.0, (double)11.0, (double)3.0, (double)16.0, (double)13.0, (double)5.0));
                }
                return VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape[])shapes.toArray(new VoxelShape[0]));
            }
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public static void replace(BlockEvent.BreakEvent e) {
        NodeType nodeType;
        BlockState newState;
        RayTraceResult result;
        BlockState state = e.getState();
        PlayerEntity player = e.getPlayer();
        BlockPos pos = e.getPos();
        IWorld world = e.getWorld();
        if (state.func_177230_c() instanceof NodeBlock && (result = player.func_213324_a(player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e(), 0.0f, false)) instanceof BlockRayTraceResult && !(newState = NodeBlock.breakNode(state, nodeType = NodeBlock.getNodeFromTrace((BlockRayTraceResult)result, (Direction)state.func_177229_b((Property)FACING)))).isAir((IBlockReader)world, pos)) {
            world.func_180501_a(pos, newState, 3);
            ItemStack stack = new ItemStack((IItemProvider)NodeBlock.getItemFromNode(nodeType));
            world.func_217376_c((Entity)new ItemEntity((World)world, (double)e.getPos().func_177958_n(), (double)e.getPos().func_177956_o() + 0.5, (double)e.getPos().func_177952_p(), stack));
            e.setCanceled(true);
        }
    }

    public static Item getItemFromNode(NodeType node) {
        switch (node) {
            case ITEM: {
                return ExampleMod.item_node;
            }
            case FLUID: {
                return ExampleMod.fluid_node;
            }
            case ENERGY: {
                return ExampleMod.energy_node;
            }
            case GAS: {
                return ExampleMod.gas_node;
            }
        }
        throw new IllegalStateException();
    }

    public static BlockState breakNode(BlockState original, NodeType nodeType) {
        boolean broken = false;
        BlockState newState = original;
        switch (nodeType) {
            case ITEM: {
                if (((Boolean)original.func_177229_b((Property)FLUID)).booleanValue() || ((Boolean)original.func_177229_b((Property)ENERGY)).booleanValue() || ((Boolean)original.func_177229_b((Property)GAS)).booleanValue()) {
                    newState = (BlockState)newState.func_206870_a((Property)ITEM, (Comparable)Boolean.valueOf(false));
                    break;
                }
                broken = true;
                break;
            }
            case FLUID: {
                if (((Boolean)original.func_177229_b((Property)ITEM)).booleanValue() || ((Boolean)original.func_177229_b((Property)ENERGY)).booleanValue() || ((Boolean)original.func_177229_b((Property)GAS)).booleanValue()) {
                    newState = (BlockState)newState.func_206870_a((Property)FLUID, (Comparable)Boolean.valueOf(false));
                    break;
                }
                broken = true;
                break;
            }
            case ENERGY: {
                if (((Boolean)original.func_177229_b((Property)ITEM)).booleanValue() || ((Boolean)original.func_177229_b((Property)FLUID)).booleanValue() || ((Boolean)original.func_177229_b((Property)GAS)).booleanValue()) {
                    newState = (BlockState)newState.func_206870_a((Property)ENERGY, (Comparable)Boolean.valueOf(false));
                    break;
                }
                broken = true;
                break;
            }
            case GAS: {
                if (((Boolean)original.func_177229_b((Property)ITEM)).booleanValue() || ((Boolean)original.func_177229_b((Property)FLUID)).booleanValue() || ((Boolean)original.func_177229_b((Property)ENERGY)).booleanValue()) {
                    newState = (BlockState)newState.func_206870_a((Property)GAS, (Comparable)Boolean.valueOf(false));
                    break;
                }
                broken = true;
            }
        }
        if (broken) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return newState;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        if (stack.func_77973_b() instanceof NodeBlockItem) {
            BlockState curState = context.func_195991_k().func_180495_p(context.func_195995_a());
            NodeType nodeType = ((NodeBlockItem)stack.func_77973_b()).nodeType;
            if (!(curState.func_177230_c() instanceof NodeBlock)) {
                BlockState newState = super.func_196258_a(context);
                newState = (BlockState)newState.func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
                switch (nodeType) {
                    case ITEM: {
                        return (BlockState)newState.func_206870_a((Property)ITEM, (Comparable)Boolean.valueOf(true));
                    }
                    case FLUID: {
                        return (BlockState)newState.func_206870_a((Property)FLUID, (Comparable)Boolean.valueOf(true));
                    }
                    case ENERGY: {
                        return (BlockState)newState.func_206870_a((Property)ENERGY, (Comparable)Boolean.valueOf(true));
                    }
                    case GAS: {
                        return (BlockState)newState.func_206870_a((Property)GAS, (Comparable)Boolean.valueOf(true));
                    }
                }
                return null;
            }
            switch (nodeType) {
                case ITEM: {
                    if (!((Boolean)curState.func_177229_b((Property)ITEM)).booleanValue()) {
                        return (BlockState)curState.func_206870_a((Property)ITEM, (Comparable)Boolean.valueOf(true));
                    }
                }
                case FLUID: {
                    if (!((Boolean)curState.func_177229_b((Property)FLUID)).booleanValue()) {
                        return (BlockState)curState.func_206870_a((Property)FLUID, (Comparable)Boolean.valueOf(true));
                    }
                }
                case ENERGY: {
                    if (!((Boolean)curState.func_177229_b((Property)ENERGY)).booleanValue()) {
                        return (BlockState)curState.func_206870_a((Property)ENERGY, (Comparable)Boolean.valueOf(true));
                    }
                }
                case GAS: {
                    if (((Boolean)curState.func_177229_b((Property)GAS)).booleanValue()) break;
                    return (BlockState)curState.func_206870_a((Property)GAS, (Comparable)Boolean.valueOf(true));
                }
            }
            return null;
        }
        return super.func_196258_a(context);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        Item item = useContext.func_195996_i().func_77973_b();
        if (item instanceof NodeBlockItem) {
            NodeType type = ((NodeBlockItem)item).nodeType;
            switch (type) {
                case ITEM: {
                    return (Boolean)state.func_177229_b((Property)ITEM) == false;
                }
                case FLUID: {
                    return (Boolean)state.func_177229_b((Property)FLUID) == false;
                }
                case ENERGY: {
                    return (Boolean)state.func_177229_b((Property)ENERGY) == false;
                }
                case GAS: {
                    return (Boolean)state.func_177229_b((Property)GAS) == false;
                }
            }
        }
        return super.func_196253_a(state, useContext);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ITEM, FLUID, ENERGY, GAS, ITEM_INPUT, FLUID_INPUT, ENERGY_INPUT, GAS_INPUT});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new NodeBlockEntity();
    }
}

