/*
 * Decompiled with CFR 0.152.
 */
package tfar.laserrelays;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tfar.laserrelays.ExampleMod;
import tfar.laserrelays.FilterItemStackHandler;
import tfar.laserrelays.NBTUtil;
import tfar.laserrelays.NodeBlock;
import tfar.laserrelays.NodeContainer;
import tfar.laserrelays.NodeType;
import tfar.laserrelays.compat.MekanismProxy;

public class NodeBlockEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final boolean mekanism = ModList.get().isLoaded("mekanism");
    public Map<NodeType, Set<BlockPos>> connections = new EnumMap<NodeType, Set<BlockPos>>(NodeType.class);
    protected HashSet<NodeType> whitelist = new HashSet();
    public FilterItemStackHandler filter = new FilterItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            NodeBlockEntity.this.func_70296_d();
        }
    };
    public int max_slots = 9;
    public int index = 0;
    public int lastIndex = 0;
    int tick_rate = 5;

    public NodeBlockEntity() {
        super(ExampleMod.BLOCK_ENTITY);
        for (NodeType nodeType : NodeType.values()) {
            this.connections.put(nodeType, new HashSet());
        }
    }

    public void connect(BlockPos other, NodeType node) {
        if (!this.connections.get((Object)node).contains(other)) {
            this.connections.get((Object)node).add(other);
            this.func_70296_d();
        }
    }

    public void disconnect(BlockPos other, NodeType node) {
        if (this.connections.get((Object)node).contains(other)) {
            this.connections.get((Object)node).remove(other);
            this.func_70296_d();
        }
    }

    public void disconnectNode(NodeType node) {
        if (!this.connections.get((Object)node).isEmpty()) {
            this.connections.get((Object)node).clear();
            this.func_70296_d();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        CompoundNBT nbt = compound.func_74775_l("connections");
        for (NodeType nodeType : NodeType.values()) {
            this.connections.get((Object)nodeType).clear();
            ListNBT listNBT = nbt.func_150295_c(nodeType.toString(), 10);
            HashSet<BlockPos> blockPosSet = new HashSet<BlockPos>();
            NBTUtil.readBlockPosList(listNBT, blockPosSet);
            this.connections.get((Object)nodeType).addAll(blockPosSet);
        }
        this.filter.deserializeNBT(compound.func_74775_l("filter"));
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT compound1 = new CompoundNBT();
        for (NodeType nodeType : NodeType.values()) {
            ListNBT listNBT = new ListNBT();
            Set<BlockPos> posSet = this.connections.get((Object)nodeType);
            NBTUtil.writeBlockPosList(listNBT, posSet);
            compound1.func_218657_a(nodeType.toString(), (INBT)listNBT);
        }
        compound.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        compound.func_218657_a("connections", (INBT)compound1);
        return super.func_189515_b(compound);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(null, packet.func_148857_g());
    }

    public void func_73660_a() {
        if (!this.connections.isEmpty() && this.field_145850_b.func_82737_E() % 5L == 0L && !this.field_145850_b.field_72995_K) {
            Direction dir1;
            TileEntity inputTileEntity;
            BlockState state = this.func_195044_w();
            if (((Boolean)state.func_177229_b((Property)NodeBlock.ITEM)).booleanValue() && ((Boolean)state.func_177229_b((Property)NodeBlock.ITEM_INPUT)).booleanValue()) {
                this.tickItems(state);
            }
            if (((Boolean)state.func_177229_b((Property)NodeBlock.FLUID)).booleanValue() && ((Boolean)state.func_177229_b((Property)NodeBlock.FLUID_INPUT)).booleanValue() && (inputTileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir1 = ((Direction)state.func_177229_b((Property)NodeBlock.FACING)).func_176734_d()))) != null) {
                inputTileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir1).ifPresent(iFluidHandler1 -> {
                    FluidStack testFluid = iFluidHandler1.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    if (!testFluid.isEmpty()) {
                        for (BlockPos pos1 : this.connections.get((Object)NodeType.FLUID)) {
                            Direction dir2;
                            TileEntity outputTileEntity;
                            if (testFluid.isEmpty()) break;
                            BlockState otherNodeState = this.field_145850_b.func_180495_p(pos1);
                            if (!(otherNodeState.func_177230_c() instanceof NodeBlock) || ((Boolean)otherNodeState.func_177229_b((Property)NodeBlock.FLUID_INPUT)).booleanValue() || (outputTileEntity = this.field_145850_b.func_175625_s(pos1.func_177972_a((dir2 = (Direction)otherNodeState.func_177229_b((Property)NodeBlock.FACING)).func_176734_d()))) == null) continue;
                            outputTileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir2).ifPresent(iFluidHandler2 -> {
                                int filled = iFluidHandler2.fill(testFluid, IFluidHandler.FluidAction.EXECUTE);
                                iFluidHandler1.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                                testFluid.shrink(filled);
                            });
                        }
                    }
                });
            }
            if (((Boolean)state.func_177229_b((Property)NodeBlock.ENERGY)).booleanValue() && ((Boolean)state.func_177229_b((Property)NodeBlock.ENERGY_INPUT)).booleanValue() && (inputTileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir1 = ((Direction)state.func_177229_b((Property)NodeBlock.FACING)).func_176734_d()))) != null) {
                inputTileEntity.getCapability(CapabilityEnergy.ENERGY, dir1).ifPresent(energyInput -> {
                    int testEnergy = energyInput.extractEnergy(Integer.MAX_VALUE, true);
                    for (BlockPos pos1 : this.connections.get((Object)NodeType.ENERGY)) {
                        int accepted;
                        IEnergyStorage output;
                        Direction dir2;
                        TileEntity outputTileEntity;
                        BlockState otherNodeState = this.field_145850_b.func_180495_p(pos1);
                        if (!(otherNodeState.func_177230_c() instanceof NodeBlock) || ((Boolean)otherNodeState.func_177229_b((Property)NodeBlock.ENERGY_INPUT)).booleanValue() || (outputTileEntity = this.field_145850_b.func_175625_s(pos1.func_177972_a(dir2 = ((Direction)otherNodeState.func_177229_b((Property)NodeBlock.FACING)).func_176734_d()))) == null || (output = (IEnergyStorage)outputTileEntity.getCapability(CapabilityEnergy.ENERGY, dir2).orElse(null)) == null || (accepted = output.receiveEnergy(testEnergy, false)) <= 0) continue;
                        energyInput.extractEnergy(accepted, false);
                        if ((testEnergy -= accepted) > 0) continue;
                        break;
                    }
                });
            }
            if (mekanism && ((Boolean)state.func_177229_b((Property)NodeBlock.GAS)).booleanValue() && ((Boolean)state.func_177229_b((Property)NodeBlock.GAS_INPUT)).booleanValue()) {
                this.tickGas(state);
            }
        }
    }

    public void tickGas(BlockState state) {
        MekanismProxy.tickGas(this, state);
    }

    public void tickItems(BlockState state) {
        Direction dir1 = (Direction)state.func_177229_b((Property)NodeBlock.FACING);
        TileEntity inputTileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir1.func_176734_d()));
        if (inputTileEntity != null) {
            inputTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir1).ifPresent(itemHandler -> {
                int slots = itemHandler.getSlots();
                int j = this.lastIndex;
                int toScan = Math.min(this.max_slots, slots);
                for (int i = 0; i < toScan; ++i) {
                    ItemStack testStack;
                    if (j >= slots) {
                        j = 0;
                    }
                    if (!(testStack = itemHandler.extractItem(j, Integer.MAX_VALUE, true)).func_190926_b() && this.checkInputFilter(testStack)) {
                        ItemStack remainder = testStack.func_77946_l();
                        for (BlockPos pos1 : this.connections.get((Object)NodeType.ITEM)) {
                            IItemHandler output;
                            Direction dir2;
                            TileEntity outputTileEntity;
                            BlockState otherNodeState = this.field_145850_b.func_180495_p(pos1);
                            if (!(otherNodeState.func_177230_c() instanceof NodeBlock) || ((Boolean)otherNodeState.func_177229_b((Property)NodeBlock.ITEM_INPUT)).booleanValue() || (outputTileEntity = this.field_145850_b.func_175625_s(pos1.func_177972_a(dir2 = ((Direction)otherNodeState.func_177229_b((Property)NodeBlock.FACING)).func_176734_d()))) == null || (output = (IItemHandler)outputTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir2.func_176734_d()).orElse(null)) == null) continue;
                            for (int k = 0; k < output.getSlots(); ++k) {
                                int countInserted;
                                ItemStack inserted = output.insertItem(k, remainder, false);
                                if (inserted.func_190926_b()) {
                                    countInserted = remainder.func_190916_E();
                                    itemHandler.extractItem(j, countInserted, false);
                                    break;
                                }
                                if (inserted.func_190916_E() >= remainder.func_190916_E()) continue;
                                countInserted = remainder.func_190916_E() - inserted.func_190916_E();
                                remainder.func_190918_g(countInserted);
                                itemHandler.extractItem(j, countInserted, false);
                            }
                            if (!remainder.func_190926_b()) continue;
                            break;
                        }
                    }
                    ++j;
                }
                this.lastIndex = j;
            });
        }
    }

    protected boolean checkInputFilter(ItemStack testStack) {
        return this.filter.test(testStack);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("filter");
    }

    @Nullable
    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        return new NodeContainer(p_createMenu_1_, p_createMenu_2_, this.field_174879_c);
    }
}

