/*
 * Decompiled with CFR 0.152.
 */
package com.zooi.unflavoured.pipes;

import com.zooi.unflavoured.pipes.CopperPipeBlock;
import com.zooi.unflavoured.pipes.IContainerUtils;
import com.zooi.unflavoured.pipes.UnflavouredPipesMod;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2700;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3954;
import net.minecraft.class_3962;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperPipeBlockEntity
extends class_2621 {
    public static final int TRANSFER_COOLDOWN = 5;
    private class_2371<class_1799> items = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private int timer = 0;
    private int selectedDirIndex;

    public CopperPipeBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(UnflavouredPipesMod.ModBlockEntityType.COPPER_PIPE, blockPos, blockState);
    }

    public static void pushItemsTick(class_1937 world, class_2338 blockPos, class_2680 state, CopperPipeBlockEntity copperPipe) {
        class_2350 dir;
        class_2350[] directions;
        if (world.method_8608() || !(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        ++copperPipe.timer;
        if (copperPipe.timer < 5) {
            return;
        }
        copperPipe.timer = 0;
        if ((Integer)state.method_11654((class_2769)CopperPipeBlock.POWER) == 0) {
            return;
        }
        for (class_2350 dir2 : directions = class_2350.values()) {
            CopperPipeBlockEntity.handleDir(dir2, serverWorld, blockPos, state, copperPipe, Flow.INCOMING);
        }
        for (int i = 0; i < directions.length && !CopperPipeBlockEntity.handleDir(dir = directions[copperPipe.selectedDirIndex++ % directions.length], serverWorld, blockPos, state, copperPipe, Flow.OUTGOING); ++i) {
        }
    }

    private static boolean handleDir(class_2350 direction, class_3218 world, class_2338 pipePos, class_2680 pipeState, CopperPipeBlockEntity pipeBlockEntity, Flow flow) {
        class_2338 directionPos = pipePos.method_10093(direction);
        class_243 directionPosCenter = directionPos.method_46558();
        class_2680 stateInDirection = world.method_8320(directionPos);
        boolean didSomething = false;
        class_1263 targetContainer = CopperPipeBlockEntity.getContainerAt((class_1937)world, directionPosCenter.field_1352, directionPosCenter.field_1351, directionPosCenter.field_1350);
        if (targetContainer != null) {
            IContainerUtils.Options options = new IContainerUtils.Options();
            options.maxCount = 1;
            options.world = world;
            if (flow == Flow.OUTGOING && CopperPipeBlockEntity.isOutput(direction, (class_1937)world, pipePos, pipeState)) {
                options.sourceContainer = pipeBlockEntity;
                options.destinationContainer = targetContainer;
                options.sourcePos = pipePos;
                options.destinationPos = directionPos;
                options.direction = direction;
                didSomething = UnflavouredPipesMod.containerUtils.transferFirstAvailableItem(options);
            } else if (flow == Flow.INCOMING && CopperPipeBlockEntity.isInput(direction, (class_1937)world, pipePos, pipeState)) {
                options.sourceContainer = targetContainer;
                options.destinationContainer = pipeBlockEntity;
                options.sourcePos = directionPos;
                options.destinationPos = pipePos;
                options.direction = direction;
                didSomething = UnflavouredPipesMod.containerUtils.transferFirstAvailableItem(options);
            }
        }
        if (!didSomething && flow == Flow.OUTGOING && stateInDirection.method_27852(class_2246.field_17563)) {
            didSomething = CopperPipeBlockEntity.handleComposter((class_1937)world, pipeBlockEntity, stateInDirection, directionPos, didSomething);
        }
        if (!didSomething && stateInDirection.method_27852(class_2246.field_10398) && flow == Flow.OUTGOING) {
            CopperPipeBlockEntity.handleEnderFrame((class_1937)world, pipeBlockEntity, stateInDirection, directionPos);
        }
        return didSomething;
    }

    private static boolean handleComposter(class_1937 world, CopperPipeBlockEntity pipeBlockEntity, class_2680 stateInDirection, class_2338 directionPos, boolean didSomething) {
        class_2680 composterState = stateInDirection;
        if ((Integer)composterState.method_11654((class_2769)class_3962.field_17565) < 7) {
            for (class_1799 stack : pipeBlockEntity.method_11282()) {
                if (stack.method_7960() || !class_3962.field_17566.containsKey((Object)stack.method_7909())) continue;
                Integer oldLvl = (Integer)composterState.method_11654((class_2769)class_3962.field_17565);
                Integer newLvl = (Integer)(composterState = class_3962.method_26373(null, (class_2680)composterState, (class_3218)((class_3218)world), (class_1799)stack, (class_2338)directionPos)).method_11654((class_2769)class_3962.field_17565);
                world.method_8396(null, directionPos, newLvl > oldLvl ? class_3417.field_17608 : class_3417.field_17607, class_3419.field_15245, 1.0f, 1.0f);
                didSomething = true;
            }
        }
        return didSomething;
    }

    private static void handleEnderFrame(class_1937 world, CopperPipeBlockEntity pipeBlockEntity, class_2680 stateInDirection, class_2338 directionPos) {
        if (((Boolean)stateInDirection.method_11654((class_2769)class_2333.field_10958)).booleanValue()) {
            return;
        }
        for (class_1799 itemStack : pipeBlockEntity.method_11282()) {
            if (!itemStack.method_31574(class_1802.field_8449) || itemStack.method_7947() <= 0) continue;
            class_2680 newState = (class_2680)stateInDirection.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(true));
            world.method_8652(directionPos, newState, 2);
            world.method_8455(directionPos, class_2246.field_10398);
            itemStack.method_7934(1);
            world.method_20290(1503, directionPos, 0);
            class_2700.class_2702 blockPatternMatch = class_2333.method_10054().method_11708((class_4538)world, directionPos);
            if (blockPatternMatch == null) continue;
            class_2338 blockPos2 = blockPatternMatch.method_11715().method_10069(-3, 0, -3);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    world.method_8652(blockPos2.method_10069(i, 0, j), class_2246.field_10027.method_9564(), 2);
                }
            }
            world.method_8474(1038, blockPos2.method_10069(1, 0, 1), 0);
        }
    }

    public static boolean isOutput(class_2350 direction, class_1937 world, class_2338 pipePos, class_2680 pipeState) {
        class_2746 prop = CopperPipeBlock.getConnection(direction);
        if (((Boolean)pipeState.method_11654((class_2769)prop)).booleanValue()) {
            class_2338 otherPos = pipePos.method_10093(direction);
            class_2680 otherState = world.method_8320(otherPos);
            if (otherState.method_27852(UnflavouredPipesMod.ModBlocks.COPPER_PIPE)) {
                return (Integer)otherState.method_11654((class_2769)CopperPipeBlock.POWER) <= (Integer)pipeState.method_11654((class_2769)CopperPipeBlock.POWER);
            }
            return (Integer)pipeState.method_11654((class_2769)CopperPipeBlock.POWER) != 15;
        }
        return false;
    }

    public static boolean isInput(class_2350 direction, class_1937 world, class_2338 pipePos, class_2680 pipeState) {
        class_2746 prop = CopperPipeBlock.getConnection(direction);
        if (((Boolean)pipeState.method_11654((class_2769)prop)).booleanValue()) {
            class_2338 otherPos = pipePos.method_10093(direction);
            class_2680 otherState = world.method_8320(otherPos);
            if (otherState.method_27852(UnflavouredPipesMod.ModBlocks.COPPER_PIPE)) {
                return false;
            }
            return (Integer)pipeState.method_11654((class_2769)CopperPipeBlock.POWER) == 15;
        }
        return false;
    }

    @Nullable
    private static class_1263 getContainerAt(class_1937 world, double x, double y, double z) {
        class_1263 c;
        class_2586 blockEntity;
        class_1278 container = null;
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            class_3954 worldlyContainerHolder = (class_3954)block;
            container = worldlyContainerHolder.method_17680(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_31709() && (blockEntity = world.method_8321(blockPos)) instanceof class_1263 && (container = (c = (class_1263)blockEntity)) instanceof class_2595 && block instanceof class_2281) {
            class_2281 chest = (class_2281)block;
            container = class_2281.method_17458((class_2281)chest, (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        return container;
    }

    public int method_5439() {
        return this.method_11282().size();
    }

    public boolean method_5442() {
        return this.method_11282().stream().allMatch(class_1799::method_7960);
    }

    @NotNull
    public class_1799 method_5438(int i) {
        return (class_1799)this.method_11282().get(i);
    }

    @NotNull
    public class_1799 method_5434(int i, int j) {
        class_1799 itemStack = class_1262.method_5430(this.method_11282(), (int)i, (int)j);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    @NotNull
    public class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> it) {
        this.items = it;
    }

    @NotNull
    public class_1799 method_5441(int i) {
        return class_1262.method_5428(this.method_11282(), (int)i);
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.method_11282().set(i, (Object)itemStack);
        if (itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.method_11282().clear();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43473();
    }

    protected class_1703 method_5465(int i, class_1661 inventory) {
        return null;
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(compoundTag)) {
            class_1262.method_5429((class_2487)compoundTag, this.items);
        }
        this.timer = compoundTag.method_10550("Timer");
        this.selectedDirIndex = compoundTag.method_10550("SelectedDirectionIndex");
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        if (!this.method_11286(compoundTag)) {
            class_1262.method_5426((class_2487)compoundTag, this.items);
        }
        compoundTag.method_10569("Timer", this.timer);
        compoundTag.method_10569("SelectedDirectionIndex", this.selectedDirIndex);
    }

    public boolean method_17489(class_1657 player) {
        return false;
    }

    private static enum Flow {
        INCOMING,
        OUTGOING;

    }
}

