/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cursedspawners.entity;

import com.mojang.serialization.DynamicOps;
import com.provismet.cursedspawners.CursedSpawnersMain;
import com.provismet.cursedspawners.registries.CSEntityTypes;
import com.provismet.cursedspawners.registries.CSSoundEvents;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1317;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SpawnerMimicEntity
extends class_1588 {
    private int spawnDelay = 20;
    private class_6005<class_1952> spawnPotentials = class_6005.method_38062();
    private class_1952 spawnEntry;
    private double mobEntryRotation;
    private double prevMobEntryRotation;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private class_1297 renderedEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;
    public final class_7094 idleState = new class_7094();
    public final class_7094 attackState = new class_7094();
    public final class_7094 spawnState = new class_7094();
    private static final class_2940<Boolean> RUNNING_SPAWN_ANIMATION = class_2945.method_12791(SpawnerMimicEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2487> RENDERED_ENTITY = class_2945.method_12791(SpawnerMimicEntity.class, (class_2941)class_2943.field_13318);

    public SpawnerMimicEntity(class_1937 world) {
        this(CSEntityTypes.SPAWNER_MIMIC, world);
    }

    public SpawnerMimicEntity(class_1299<? extends SpawnerMimicEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 30;
    }

    public static class_5132.class_5133 getSpawnerMimicAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23718, 0.8).method_26868(class_5134.field_23724, 25.0).method_26868(class_5134.field_23725, 5.0).method_26868(class_5134.field_23719, 0.275).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23722, 1.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6201.method_6277(0, (class_1352)new MimicAppearGoal(this));
        this.field_6201.method_6277(1, (class_1352)new MimicAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 16.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RUNNING_SPAWN_ANIMATION, (Object)false);
        builder.method_56912(RENDERED_ENTITY, (Object)new class_2487());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.spawnState.method_41322(this.field_6012);
        this.setRunningSpawnAnimation(true);
    }

    public void method_5749(class_2487 nbt) {
        boolean bl2;
        super.method_5749(nbt);
        this.spawnDelay = nbt.method_10568("Delay");
        boolean bl = nbt.method_10573("SpawnData", 10);
        if (bl) {
            class_1952 mobSpawnerEntry = class_1952.field_34460.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("SpawnData")).resultOrPartial(string -> CursedSpawnersMain.LOGGER.warn("Invalid SpawnData: {}", string)).orElseGet(class_1952::new);
            this.setSpawnEntry(mobSpawnerEntry);
        }
        if (bl2 = nbt.method_10573("SpawnPotentials", 9)) {
            class_2499 nbtList = nbt.method_10554("SpawnPotentials", 10);
            this.spawnPotentials = class_1952.field_34461.parse((DynamicOps)class_2509.field_11560, (Object)nbtList).resultOrPartial(error -> CursedSpawnersMain.LOGGER.warn("Invalid SpawnPotentials list: {}", error)).orElseGet(() -> class_6005.method_38062());
        } else {
            this.spawnPotentials = class_6005.method_38061((Object)(this.spawnEntry != null ? this.spawnEntry : new class_1952()));
        }
        if (nbt.method_10573("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.method_10568("MinSpawnDelay");
            this.maxSpawnDelay = nbt.method_10568("MaxSpawnDelay");
            this.spawnCount = nbt.method_10568("SpawnCount");
        }
        if (nbt.method_10573("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.method_10568("MaxNearbyEntities");
            this.requiredPlayerRange = nbt.method_10568("RequiredPlayerRange");
        }
        if (nbt.method_10573("SpawnRange", 99)) {
            this.spawnRange = nbt.method_10568("SpawnRange");
        }
        this.renderedEntity = null;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10575("Delay", (short)this.spawnDelay);
        nbt.method_10575("MinSpawnDelay", (short)this.minSpawnDelay);
        nbt.method_10575("MaxSpawnDelay", (short)this.maxSpawnDelay);
        nbt.method_10575("SpawnCount", (short)this.spawnCount);
        nbt.method_10575("MaxNearbyEntities", (short)this.maxNearbyEntities);
        nbt.method_10575("RequiredPlayerRange", (short)this.requiredPlayerRange);
        nbt.method_10575("SpawnRange", (short)this.spawnRange);
        if (this.spawnEntry != null) {
            nbt.method_10566("SpawnData", (class_2520)class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.spawnEntry).getOrThrow(string -> new IllegalStateException("Invalid SpawnData: " + string)));
        }
        nbt.method_10566("SpawnPotentials", (class_2520)class_1952.field_34461.encodeStart((DynamicOps)class_2509.field_11560, this.spawnPotentials).getOrThrow());
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
    }

    public void method_5773() {
        class_1937 class_19372;
        this.prevMobEntryRotation = this.mobEntryRotation;
        this.mobEntryRotation = (this.mobEntryRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        this.setupAnimations();
        if (!this.method_5987() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.spawnDelay < 0) {
                this.updateSpawns();
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                this.spawn(serverWorld);
            }
        }
        if (this.method_37908().method_8608() && this.getRenderedEntity() != null) {
            double x = this.method_23317() + this.field_5974.method_43058() - 0.5;
            double y = this.method_23318() + this.field_5974.method_43058();
            double z = this.method_23321() + this.field_5974.method_43058() - 0.5;
            this.method_37908().method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 0.0, 0.0);
            this.method_37908().method_8406((class_2394)class_2398.field_11240, x, y, z, 0.0, 0.0, 0.0);
        }
        super.method_5773();
    }

    private void setupAnimations() {
        if (!this.method_6150()) {
            this.idleState.method_41324(this.field_6012);
        } else {
            this.idleState.method_41325();
        }
        if (this.isRunningSpawnAnimation()) {
            this.spawnState.method_41324(this.field_6012);
        }
        if (!this.method_6510()) {
            this.attackState.method_41325();
        }
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        this.method_37908().method_8421((class_1297)this, (byte)4);
        return super.method_6121(world, target);
    }

    public void method_5711(byte status) {
        super.method_5711(status);
        if (status == 4) {
            this.attackState.method_41322(this.field_6012);
        }
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    public void method_5844(class_2680 state, class_243 multiplier) {
        if (!state.method_27852(class_2246.field_10343)) {
            super.method_5844(state, multiplier);
        }
    }

    protected void method_59928() {
        this.method_56078(CSSoundEvents.ENTITY_MIMIC_ATTACK);
    }

    protected class_3414 method_5994() {
        return CSSoundEvents.ENTITY_MIMIC_AMBIENT;
    }

    protected class_3414 method_6002() {
        return CSSoundEvents.ENTITY_MIMIC_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return CSSoundEvents.ENTITY_MIMIC_HURT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_56078(CSSoundEvents.ENTITY_MIMIC_STEP);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        class_1792 class_17922 = held.method_7909();
        if (class_17922 instanceof class_1826) {
            class_1826 spawnEgg = (class_1826)class_17922;
            class_1299 entityType = spawnEgg.method_8015(held);
            this.setEntityType(entityType);
            this.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28725, this.method_24515());
            held.method_7934(1);
            this.spawnDelay = 20;
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    protected class_1269 method_29506(class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        if (held.method_7909() instanceof class_1826) {
            return class_1269.field_5811;
        }
        return super.method_29506(player, hand);
    }

    protected void spawn(class_3218 serverWorld) {
        boolean spawnedSuccessfully = false;
        class_1952 mobSpawnerEntry = this.getSpawnEntry();
        for (int i = 0; i < this.spawnCount; ++i) {
            class_1308 mobEntity;
            class_1952.class_6542 customSpawnRules;
            double mobZ;
            class_2487 nbtCompound = mobSpawnerEntry.method_38093();
            Optional optionalEntityType = class_1299.method_17684((class_2487)nbtCompound);
            if (optionalEntityType.isEmpty()) {
                this.updateSpawns();
                return;
            }
            class_2499 nbtList = nbtCompound.method_10554("Pos", 6);
            int nbtSize = nbtList.size();
            double mobX = nbtSize >= 1 ? nbtList.method_10611(0) : this.method_23317() + (this.field_5974.method_43058() - this.field_5974.method_43058()) * (double)this.spawnRange + 0.5;
            double mobY = nbtSize >= 2 ? nbtList.method_10611(1) : this.method_23318() + (double)this.field_5974.method_43048(3) - 1.0;
            double d = mobZ = nbtSize >= 3 ? nbtList.method_10611(2) : this.method_23321() + (this.field_5974.method_43058() - this.field_5974.method_43058()) * (double)this.spawnRange + 0.5;
            if (!this.method_37908().method_18026(((class_1299)optionalEntityType.get()).method_58629(mobX, mobY, mobZ))) continue;
            class_2338 mobBlockPos = class_2338.method_49637((double)mobX, (double)mobY, (double)mobZ);
            if (!mobSpawnerEntry.method_38097().isPresent() ? !class_1317.method_20638((class_1299)((class_1299)optionalEntityType.get()), (class_5425)serverWorld, (class_3730)class_3730.field_16469, (class_2338)mobBlockPos, (class_5819)this.method_59922()) : !((class_1299)optionalEntityType.get()).method_5891().method_6136() && this.method_37908().method_8407() == class_1267.field_5801 || !(customSpawnRules = (class_1952.class_6542)mobSpawnerEntry.method_38097().get()).method_56563(mobBlockPos, serverWorld)) continue;
            class_1297 entity = class_1299.method_17842((class_2487)nbtCompound, (class_1937)serverWorld, (class_3730)class_3730.field_16469, entityx -> {
                entityx.method_5808(mobX, mobY, mobZ, entityx.method_36454(), entityx.method_36455());
                return entityx;
            });
            if (entity == null) {
                this.updateSpawns();
                return;
            }
            int nearbyEntityCount = this.method_37908().method_18023(class_5575.method_55374(entity.getClass()), new class_238(this.method_23317(), this.method_23318(), this.method_23321(), this.method_23317() + 1.0, this.method_23318() + 1.0, this.method_23321() + 1.0).method_1014((double)this.spawnRange), class_1301.field_6155).size();
            if (nearbyEntityCount >= this.maxNearbyEntities) {
                this.updateSpawns();
                return;
            }
            entity.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), this.field_5974.method_43057() * 360.0f, 0.0f);
            if (entity instanceof class_1308) {
                boolean bl2;
                mobEntity = (class_1308)entity;
                if (mobSpawnerEntry.method_38097().isEmpty() && !mobEntity.method_5979((class_1936)serverWorld, class_3730.field_16469) || !mobEntity.method_5957((class_4538)serverWorld)) continue;
                boolean bl = bl2 = mobSpawnerEntry.method_38093().method_10546() == 1 && mobSpawnerEntry.method_38093().method_10573("id", 8);
                if (bl2) {
                    ((class_1308)entity).method_5943((class_5425)serverWorld, serverWorld.method_8404(entity.method_24515()), class_3730.field_16469, null);
                }
                mobSpawnerEntry.method_59717().ifPresent(arg_0 -> ((class_1308)mobEntity).method_58634(arg_0));
            }
            if (!serverWorld.method_30736(entity)) {
                this.updateSpawns();
                return;
            }
            serverWorld.method_20290(2004, this.method_24515(), 0);
            serverWorld.method_33596(entity, (class_6880)class_5712.field_28738, mobBlockPos);
            if (entity instanceof class_1308) {
                mobEntity = (class_1308)entity;
                mobEntity.method_5990();
            }
            spawnedSuccessfully = true;
        }
        if (spawnedSuccessfully) {
            this.updateSpawns();
        }
    }

    private void updateSpawns() {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.field_5974.method_43048(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.method_34992(this.field_5974).ifPresent(spawnPotential -> this.setSpawnEntry((class_1952)spawnPotential.comp_2542()));
    }

    public void setEntityType(class_1299<?> type) {
        this.getSpawnEntry().method_38093().method_10582("id", class_7923.field_41177.method_10221(type).toString());
        this.field_6011.method_12778(RENDERED_ENTITY, (Object)this.getSpawnEntry().method_38093());
        this.renderedEntity = null;
    }

    @Nullable
    public class_1297 getRenderedEntity() {
        if (this.renderedEntity == null && !this.getRenderedEntityNbt().method_33133()) {
            this.renderedEntity = class_1299.method_17842((class_2487)this.getRenderedEntityNbt(), (class_1937)this.method_37908(), (class_3730)class_3730.field_16469, Function.identity());
        }
        return this.renderedEntity;
    }

    public double getMobRotation() {
        return this.mobEntryRotation;
    }

    public double getPrevMobRotation() {
        return this.prevMobEntryRotation;
    }

    protected void setSpawnEntry(@Nullable class_1952 spawnEntry) {
        this.spawnEntry = spawnEntry;
        if (spawnEntry != null) {
            this.field_6011.method_12778(RENDERED_ENTITY, (Object)spawnEntry.method_38093());
        }
    }

    private class_1952 getSpawnEntry() {
        if (this.spawnEntry == null) {
            this.setSpawnEntry(this.spawnPotentials.method_34992(this.field_5974).map(class_6008.class_6010::comp_2542).orElseGet(class_1952::new));
        }
        return this.spawnEntry;
    }

    public void setRunningSpawnAnimation(boolean value) {
        this.method_5841().method_12778(RUNNING_SPAWN_ANIMATION, (Object)value);
    }

    public boolean isRunningSpawnAnimation() {
        return (Boolean)this.method_5841().method_12789(RUNNING_SPAWN_ANIMATION);
    }

    public class_2487 getRenderedEntityNbt() {
        return (class_2487)this.field_6011.method_12789(RENDERED_ENTITY);
    }

    protected static class MimicAppearGoal
    extends class_1352 {
        private static final int INITIAL_AGE = -100;
        private final SpawnerMimicEntity self;
        private int startingAge = -100;

        public MimicAppearGoal(SpawnerMimicEntity mob) {
            this.self = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407, class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            return this.startingAge == -100 || this.self.isRunningSpawnAnimation();
        }

        public void method_6269() {
            this.startingAge = this.self.field_6012;
        }

        public void method_6270() {
            this.self.setRunningSpawnAnimation(false);
        }

        public boolean method_6266() {
            return this.self.field_6012 <= this.startingAge + 40;
        }
    }

    protected static class MimicAttackGoal
    extends class_1366 {
        public MimicAttackGoal(SpawnerMimicEntity mob, double speed, boolean pauseWhenMobIdle) {
            super((class_1314)mob, speed, pauseWhenMobIdle);
        }
    }
}

