/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cursedspawners.mixin;

import com.provismet.cursedspawners.imixin.IMixinMobSpawnerBlockEntity;
import com.provismet.cursedspawners.imixin.IMixinMobSpawnerLogic;
import com.provismet.cursedspawners.utility.CSGamerules;
import com.provismet.cursedspawners.utility.SpawnerBreakEffects;
import com.provismet.cursedspawners.utility.SpawnerEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8934;
import net.minecraft.class_9297;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2636.class})
public abstract class MobSpawnerBlockEntityMixin
extends class_2586
implements IMixinMobSpawnerBlockEntity,
class_8934 {
    @Shadow
    @Final
    private class_1917 field_12114;
    @Unique
    private static final String REFORGE_ACTIONS = "ReforgeActions";
    @Unique
    private static final String BREAK_ACTION = "BreakAction";
    @Unique
    private static final String RANDOMISE = "ShouldGenerateEffects";
    @Unique
    private static final String MIMIC_CHANCE = "MimicChance";
    @Unique
    private static final double PASSTHROUGH_MIMIC_CHANCE = -1.0;
    @Unique
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    @Unique
    private long lootTableSeed = 0L;
    @Unique
    private class_5321<class_52> lootTable = null;
    @Unique
    private double mimicChance = -1.0;
    @Unique
    private List<String> reforgeActions = new ArrayList<String>();
    @Unique
    private String breakAction = "normal";
    @Unique
    private boolean shouldRandomiseEffects = true;

    public MobSpawnerBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    private void readExtendedNbt(class_2487 nbt, class_7225.class_7874 registryLookup, CallbackInfo info) {
        this.mimicChance = nbt.method_10573(MIMIC_CHANCE, 6) ? nbt.method_10574(MIMIC_CHANCE) : -1.0;
        if (nbt.method_10545(RANDOMISE)) {
            this.shouldRandomiseEffects = nbt.method_10577(RANDOMISE);
        }
        if (nbt.method_10573(REFORGE_ACTIONS, 9)) {
            this.reforgeActions = new ArrayList<String>();
            this.reforgeActions.addAll(nbt.method_10554(REFORGE_ACTIONS, 8).stream().map(class_2520::method_10714).toList());
        } else {
            this.reforgeActions = new ArrayList<String>();
        }
        this.breakAction = nbt.method_10573(BREAK_ACTION, 8) ? nbt.method_10558(BREAK_ACTION) : "normal";
        this.method_54871(nbt);
    }

    @Inject(method={"writeNbt"}, at={@At(value="TAIL")})
    private void writeExtendedNbt(class_2487 nbt, class_7225.class_7874 registryLookup, CallbackInfo info) {
        nbt.method_10549(MIMIC_CHANCE, this.mimicChance);
        class_2499 actions = new class_2499();
        for (String action : this.reforgeActions) {
            actions.add((Object)class_2519.method_23256((String)action));
        }
        nbt.method_10566(REFORGE_ACTIONS, (class_2520)actions);
        nbt.method_10582(BREAK_ACTION, this.breakAction);
        nbt.method_10556(RANDOMISE, this.shouldRandomiseEffects);
        this.method_54872(nbt);
    }

    @Override
    public double cursed_spawners$getMimicChance() {
        return this.mimicChance;
    }

    @Override
    public boolean cursed_spawners$useWorldMimicChance() {
        return this.mimicChance == -1.0;
    }

    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    private static void tick(class_1937 world, class_2338 pos, class_2680 state, class_2636 blockEntity, CallbackInfo info) {
        class_3218 serverWorld;
        MobSpawnerBlockEntityMixin self = (MobSpawnerBlockEntityMixin)blockEntity;
        if (self.shouldRandomiseEffects && self.method_11002() && world instanceof class_3218 && ((DoubleRule)(serverWorld = (class_3218)world).method_64395().method_20746(CSGamerules.SPAWNER_ACTION_CHANCE)).get() > 0.0) {
            self.generateEffects(serverWorld);
            self.method_5431();
        }
    }

    @Unique
    private void generateEffects(class_3218 world) {
        int dangerLevel;
        this.shouldRandomiseEffects = false;
        class_5819 random = world.method_8409();
        double chanceToAddAction = ((DoubleRule)world.method_64395().method_20746(CSGamerules.SPAWNER_ACTION_CHANCE)).get();
        for (dangerLevel = 0; dangerLevel < 7 && random.method_43058() < chanceToAddAction; ++dangerLevel) {
        }
        for (int i = 0; i < dangerLevel; ++i) {
            SpawnerEffects chosen;
            IMixinMobSpawnerLogic mixinLogic = (IMixinMobSpawnerLogic)this.field_12114;
            ArrayList<SpawnerEffects> possibleEffects = new ArrayList<SpawnerEffects>();
            possibleEffects.add(SpawnerEffects.REFORGE);
            if (Objects.equals(this.breakAction, "normal")) {
                possibleEffects.add(SpawnerEffects.BREAK);
            }
            if (!mixinLogic.cursed_spawners$getCanKnockback()) {
                possibleEffects.add(SpawnerEffects.KNOCKBACK);
            }
            if (!mixinLogic.cursed_spawners$getCanHeal()) {
                possibleEffects.add(SpawnerEffects.HEAL);
            }
            if (!mixinLogic.cursed_spawners$getCanBoost()) {
                possibleEffects.add(SpawnerEffects.BOOST);
            }
            if ((chosen = (SpawnerEffects)((Object)possibleEffects.get(random.method_43048(possibleEffects.size())))) == SpawnerEffects.BREAK) {
                this.breakAction = SpawnerBreakEffects.getRandomEffectKey(random);
                continue;
            }
            if (chosen == SpawnerEffects.REFORGE) {
                this.reforgeActions.add(SpawnerBreakEffects.getRandomEffectKey(random));
                continue;
            }
            if (chosen == SpawnerEffects.KNOCKBACK) {
                mixinLogic.cursed_spawners$setCanKnockback(true);
                mixinLogic.cursed_spawners$setKnockbackParams(random.method_39332(100, 160), random.method_43385(1.5, 0.5), random.method_43385(5.0, 0.75));
                continue;
            }
            if (chosen == SpawnerEffects.HEAL) {
                mixinLogic.cursed_spawners$setCanHeal(true);
                mixinLogic.cursed_spawners$setHealParams(random.method_39332(80, 160), 2.0f, random.method_62816(5.0f, 1.0f));
                continue;
            }
            if (chosen != SpawnerEffects.BOOST) continue;
            mixinLogic.cursed_spawners$setCanBoost(true);
            mixinLogic.cursed_spawners$setBoostParams(random.method_39332(120, 200), random.method_62816(8.0f, 4.0f));
        }
        if (dangerLevel > 0 && this.lootTable == null) {
            this.lootTable = dangerLevel < 3 ? class_39.field_803 : (dangerLevel < 6 ? class_39.field_356 : class_39.field_484);
        }
    }

    @Override
    public boolean cursed_spawners$attemptBreak() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return true;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (this.reforgeActions.isEmpty()) {
            SpawnerBreakEffects.getEffect(this.breakAction).accept((class_2636)this, serverWorld);
            return true;
        }
        String nextAction = this.reforgeActions.removeFirst();
        class_243 centrePos = this.method_11016().method_46558();
        serverWorld.method_14199((class_2394)class_2398.field_11203, centrePos.method_10216(), centrePos.method_10214(), centrePos.method_10215(), 20, 0.5, 0.5, 0.5, 0.0);
        SpawnerBreakEffects.getEffect(nextAction).accept((class_2636)this, serverWorld);
        return false;
    }

    @Override
    public void cursed_spawners$setShouldGenerateEffects(boolean value) {
        this.shouldRandomiseEffects = value;
    }

    @Nullable
    public class_5321<class_52> method_54869() {
        return this.lootTable;
    }

    public void method_11285(@Nullable class_5321<class_52> lootTable) {
        this.lootTable = lootTable;
    }

    public long method_54870() {
        return this.lootTableSeed;
    }

    public void method_54866(long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }

    public int method_5439() {
        this.method_54873(null);
        return this.inventory.size();
    }

    public boolean method_5442() {
        this.method_54873(null);
        return this.inventory.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        this.method_54873(null);
        if (this.inventory.size() <= slot) {
            return class_1799.field_8037;
        }
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        this.method_54873(null);
        class_1799 itemStack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 method_5441(int slot) {
        this.method_54873(null);
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.method_54873(null);
        this.inventory.set(slot, (Object)stack);
        stack.method_58408(this.method_58350(stack));
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        class_9297 containerLootComponent = (class_9297)components.method_58694(class_9334.field_49626);
        if (containerLootComponent != null) {
            this.lootTable = containerLootComponent.comp_2414();
            this.lootTableSeed = containerLootComponent.comp_2415();
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        if (this.lootTable != null) {
            componentMapBuilder.method_57840(class_9334.field_49626, (Object)new class_9297(this.lootTable, this.lootTableSeed));
        }
    }
}

