/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cursedspawners.mixin;

import com.provismet.cursedspawners.imixin.IMixinMobSpawnerLogic;
import com.provismet.cursedspawners.particle.effect.AOEChargingParticleEffect;
import com.provismet.cursedspawners.registries.CSParticleTypes;
import com.provismet.cursedspawners.registries.CSSoundEvents;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1588;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1917.class})
public abstract class MobSpawnerLogicMixin
implements IMixinMobSpawnerLogic {
    @Unique
    private static final String CAN_KNOCKBACK = "CanKnockback";
    @Unique
    private static final String MAX_KNOCKBACK_TIMER = "KnockbackInterval";
    @Unique
    private static final String KNOCKBACK_STRENGTH = "KnockbackStrength";
    @Unique
    private static final String KNOCKBACK_RADIUS = "KnockbackRadius";
    @Unique
    private static final String CAN_HEAL = "CanHeal";
    @Unique
    private static final String MAX_HEAL_TIMER = "HealInterval";
    @Unique
    private static final String HEAL_AMOUNT = "HealAmount";
    @Unique
    private static final String HEAL_RADIUS = "HealRadius";
    @Unique
    private static final String CAN_BOOST = "CanBoost";
    @Unique
    private static final String MAX_BOOST_TIMER = "BoostInterval";
    @Unique
    private static final String BOOST_RADIUS = "BoostRadius";
    @Unique
    private boolean canKnockback = false;
    @Unique
    private int knockbackTimer = 200;
    @Unique
    private int maxKnockbackTimer = 200;
    @Unique
    private double knockbackStrength = 0.2;
    @Unique
    private double knockbackRadius = 4.0;
    @Unique
    private boolean canHeal = false;
    @Unique
    private int healTimer = 200;
    @Unique
    private int maxHealTimer = 200;
    @Unique
    private float healAmount = 0.0f;
    @Unique
    private double healRadius = 0.0;
    @Unique
    private boolean canBoost = false;
    @Unique
    private int boostTimer = 200;
    @Unique
    private int maxBoostTimer = 200;
    @Unique
    private double boostRadius = 0.0;

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    private void readExtendedNbt(class_1937 world, class_2338 pos, class_2487 nbt, CallbackInfo info) {
        this.canKnockback = nbt.method_10545(CAN_KNOCKBACK) ? nbt.method_10577(CAN_KNOCKBACK) : false;
        this.maxKnockbackTimer = nbt.method_10573(MAX_KNOCKBACK_TIMER, 3) ? nbt.method_10550(MAX_KNOCKBACK_TIMER) : 200;
        this.knockbackStrength = nbt.method_10573(KNOCKBACK_STRENGTH, 6) ? nbt.method_10574(KNOCKBACK_STRENGTH) : 0.2;
        this.knockbackRadius = nbt.method_10573(KNOCKBACK_RADIUS, 6) ? nbt.method_10574(KNOCKBACK_RADIUS) : 4.0;
        this.canHeal = nbt.method_10545(CAN_HEAL) ? nbt.method_10577(CAN_HEAL) : false;
        this.maxHealTimer = nbt.method_10573(MAX_HEAL_TIMER, 3) ? nbt.method_10550(MAX_HEAL_TIMER) : 200;
        this.healAmount = nbt.method_10573(HEAL_AMOUNT, 5) ? nbt.method_10583(HEAL_AMOUNT) : 0.0f;
        this.healRadius = nbt.method_10573(HEAL_RADIUS, 6) ? nbt.method_10574(HEAL_RADIUS) : 0.0;
        this.canBoost = nbt.method_10545(CAN_BOOST) ? nbt.method_10577(CAN_BOOST) : false;
        if (nbt.method_10573(MAX_BOOST_TIMER, 3)) {
            this.maxBoostTimer = nbt.method_10550(MAX_BOOST_TIMER);
        } else {
            this.maxKnockbackTimer = 200;
        }
        this.boostRadius = nbt.method_10573(BOOST_RADIUS, 6) ? nbt.method_10574(BOOST_RADIUS) : 0.0;
        this.knockbackTimer = Math.min(this.knockbackTimer, this.maxKnockbackTimer);
        this.healTimer = Math.min(this.healTimer, this.maxHealTimer);
        this.boostTimer = Math.min(this.boostTimer, this.maxBoostTimer);
    }

    @Inject(method={"writeNbt"}, at={@At(value="TAIL")})
    private void writeExtendedNbt(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        nbt.method_10556(CAN_KNOCKBACK, this.canKnockback);
        nbt.method_10569(MAX_KNOCKBACK_TIMER, this.maxKnockbackTimer);
        nbt.method_10549(KNOCKBACK_STRENGTH, this.knockbackStrength);
        nbt.method_10549(KNOCKBACK_RADIUS, this.knockbackRadius);
        nbt.method_10556(CAN_HEAL, this.canHeal);
        nbt.method_10569(MAX_HEAL_TIMER, this.maxHealTimer);
        nbt.method_10548(HEAL_AMOUNT, this.healAmount);
        nbt.method_10549(HEAL_RADIUS, this.healRadius);
        nbt.method_10556(CAN_BOOST, this.canBoost);
        nbt.method_10569(MAX_BOOST_TIMER, this.maxBoostTimer);
        nbt.method_10549(BOOST_RADIUS, this.boostRadius);
    }

    @Inject(method={"serverTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/spawner/MobSpawnerLogic;isPlayerInRange(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", shift=At.Shift.AFTER)})
    private void performActions(class_3218 world, class_2338 pos, CallbackInfo ci) {
        List mobs;
        class_243 centrePos = pos.method_46558();
        if (this.canKnockback) {
            --this.knockbackTimer;
            if (this.knockbackTimer == this.maxKnockbackTimer / 2) {
                world.method_14199((class_2394)new AOEChargingParticleEffect(this.knockbackTimer, class_243.method_24457((int)0xE2E2E2).method_46409()), centrePos.method_10216(), (double)pos.method_10264() + 0.025, centrePos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
            } else if (this.knockbackTimer <= 0) {
                this.knockbackTimer = this.maxKnockbackTimer;
                world.method_14199((class_2394)class_2398.field_49139, centrePos.method_10216(), centrePos.method_10214(), centrePos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                List players = world.method_18766(player -> player.method_19538().method_55230(centrePos, this.knockbackRadius, this.knockbackRadius) && !player.method_7337() && !player.method_7325());
                for (class_3222 player2 : players) {
                    double strength = this.knockbackStrength * (1.0 - player2.method_45325(class_5134.field_23718));
                    if (!(strength > 0.0)) continue;
                    class_243 velocity = new class_243(player2.method_23317() - centrePos.method_10216(), player2.method_23318() >= (double)pos.method_10264() ? 0.5 : -0.5, player2.method_23321() - centrePos.method_10215()).method_1029().method_1021(strength);
                    player2.method_60491(velocity);
                    player2.field_6037 = true;
                }
                world.method_8396(null, pos, CSSoundEvents.BLOCK_SPAWNER_KNOCKBACK, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        if (this.canHeal) {
            --this.healTimer;
            if (this.healTimer == this.maxHealTimer / 2) {
                world.method_14199((class_2394)new AOEChargingParticleEffect(this.healTimer, class_243.method_24457((int)4701304).method_46409()), centrePos.method_10216(), (double)pos.method_10264() + 0.025, centrePos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
            } else if (this.healTimer <= 0) {
                this.healTimer = this.maxHealTimer;
                world.method_14199((class_2394)CSParticleTypes.HEAL, centrePos.method_10216(), centrePos.method_10214() + 0.5, centrePos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                mobs = world.method_8390(class_1588.class, class_238.method_30048((class_243)centrePos, (double)this.healRadius, (double)3.0, (double)this.healRadius), mob -> true);
                for (class_1588 hostile : mobs) {
                    hostile.method_6025(this.healAmount);
                    world.method_14199((class_2394)class_2398.field_11211, hostile.method_23317(), hostile.method_23320(), hostile.method_23321(), 8, 0.35, 0.35, 0.35, 0.0);
                }
                world.method_8396(null, pos, CSSoundEvents.BLOCK_SPAWNER_HEAL, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        if (this.canBoost) {
            --this.boostTimer;
            if (this.boostTimer == this.maxBoostTimer / 2) {
                world.method_14199((class_2394)new AOEChargingParticleEffect(this.boostTimer, class_243.method_24457((int)16745561).method_46409()), centrePos.method_10216(), (double)pos.method_10264() + 0.025, centrePos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
            } else if (this.boostTimer <= 0) {
                this.boostTimer = this.maxBoostTimer;
                world.method_14199((class_2394)CSParticleTypes.BOOST, centrePos.method_10216(), centrePos.method_10214() + 0.5, centrePos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                mobs = world.method_8390(class_1588.class, class_238.method_30048((class_243)centrePos, (double)this.boostRadius, (double)3.0, (double)this.boostRadius), mob -> true);
                for (class_1588 hostile : mobs) {
                    hostile.method_6092(new class_1293(class_1294.field_5904, 30, 1));
                    world.method_14199((class_2394)class_2398.field_11211, hostile.method_23317(), hostile.method_23320(), hostile.method_23321(), 8, 0.35, 0.35, 0.35, 0.0);
                }
                world.method_8396(null, pos, CSSoundEvents.BLOCK_SPAWNER_BOOST, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean cursed_spawners$getCanKnockback() {
        return this.canKnockback;
    }

    @Override
    public void cursed_spawners$setCanKnockback(boolean value) {
        this.canKnockback = value;
    }

    @Override
    public void cursed_spawners$setKnockbackParams(int interval, double strength, double radius) {
        this.maxKnockbackTimer = interval;
        this.knockbackTimer = Math.min(this.knockbackTimer, this.maxKnockbackTimer);
        this.knockbackStrength = strength;
        this.knockbackRadius = radius;
    }

    @Override
    public boolean cursed_spawners$getCanHeal() {
        return this.canHeal;
    }

    @Override
    public void cursed_spawners$setCanHeal(boolean value) {
        this.canHeal = value;
    }

    @Override
    public void cursed_spawners$setHealParams(int interval, float amount, double radius) {
        this.maxHealTimer = interval;
        this.healTimer = Math.min(this.healTimer, this.maxHealTimer);
        this.healAmount = amount;
        this.healRadius = radius;
    }

    @Override
    public boolean cursed_spawners$getCanBoost() {
        return this.canBoost;
    }

    @Override
    public void cursed_spawners$setCanBoost(boolean value) {
        this.canBoost = value;
    }

    @Override
    public void cursed_spawners$setBoostParams(int interval, double radius) {
        this.maxBoostTimer = interval;
        this.boostTimer = Math.min(this.boostTimer, this.maxBoostTimer);
        this.boostRadius = radius;
    }
}

