/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pugz.omni.client.model.SeahorseModel;
import pugz.omni.common.entity.paradise.SeahorseEntity;

@OnlyIn(value=Dist.CLIENT)
public class SeahorseRenderer
extends MobRenderer<SeahorseEntity, EntityModel<SeahorseEntity>> {
    public SeahorseRenderer(EntityRendererManager manager) {
        super(manager, new SeahorseModel(), 0.3f);
    }

    public void render(SeahorseEntity seahorse, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)seahorse, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(SeahorseEntity seahorse) {
        return new ResourceLocation("omni", "textures/entity/seahorse/seahorse_" + seahorse.getVariantType().getName() + ".png");
    }

    protected void preRenderCallback(SeahorseEntity entity, MatrixStack matrixStackIn, float partialTickTime) {
        int i = entity.getSeahorseSize();
        float f = 1.0f + 0.3f * (float)i;
        matrixStackIn.func_227862_a_(f, f, f);
    }

    protected void applyRotations(SeahorseEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        if (!entityLiving.func_70090_H() && !entityLiving.func_184207_aI()) {
            matrixStackIn.func_227861_a_((double)0.2f, (double)0.1f, 0.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        }
    }
}

