/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.block.colormatic;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.HugeFungusConfig;
import net.minecraft.world.server.ServerWorld;
import pugz.omni.common.block.AbstractStackableBlock;
import pugz.omni.core.util.IBaseBlock;

public class FungiBlock
extends AbstractStackableBlock
implements IGrowable,
IBaseBlock {
    private static final VoxelShape MULTI_FUNGUS_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    public static final IntegerProperty FUNGI = IntegerProperty.func_177719_a((String)"fungi", (int)1, (int)4);
    private final Block base;
    private final Supplier<ConfiguredFeature<HugeFungusConfig, ?>> fungusFeature;

    public FungiBlock(AbstractBlock.Properties properties, Block base, Supplier<ConfiguredFeature<HugeFungusConfig, ?>> fungusFeature) {
        super(properties);
        this.base = base;
        this.fungusFeature = fungusFeature;
    }

    @Override
    public VoxelShape getStackedShape() {
        return MULTI_FUNGUS_SHAPE;
    }

    @Override
    public Block getBase() {
        return this.base;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Property<Integer> getCountProperty() {
        return FUNGI;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_235714_a_((ITag)BlockTags.field_232873_an_) || state.func_203425_a(Blocks.field_150391_bh) || state.func_203425_a(Blocks.field_235336_cN_) || super.func_200014_a_(state, worldIn, pos);
    }

    @Override
    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Integer)state.func_177229_b((Property)FUNGI) == 2 ? this.base.func_220053_a(state, worldIn, pos, context) : MULTI_FUNGUS_SHAPE;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        Block block = ((HugeFungusConfig)this.fungusFeature.get().field_222738_b).field_236303_f_.func_177230_c();
        Block block1 = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block1 == block;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4 * (double)((Integer)state.func_177229_b((Property)FUNGI)).intValue();
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.fungusFeature.get().func_242765_a((ISeedReader)worldIn, worldIn.func_72863_F().func_201711_g(), rand, pos);
    }
}

