/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.block.colormatic;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;
import pugz.omni.common.block.AbstractStackableBlock;
import pugz.omni.core.util.IBaseBlock;

public class MushroomsBlock
extends AbstractStackableBlock
implements IGrowable,
IBaseBlock {
    private static final VoxelShape MULTI_MUSHROOM_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    public static final IntegerProperty MUSHROOMS = IntegerProperty.func_177719_a((String)"mushrooms", (int)1, (int)4);
    private final Block base;
    private final Supplier<ConfiguredFeature<?, ?>> mushroomsFeature;

    public MushroomsBlock(AbstractBlock.Properties properties, Block base, Supplier<ConfiguredFeature<?, ?>> mushroomsFeature) {
        super(properties);
        this.base = base;
        this.mushroomsFeature = mushroomsFeature;
    }

    @Override
    public VoxelShape getStackedShape() {
        return MULTI_MUSHROOM_SHAPE;
    }

    @Override
    public Block getBase() {
        return this.base;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Property<Integer> getCountProperty() {
        return MUSHROOMS;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200015_d(worldIn, pos);
    }

    public boolean grow(ServerWorld world, BlockPos pos, BlockState state, Random rand) {
        if (!world.field_72995_K) {
            world.func_217377_a(pos, false);
            if (this.mushroomsFeature.get().func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), rand, pos)) {
                return true;
            }
            world.func_180501_a(pos, state, 3);
            return false;
        }
        return false;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4 * (double)((Integer)state.func_177229_b((Property)MUSHROOMS)).intValue();
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow(worldIn, pos, state, rand);
    }
}

