/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.block.wild_west;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import pugz.omni.common.block.HorizontalFacingBlock;
import pugz.omni.common.world.feature.wild_west.SaguaroCactusFeature;
import pugz.omni.core.registry.OmniFeatures;
import pugz.omni.core.util.IBaseBlock;

public class SaguaroCactusBlock
extends Block
implements IGrowable,
IBaseBlock {
    public static final BooleanProperty HORIZONTAL = BooleanProperty.func_177716_a((String)"horizontal");
    public static final DirectionProperty HORIZONTAL_DIRECTION = HorizontalFacingBlock.field_185512_D;
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    private final HashMap<BlockState, VoxelShape> shapes = (HashMap)Util.func_200696_a((Object)Maps.newHashMap(), m -> this.func_176194_O().func_177619_a().forEach(state -> m.put(state, this.getShapeForState((BlockState)state))));
    public static final Map<Direction, BooleanProperty> FACING_PROPERTIES = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH);
        enumMap.put(Direction.EAST, EAST);
        enumMap.put(Direction.SOUTH, SOUTH);
        enumMap.put(Direction.WEST, WEST);
    });

    public SaguaroCactusBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150434_aF));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).getBlockState().func_206870_a((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HORIZONTAL_DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public RenderType getRenderType() {
        return RenderType.func_228643_e_();
    }

    @Override
    public float getCompostChance() {
        return 0.5f;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        if (context.func_196000_l().func_176736_b() >= 0) {
            state = (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)HORIZONTAL, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)HORIZONTAL_DIRECTION, (Comparable)context.func_196000_l().func_176734_d())).func_206870_a((Property)FACING_PROPERTIES.get(context.func_196000_l().func_176734_d()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (!this.func_196260_a(state, (IWorldReader)world, currentPos)) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
        if (facing.func_176740_k().func_200128_b()) {
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
        if (facingState.func_177230_c() == this) {
            if (((Boolean)facingState.func_177229_b((Property)HORIZONTAL)).booleanValue() && ((Boolean)facingState.func_177229_b((Property)FACING_PROPERTIES.get(facing.func_176734_d()))).booleanValue()) {
                return (BlockState)state.func_206870_a((Property)FACING_PROPERTIES.get(facing), (Comparable)Boolean.valueOf(true));
            }
        } else {
            return (BlockState)state.func_206870_a((Property)FACING_PROPERTIES.get(facing), (Comparable)Boolean.valueOf(false));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)HORIZONTAL)).booleanValue()) {
            Direction offset = (Direction)state.func_177229_b((Property)HORIZONTAL_DIRECTION);
            if (!(world.func_180495_p(pos.func_177972_a(offset)).func_177230_c() instanceof SaguaroCactusBlock)) {
                return false;
            }
        } else {
            BlockState checkState = world.func_180495_p(pos.func_177977_b());
            return (checkState.func_177230_c() instanceof SaguaroCactusBlock || checkState.func_203425_a(Blocks.field_150354_m) || checkState.func_203425_a(Blocks.field_196611_F)) && !world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d();
        }
        return super.func_196260_a(state, world, pos);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes.get(state);
    }

    private VoxelShape getShapeForState(BlockState state) {
        VoxelShape base = (Boolean)state.func_177229_b((Property)HORIZONTAL) != false ? Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0) : Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        ArrayList connections = Lists.newArrayList();
        for (Direction direction : Direction.values()) {
            double x;
            if (direction == Direction.DOWN || direction == Direction.UP || !((Boolean)state.func_177229_b((Property)FACING_PROPERTIES.get(direction))).booleanValue()) continue;
            double d = direction == Direction.WEST ? 0.0 : (x = direction == Direction.EAST ? 16.0 : 4.0);
            double z = direction == Direction.NORTH ? 0.0 : (direction == Direction.SOUTH ? 16.0 : 4.0);
            VoxelShape shape = Block.func_208617_a((double)x, (double)8.0, (double)z, (double)12.0, (double)16.0, (double)12.0);
            connections.add(shape);
        }
        return VoxelShapes.func_216384_a((VoxelShape)base, (VoxelShape[])connections.toArray(new VoxelShape[0]));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{EAST, WEST, NORTH, SOUTH, HORIZONTAL, HORIZONTAL_DIRECTION});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return state == this.func_176223_P() && (worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150354_m) || worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196611_F)) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        ((SaguaroCactusFeature)OmniFeatures.SAGUARO_CACTUS.get()).generateCactus((ISeedReader)world, random.nextBoolean(), pos, random, false);
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.func_201696_r(pos.func_177984_a()) >= 9 && this.func_176473_a((IBlockReader)world, pos, state, world.field_72995_K) && random.nextInt(7) == 0) {
            if (!world.isAreaLoaded(pos, 1)) {
                return;
            }
            ((SaguaroCactusFeature)OmniFeatures.SAGUARO_CACTUS.get()).generateCactus((ISeedReader)world, random.nextBoolean(), pos, random, false);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DAMAGE_CACTUS;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

