/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.entity.cavier_caves;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class SizedCaveSpiderEntity
extends CaveSpiderEntity {
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(SizedCaveSpiderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public SizedCaveSpiderEntity(EntityType<? extends SizedCaveSpiderEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
    }

    @Nonnull
    public ResourceLocation func_184647_J() {
        return new ResourceLocation("entity/spider/cave_spider");
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void setSpiderSize(int sizeIn) {
        this.field_70180_af.func_187227_b(SIZE, (Object)MathHelper.func_76125_a((int)sizeIn, (int)0, (int)32));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(6.0 * (double)sizeIn);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(0.5 * (double)sizeIn);
    }

    private void updateSpiderSize() {
        this.func_213323_x_();
    }

    public int getSpiderSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SIZE.equals(key)) {
            this.updateSpiderSize();
        }
        super.func_184206_a(key);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Size", this.getSpiderSize());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setSpiderSize(compound.func_74762_e("Size"));
        super.func_70037_a(compound);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = this.getSpiderSize();
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.field_196161_cu);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setSpiderSize(worldIn.func_201674_k().nextInt(4));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nonnull
    public EntitySize func_213305_a(Pose poseIn) {
        int i = this.getSpiderSize();
        EntitySize entitysize = super.func_213305_a(poseIn);
        float f = 0.5f + 0.2f * (float)(i * i);
        return entitysize.func_220312_a(f * 2.0f, f * 1.6f);
    }
}

