/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.entity.colormatic;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import pugz.omni.common.block.colormatic.LayerConcreteBlock;
import pugz.omni.common.block.colormatic.LayerConcretePowderBlock;
import pugz.omni.core.registry.OmniEntities;

public class FallingConcretePowderEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public int fallTime;
    private int layers;
    public boolean shouldDropItem = true;
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(FallingConcretePowderEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> LAYERS = EntityDataManager.func_187226_a(FallingConcretePowderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private BlockState fallState;
    private final EntitySize size;

    public FallingConcretePowderEntity(EntityType<FallingConcretePowderEntity> entity, World worldIn) {
        super(entity, worldIn);
        this.layers = 1;
        this.size = new EntitySize(0.98f, 0.1225f * (float)this.layers, true);
    }

    public FallingConcretePowderEntity(World worldIn, double x, double y, double z, int layers, BlockState state) {
        super((EntityType)OmniEntities.FALLING_CONCRETE_POWDER.get(), worldIn);
        this.field_70156_m = true;
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.layers = layers;
        this.setData(this.func_233580_cy_(), layers);
        this.fallState = state;
        this.size = new EntitySize(0.98f, 0.1225f * (float)layers, true);
    }

    @Nonnull
    public EntitySize func_213305_a(Pose poseIn) {
        return this.size;
    }

    public void func_70071_h_() {
        if (this.fallState.func_196958_f() || !(this.fallState.func_177230_c() instanceof LayerConcretePowderBlock)) {
            this.func_70106_y();
        } else {
            Block block = this.fallState.func_177230_c();
            if (this.fallTime++ == 0) {
                BlockPos blockpos = this.func_233580_cy_();
                if (this.field_70170_p.func_180495_p(blockpos).func_203425_a(block)) {
                    this.field_70170_p.func_217377_a(blockpos, false);
                } else if (!this.field_70170_p.field_72995_K) {
                    return;
                }
            }
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (!this.field_70170_p.field_72995_K) {
                BlockRayTraceResult blockraytraceresult;
                BlockPos blockpos1 = this.func_233580_cy_();
                boolean flag = this.fallState.func_177230_c() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.field_70170_p.func_204610_c(blockpos1).func_206884_a((ITag)FluidTags.field_206959_a);
                double d0 = this.func_213322_ci().func_189985_c();
                if (flag && d0 > 1.0 && (blockraytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), this.func_213303_ch(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this))).func_216346_c() != RayTraceResult.Type.MISS && this.field_70170_p.func_204610_c(blockraytraceresult.func_216350_a()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    blockpos1 = blockraytraceresult.func_216350_a();
                    flag1 = true;
                }
                if (!this.field_70122_E && !flag1) {
                    if (!(this.field_70170_p.field_72995_K || (this.fallTime <= 100 || blockpos1.func_177956_o() >= 1 && blockpos1.func_177956_o() <= 256) && this.fallTime <= 600)) {
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)block);
                        }
                        this.func_70106_y();
                    }
                } else {
                    BlockState hitState = this.field_70170_p.func_180495_p(blockpos1);
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
                    if (!hitState.func_203425_a(Blocks.field_196603_bb)) {
                        boolean flag4;
                        this.func_70106_y();
                        boolean flag2 = hitState.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, blockpos1, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
                        boolean flag3 = FallingBlock.func_185759_i((BlockState)this.field_70170_p.func_180495_p(blockpos1.func_177977_b()));
                        boolean bl = flag4 = this.fallState.func_196955_c((IWorldReader)this.field_70170_p, blockpos1) && !flag3;
                        if ((flag2 || hitState.func_177230_c() instanceof LayerConcretePowderBlock || hitState.func_177230_c() instanceof LayerConcreteBlock) && flag4) {
                            if (this.fallState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(blockpos1).func_206886_c() == Fluids.field_204546_a) {
                                this.fallState = (BlockState)this.fallState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                            }
                            if (hitState.func_177230_c() instanceof LayerConcretePowderBlock) {
                                if (block.func_235697_s_() == hitState.func_177230_c().func_235697_s_()) {
                                    this.shouldDropItem = false;
                                    if ((Integer)hitState.func_177229_b((Property)LayerConcretePowderBlock.LAYERS) == 8) {
                                        this.field_70170_p.func_180501_a(blockpos1.func_177984_a(), this.fallState, 3);
                                    } else {
                                        int totalLayers = (Integer)hitState.func_177229_b((Property)LayerConcretePowderBlock.LAYERS) + (Integer)this.fallState.func_177229_b((Property)LayerConcretePowderBlock.LAYERS);
                                        if (totalLayers <= 8) {
                                            this.field_70170_p.func_180501_a(blockpos1, (BlockState)hitState.func_206870_a((Property)LayerConcretePowderBlock.LAYERS, (Comparable)Integer.valueOf(totalLayers)), 3);
                                        } else {
                                            this.field_70170_p.func_180501_a(blockpos1, (BlockState)this.fallState.func_206870_a((Property)LayerConcretePowderBlock.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                                            this.field_70170_p.func_180501_a(blockpos1.func_177984_a(), (BlockState)this.fallState.func_206870_a((Property)LayerConcretePowderBlock.LAYERS, (Comparable)Integer.valueOf(totalLayers - 8)), 3);
                                        }
                                    }
                                } else {
                                    this.shouldDropItem = true;
                                }
                            } else if (hitState.func_177230_c() instanceof LayerConcreteBlock) {
                                if (((LayerConcretePowderBlock)block).getSolidifiedState().func_177230_c().func_235697_s_() == hitState.func_177230_c().func_235697_s_()) {
                                    this.shouldDropItem = false;
                                    if (((Boolean)hitState.func_177229_b((Property)LayerConcreteBlock.WATERLOGGED)).booleanValue() && (Integer)hitState.func_177229_b((Property)LayerConcreteBlock.LAYERS) < 7) {
                                        int totalLayers = (Integer)hitState.func_177229_b((Property)LayerConcreteBlock.LAYERS) + (Integer)this.fallState.func_177229_b((Property)LayerConcretePowderBlock.LAYERS);
                                        if (totalLayers <= 8) {
                                            this.field_70170_p.func_180501_a(blockpos1, (BlockState)((BlockState)hitState.func_206870_a((Property)LayerConcreteBlock.LAYERS, (Comparable)Integer.valueOf(totalLayers))).func_206870_a((Property)LayerConcreteBlock.WATERLOGGED, (Comparable)Boolean.valueOf(totalLayers < 8)), 3);
                                        } else {
                                            this.field_70170_p.func_180501_a(blockpos1, (BlockState)((BlockState)hitState.func_206870_a((Property)LayerConcreteBlock.LAYERS, (Comparable)Integer.valueOf(8))).func_206870_a((Property)LayerConcreteBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
                                            this.field_70170_p.func_180501_a(blockpos1.func_177984_a(), (BlockState)((BlockState)this.fallState.func_206870_a((Property)LayerConcretePowderBlock.LAYERS, (Comparable)Integer.valueOf(totalLayers - 8))).func_206870_a((Property)LayerConcretePowderBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
                                        }
                                    }
                                } else {
                                    this.shouldDropItem = true;
                                }
                            } else if (!(hitState.func_177230_c() instanceof LayerConcretePowderBlock)) {
                                if (this.field_70170_p.func_180501_a(blockpos1, this.fallState, 3)) {
                                    ((LayerConcretePowderBlock)block).onEndFalling(this.field_70170_p, blockpos1, this.fallState);
                                }
                            } else if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g) && this.layers == 8) {
                                this.func_199703_a((IItemProvider)block);
                            }
                        } else if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g) && this.layers == 8) {
                            this.func_199703_a((IItemProvider)block);
                        }
                    }
                }
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
    }

    public void setData(BlockPos pos, int layers) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
        this.field_70180_af.func_187227_b(LAYERS, (Object)layers);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    public int getLayers() {
        return (Integer)this.field_70180_af.func_187225_a(LAYERS);
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(LAYERS, (Object)1);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.fallState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState")).func_177230_c() instanceof LayerConcretePowderBlock ? NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState")) : ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("omni", "red_concrete_powder"))).func_176223_P();
        this.fallTime = compound.func_74762_e("Time");
        if (compound.func_150297_b("Layers", 3)) {
            this.layers = compound.func_74762_e("Layers");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.fallState));
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74768_a("Layers", this.layers);
    }

    @Nonnull
    public BlockState getBlockState() {
        return this.fallState;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(Block.func_196246_j((BlockState)this.getBlockState()));
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.fallState = Block.func_196257_b((int)additionalData.readInt());
    }
}

