/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.entity.paradise;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniEntities;
import pugz.omni.core.registry.OmniItems;

public class SeahorseEntity
extends TameableEntity
implements IMob {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CORAL_TYPE = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CORAL_TYPE_FLAGS = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private BlockPos savedCoralPos = null;

    public SeahorseEntity(EntityType<? extends SeahorseEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
    }

    public SeahorseEntity(World world, double posX, double posY, double posZ) {
        this((EntityType<? extends SeahorseEntity>)((EntityType)OmniEntities.SEAHORSE.get()), world);
        this.func_70107_b(posX, posY, posZ);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, (double)0.8f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
        this.field_70180_af.func_187214_a(CORAL_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(CORAL_TYPE_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Nonnull
    public ResourceLocation func_184647_J() {
        if (this.getVariantType() != CoralType.MYSTERY) {
            return new ResourceLocation("omni", "entities/seahorse/" + this.getVariantType().getName());
        }
        return new ResourceLocation("omni", "entities/seahorse");
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, 1.0, 1.1));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowParentGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 25));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Nonnull
    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public static boolean canSeahorseSpawn(EntityType<? extends SeahorseEntity> seahorse, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        for (String spawnBiomeName : ((String)CoreModule.Configuration.COMMON.SEAHORSE_SPAWN_BIOMES.get()).replace(" ", "").split(",")) {
            if (!world.func_226691_t_(pos).getRegistryName().toString().equals(spawnBiomeName)) continue;
            return world.func_201671_F(pos);
        }
        return false;
    }

    @Nonnull
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203253_U;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_204413_iX;
    }

    public void func_203004_j(boolean downwards) {
    }

    public void func_203002_i(boolean downwards) {
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)OmniItems.SEAHORSE_SPAWN_EGG.get());
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Nonnull
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public int func_70627_aG() {
        return 120;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(2);
    }

    public int func_70641_bl() {
        return 6;
    }

    protected void updateAir(int p_209207_1_) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.func_70050_g(p_209207_1_ - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_205132_u, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.updateAir(i);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void setSeahorseSize(int sizeIn) {
        this.field_70180_af.func_187227_b(SIZE, (Object)MathHelper.func_76125_a((int)sizeIn, (int)0, (int)64));
    }

    private void updateSeahorseSize() {
        this.func_213323_x_();
    }

    public int getSeahorseSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.35f;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SIZE.equals(key)) {
            this.updateSeahorseSize();
        }
        super.func_184206_a(key);
    }

    @Nullable
    public BlockPos getCoralPos() {
        return this.savedCoralPos;
    }

    public CoralType getVariantType() {
        return CoralType.getTypeByIndex((Integer)this.field_70180_af.func_187225_a(CORAL_TYPE));
    }

    public void setVariantType(CoralType typeIn) {
        this.field_70180_af.func_187227_b(CORAL_TYPE, (Object)typeIn.getIndex());
    }

    protected boolean getSeahorseWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & p_110233_1_) != 0;
    }

    protected void setSeahorseWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        if (p_110208_2_) {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public boolean isTame() {
        return this.getSeahorseWatchableBoolean(2);
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(uniqueId));
    }

    public void setSeahorseTamed(boolean tamed) {
        this.setSeahorseWatchableBoolean(2, tamed);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    public void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.hasCoral()) {
            compound.func_218657_a("CoralPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getCoralPos()));
        }
        compound.func_74757_a("Moving", this.isMoving());
        compound.func_74778_a("Type", this.getVariantType().getName());
        compound.func_74768_a("Size", this.getSeahorseSize());
        compound.func_74757_a("Tame", this.isTame());
        if (this.getOwnerUniqueId() != null) {
            compound.func_186854_a("Owner", this.getOwnerUniqueId());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        this.setVariantType(CoralType.getTypeByName(compound.func_74779_i("Type")));
        this.savedCoralPos = null;
        if (compound.func_74764_b("CoralPos")) {
            this.savedCoralPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("CoralPos"));
        }
        this.setMoving(compound.func_74767_n("Moving"));
        this.setSeahorseSize(compound.func_74762_e("Size"));
        this.setSeahorseTamed(compound.func_74767_n("Tame"));
        if (compound.func_186855_b("Owner")) {
            uuid = compound.func_186857_a("Owner");
        } else {
            String s = compound.func_74779_i("Owner");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUniqueId(uuid);
        }
        super.func_70037_a(compound);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageableEntity) {
        return (AgeableEntity)((EntityType)OmniEntities.SEAHORSE.get()).func_200721_a((World)world);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        int i = this.func_225508_e_(distance, damageMultiplier);
        if (i <= 0) {
            return false;
        }
        this.func_70097_a(DamageSource.field_76379_h, i);
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184182_bu()) {
                entity.func_70097_a(DamageSource.field_76379_h, (float)i);
            }
        }
        this.func_226295_cZ_();
        return true;
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier));
    }

    protected void spawnSeahorseParticles(boolean p_110216_1_) {
        BasicParticleType iparticledata = p_110216_1_ ? ParticleTypes.field_197633_z : ParticleTypes.field_197601_L;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 7) {
            this.spawnSeahorseParticles(true);
        } else if (id == 6) {
            this.spawnSeahorseParticles(false);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)passenger;
            this.field_70761_aq = mobentity.field_70761_aq;
        }
        float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = 0.7f;
        float f2 = 0.15f;
        passenger.func_70107_b(this.func_226277_ct_() + (double)(f1 * f3), this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W() + (double)f2, this.func_226281_cx_() - (double)(f1 * f));
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        CoralType seahorseentity$coraltype = CoralType.getTypeByIndex(worldIn.func_201674_k().nextInt(CoralType.values().length - 1));
        this.setVariantType(seahorseentity$coraltype);
        this.setSeahorseSize(worldIn.func_201674_k().nextInt(4));
        if (worldIn.func_201674_k().nextInt((Integer)CoreModule.Configuration.COMMON.LARGE_SEAHORSE_SPAWN_CHANCE.get()) == 0) {
            this.setSeahorseSize(this.field_70146_Z.nextInt(1) + 6);
        }
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.getModifiedMaxHealth());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.getModifiedMovementSpeed());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nonnull
    public EntitySize func_213305_a(Pose poseIn) {
        int i = this.getSeahorseSize();
        EntitySize entitysize = super.func_213305_a(poseIn);
        float f = 1.0f + 0.3f * (float)i;
        if (!this.func_70090_H() && !this.func_184207_aI()) {
            EntitySize size = new EntitySize(entitysize.field_220316_b, entitysize.field_220315_a, entitysize.field_220317_c);
            return size.func_220313_a(f);
        }
        return entitysize.func_220313_a(f);
    }

    protected float getModifiedMaxHealth() {
        return 6.0f + (float)this.field_70146_Z.nextInt(5);
    }

    protected double getModifiedMovementSpeed() {
        return (double)0.4f + this.field_70146_Z.nextDouble();
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean hasCoral() {
        return this.savedCoralPos != null;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(8.0);
            this.func_70606_j(8.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(8.0);
        }
    }

    public void func_70636_d() {
        if (!this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        super.func_70636_d();
    }

    public int func_70874_b() {
        return 0;
    }

    protected ItemStack getBucket() {
        return new ItemStack((IItemProvider)OmniItems.SEAHORSE_BUCKET.get());
    }

    public static String getCoralTypeName(int index) {
        return CoralType.getTypeByIndex(index).getName();
    }

    @Nonnull
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (!this.func_70631_g_()) {
            if (held.func_77973_b() == Items.field_222066_kO && !this.func_70909_n()) {
                if (!player.field_71075_bZ.field_75098_d && !this.field_70170_p.field_72995_K) {
                    held.func_190918_g(1);
                }
                if (this.field_70146_Z.nextInt((Integer)CoreModule.Configuration.COMMON.SEAHORSE_TAME_CHANCE.get()) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_233687_w_(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (held.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
                this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d && !this.field_70170_p.field_72995_K) {
                    held.func_190918_g(1);
                }
                ItemStack bucket = this.getBucket();
                if (this.func_145818_k_()) {
                    bucket.func_200302_a(this.func_200201_e());
                }
                CompoundNBT compoundnbt = bucket.func_196082_o();
                compoundnbt.func_74768_a("SeahorseVariantTag", this.getVariantType().getIndex());
                compoundnbt.func_74768_a("SeahorseSizeTag", this.getSeahorseSize());
                if (!this.field_70170_p.field_72995_K) {
                    CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, bucket);
                }
                if (held.func_190926_b()) {
                    player.func_184611_a(hand, bucket);
                } else if (!player.field_71071_by.func_70441_a(bucket)) {
                    player.func_71019_a(bucket, false);
                }
                this.func_70106_y();
                return ActionResultType.SUCCESS;
            }
            if (this.getSeahorseSize() > 5 && this.func_70909_n() && this.func_70902_q() == player && ((Boolean)CoreModule.Configuration.COMMON.RIDEABLE_SEAHORSES.get()).booleanValue()) {
                this.mountTo(player);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
        }
        return ActionResultType.PASS;
    }

    protected void mountTo(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_184220_m((Entity)this);
        }
    }

    public double func_70042_X() {
        int i = this.getSeahorseSize();
        float f = 0.85f + 0.3f * (float)i;
        return 0.55f * f;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.func_70090_H()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70177_z = livingentity.field_70177_z;
                if (this.func_70090_H()) {
                    this.field_70759_as = livingentity.field_70759_as;
                }
                this.field_70126_B = this.field_70177_z;
                this.field_70758_at = this.field_70759_as;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                float f1 = livingentity.field_191988_bg;
                float f = livingentity.field_70702_br * 0.75f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * 0.9f);
                    this.func_213309_a(0.1f, new Vector3d((double)f, livingentity.func_70040_Z().field_72448_b, (double)f1));
                    this.func_213315_a(MoverType.PLAYER, this.func_213322_ci());
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213309_a(0.1f, new Vector3d((double)f, livingentity.func_70040_Z().field_72448_b * 0.5, (double)f1));
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                super.func_213352_e(travelVector);
            }
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI();
    }

    public boolean func_213743_em() {
        return false;
    }

    public boolean func_70631_g_() {
        return false;
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        if (name.getString().toLowerCase().equals(CoralType.MYSTERY.name) && this.getVariantType() != CoralType.MYSTERY) {
            super.func_200203_b(name);
            this.setVariantType(CoralType.MYSTERY);
        }
    }

    public static enum CoralType {
        BUBBLE(0, "bubble", Blocks.field_203965_jG.func_176223_P(), Blocks.field_204280_jL.func_176223_P(), Blocks.field_211893_ka.func_176223_P()),
        FIRE(1, "fire", Blocks.field_203966_jH.func_176223_P(), Blocks.field_204281_jM.func_176223_P(), Blocks.field_211894_kb.func_176223_P()),
        TUBE(2, "tube", Blocks.field_203963_jE.func_176223_P(), Blocks.field_204278_jJ.func_176223_P(), Blocks.field_211891_jY.func_176223_P()),
        BRAIN(3, "brain", Blocks.field_203964_jF.func_176223_P(), Blocks.field_204279_jK.func_176223_P(), Blocks.field_211892_jZ.func_176223_P()),
        HORN(4, "horn", Blocks.field_203967_jI.func_176223_P(), Blocks.field_204282_jN.func_176223_P(), Blocks.field_211895_kc.func_176223_P()),
        MYSTERY(5, "mystery", null, null, null);

        private static final CoralType[] field_221088_c;
        private static final Map<String, CoralType> TYPES_BY_NAME;
        private final int index;
        private final String name;
        private final BlockState block;
        private final BlockState coral;
        private final BlockState fan;

        private CoralType(@Nullable int index, @Nullable String name, @Nullable BlockState block, BlockState coral, BlockState fan) {
            this.index = index;
            this.name = name;
            this.block = block;
            this.coral = coral;
            this.fan = fan;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public BlockState getBlock() {
            return this.block;
        }

        public BlockState getCoral() {
            return this.coral;
        }

        public BlockState getFan() {
            return this.fan;
        }

        public static CoralType getTypeByName(String nameIn) {
            return TYPES_BY_NAME.getOrDefault(nameIn, HORN);
        }

        public static CoralType getTypeByIndex(int indexIn) {
            if (indexIn < 0 || indexIn > field_221088_c.length) {
                indexIn = 0;
            }
            return field_221088_c[indexIn];
        }

        static {
            field_221088_c = (CoralType[])Arrays.stream(CoralType.values()).sorted(Comparator.comparingInt(CoralType::getIndex)).toArray(CoralType[]::new);
            TYPES_BY_NAME = Arrays.stream(CoralType.values()).collect(Collectors.toMap(CoralType::getName, p_221081_0_ -> p_221081_0_));
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final SeahorseEntity seahorse;

        public MoveHelperController(SeahorseEntity seahorse) {
            super((MobEntity)seahorse);
            this.seahorse = seahorse;
        }

        public void func_75641_c() {
            if (this.seahorse.func_70090_H()) {
                if (this.field_188491_h != MovementController.Action.MOVE_TO || this.seahorse.func_70661_as().func_75500_f()) {
                    this.seahorse.func_70659_e(0.0f);
                    return;
                }
                double d0 = this.field_75646_b - this.seahorse.func_226277_ct_();
                double d1 = this.field_75647_c - this.seahorse.func_226278_cu_();
                double d2 = this.field_75644_d - this.seahorse.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.seahorse.field_70761_aq = this.seahorse.field_70177_z = this.func_75639_a(this.seahorse.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.seahorse.func_233637_b_(Attributes.field_233821_d_));
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.seahorse.func_70689_ay(), (float)f1);
                this.seahorse.func_70659_e(f2);
                this.seahorse.func_213317_d(this.seahorse.func_213322_ci().func_72441_c((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
                this.seahorse.setMoving(true);
            } else {
                if (!this.seahorse.field_70122_E) {
                    this.seahorse.func_213317_d(this.seahorse.func_213322_ci().func_72441_c(0.0, -0.008, 0.0));
                    this.seahorse.setMoving(false);
                }
                super.func_75641_c();
            }
        }
    }
}

