/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.item.paradise;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pugz.omni.common.entity.paradise.SeahorseEntity;
import pugz.omni.core.registry.OmniEntities;

public class SeahorseBucketItem
extends BucketItem {
    private final Supplier<EntityType<SeahorseEntity>> seahorse = OmniEntities.SEAHORSE;

    public SeahorseBucketItem() {
        super(() -> Fluids.field_204546_a, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
    }

    public void func_203792_a(World world, ItemStack stack, BlockPos pos) {
        if (world instanceof ServerWorld) {
            this.placeEntity((ServerWorld)world, stack, pos);
        }
    }

    protected void func_203791_b(PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    protected void placeEntity(ServerWorld world, ItemStack stack, BlockPos pos) {
        Entity entity = this.seahorse.get().func_220331_a(world, stack, null, pos, SpawnReason.BUCKET, true, false);
        if (entity instanceof SeahorseEntity) {
            SeahorseEntity seahorse = (SeahorseEntity)entity;
            CompoundNBT nbt = stack.func_77978_p();
            int coralType = world.func_201674_k().nextInt(SeahorseEntity.CoralType.values().length - 1);
            int size = world.func_201674_k().nextInt(8);
            if (nbt != null) {
                if (nbt.func_150297_b("SeahorseVariantTag", 3)) {
                    coralType = nbt.func_74762_e("SeahorseVariantTag");
                }
                if (nbt.func_150297_b("SeahorseSizeTag", 4)) {
                    size = nbt.func_74762_e("SeahorseSizeTag");
                }
            }
            seahorse.setVariantType(SeahorseEntity.CoralType.getTypeByIndex(coralType));
            seahorse.setSeahorseSize(size);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("SeahorseVariantTag", 3)) {
            int i = compoundnbt.func_74762_e("SeahorseVariantTag");
            TextFormatting[] atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
            String s = "coral_type.omni." + SeahorseEntity.getCoralTypeName(i);
            TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(s);
            iformattabletextcomponent.func_240701_a_(atextformatting);
            tooltip.add((ITextComponent)iformattabletextcomponent);
        }
    }
}

