/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.biome;

import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import pugz.omni.core.util.IBaseBiome;

public abstract class AbstractBiome
implements IBaseBiome {
    private final String name;
    private final Biome biome;
    private final RegistryKey<Biome> key;

    public AbstractBiome(String name) {
        this.name = name;
        this.biome = new Biome.Builder().func_205419_a(this.getCategory()).func_205421_a(this.getDepth()).func_205417_d(this.getDownfall()).func_205415_a(this.getRainType()).func_205420_b(this.getScale()).func_205414_c(this.getTemperature()).func_235097_a_(new BiomeAmbience.Builder().func_235239_a_(this.getFogColor()).func_235246_b_(this.getWaterColor()).func_235248_c_(this.getWaterFogColor()).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_242539_d(this.getSkyColorWithTemperatureModifier(this.getTemperature())).func_235238_a_()).func_242457_a(this.getGenerationSettings()).func_242458_a(this.getMobSpawns()).func_242455_a();
        this.key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("omni", this.name));
        BiomeManager.addBiome((BiomeManager.BiomeType)this.getBiomeType(), (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(this.getKey(), this.getWeight()));
        BiomeDictionary.addTypes(this.getKey(), (BiomeDictionary.Type[])this.getBiomeDictionaryTypes());
    }

    public String getName() {
        return this.name;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public RegistryKey<Biome> getKey() {
        return this.key;
    }

    @Nonnull
    abstract BiomeManager.BiomeType getBiomeType();

    abstract int getWeight();

    @Nonnull
    abstract BiomeDictionary.Type[] getBiomeDictionaryTypes();

    @Nonnull
    abstract BiomeGenerationSettings getGenerationSettings();

    @Nonnull
    abstract MobSpawnInfo getMobSpawns();

    private int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

