/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.biome;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import pugz.omni.common.world.biome.AbstractBiome;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniSurfaceBuilders;

public class DesertJungleBiome
extends AbstractBiome {
    public DesertJungleBiome() {
        super("desert_jungle");
    }

    @Override
    public Biome.Category getCategory() {
        return Biome.Category.JUNGLE;
    }

    @Override
    public float getDepth() {
        return 0.125f;
    }

    @Override
    public float getScale() {
        return 0.1f;
    }

    @Override
    public float getTemperature() {
        return 1.0f;
    }

    @Override
    public float getDownfall() {
        return 0.7f;
    }

    @Override
    @Nonnull
    BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.WARM;
    }

    @Override
    int getWeight() {
        return (Integer)CoreModule.Configuration.COMMON.DESERT_JUNGLE_SPAWN_WEIGHT.get();
    }

    @Override
    @Nonnull
    BiomeDictionary.Type[] getBiomeDictionaryTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH};
    }

    @Override
    @Nonnull
    BiomeGenerationSettings getGenerationSettings() {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder();
        builder.func_242519_a(() -> OmniSurfaceBuilders.Configured.JUNGLE_DESERT);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244160_z);
        builder.func_242516_a(StructureFeatures.field_244140_f);
        DefaultBiomeFeatures.func_243723_ag((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244155_u);
        builder.func_242516_a(StructureFeatures.field_244135_a);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243744_g((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243709_W((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243705_S((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243720_ad((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243722_af((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243691_E((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243760_t((BiomeGenerationSettings.Builder)builder);
        return builder.func_242508_a();
    }

    @Override
    @Nonnull
    MobSpawnInfo getMobSpawns() {
        MobSpawnInfo.Builder builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243743_f((MobSpawnInfo.Builder)builder);
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200783_W, 10, 1, 1)).func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200781_U, 2, 1, 1)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220353_aa, 1, 1, 2));
        builder.func_242571_a();
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)builder);
        DefaultBiomeFeatures.func_243747_h((MobSpawnInfo.Builder)builder);
        return builder.func_242577_b();
    }
}

