/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.biome;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import pugz.omni.common.world.biome.AbstractBiome;
import pugz.omni.core.module.CoreModule;

public class FlowerFieldBiome
extends AbstractBiome {
    public FlowerFieldBiome() {
        super("flower_field");
    }

    @Override
    public Biome.Category getCategory() {
        return Biome.Category.PLAINS;
    }

    @Override
    public float getDepth() {
        return 0.125f;
    }

    @Override
    public float getScale() {
        return 0.05f;
    }

    @Override
    public float getTemperature() {
        return 0.8f;
    }

    @Override
    public float getDownfall() {
        return 0.4f;
    }

    @Override
    @Nonnull
    BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.COOL;
    }

    @Override
    int getWeight() {
        return (Integer)CoreModule.Configuration.COMMON.FLOWER_FIELD_SPAWN_WEIGHT.get();
    }

    @Override
    @Nonnull
    BiomeDictionary.Type[] getBiomeDictionaryTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD};
    }

    @Override
    @Nonnull
    BiomeGenerationSettings getGenerationSettings() {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder();
        builder.func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        builder.func_242516_a(StructureFeatures.field_244154_t).func_242516_a(StructureFeatures.field_244135_a);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244159_y);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243931_cn);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243927_cj);
        DefaultBiomeFeatures.func_243709_W((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243844_aq);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243704_R((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        return builder.func_242508_a();
    }

    @Override
    @Nonnull
    MobSpawnInfo getMobSpawns() {
        MobSpawnInfo.Builder builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)builder);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)builder);
        DefaultBiomeFeatures.func_243739_d((MobSpawnInfo.Builder)builder);
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
        builder.func_242571_a();
        return builder.func_242577_b();
    }
}

