/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.biome;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import pugz.omni.common.world.biome.AbstractBiome;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniSurfaceBuilders;

public class WoodedBadlandsBiome
extends AbstractBiome {
    public WoodedBadlandsBiome() {
        super("wooded_badlands");
    }

    @Override
    public Biome.Category getCategory() {
        return Biome.Category.MESA;
    }

    @Override
    public Biome.RainType getRainType() {
        return Biome.RainType.NONE;
    }

    @Override
    public float getDepth() {
        return 0.125f;
    }

    @Override
    public float getScale() {
        return 0.2f;
    }

    @Override
    public float getTemperature() {
        return 1.0f;
    }

    @Override
    public float getDownfall() {
        return 0.0f;
    }

    @Override
    @Nonnull
    BiomeManager.BiomeType getBiomeType() {
        return BiomeManager.BiomeType.DESERT;
    }

    @Override
    int getWeight() {
        return (Integer)CoreModule.Configuration.COMMON.WOODED_BADLANDS_SPAWN_WEIGHT.get();
    }

    @Override
    @Nonnull
    BiomeDictionary.Type[] getBiomeDictionaryTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.HOT};
    }

    @Override
    @Nonnull
    BiomeGenerationSettings getGenerationSettings() {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder();
        builder.func_242519_a(() -> OmniSurfaceBuilders.Configured.WOODED_BADLANDS);
        builder.func_242516_a(StructureFeatures.field_244160_z);
        DefaultBiomeFeatures.func_243713_a((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243723_ag((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244156_v);
        builder.func_242516_a(StructureFeatures.field_244135_a);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243744_g((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243708_V((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243698_L((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243699_M((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243718_ab((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243705_S((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243720_ad((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        return builder.func_242508_a();
    }

    @Override
    @Nonnull
    MobSpawnInfo getMobSpawns() {
        MobSpawnInfo.Builder builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243743_f((MobSpawnInfo.Builder)builder);
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)builder);
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200762_B, 1, 2, 6)).func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200798_l, 1, 1, 1));
        builder.func_242571_a();
        return builder.func_242577_b();
    }
}

