/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;

public class ExposedOreFeatureConfig
implements IFeatureConfig {
    public static final Codec<ExposedOreFeatureConfig> CODEC = RecordCodecBuilder.create(p_236568_0_ -> p_236568_0_.group((App)RuleTest.field_237127_c_.fieldOf("target").forGetter(config -> config.target), (App)BlockState.field_235877_b_.fieldOf("state").forGetter(config -> config.state), (App)BlockState.field_235877_b_.fieldOf("filler_state").forGetter(config -> config.state), (App)Codec.intRange((int)0, (int)64).fieldOf("size").forGetter(config -> config.size), (App)CaveFace.codec.fieldOf("variant").forGetter(config -> config.face)).apply((Applicative)p_236568_0_, ExposedOreFeatureConfig::new));
    public final RuleTest target;
    public final int size;
    public final BlockState state;
    @Nullable
    public final BlockState fillerState;
    public final CaveFace face;

    public ExposedOreFeatureConfig(RuleTest ruleTest, BlockState state, @Nullable BlockState fillerState, int size, CaveFace face) {
        this.size = size;
        this.state = state;
        this.fillerState = fillerState;
        this.target = ruleTest;
        this.face = face;
    }

    public static enum CaveFace implements IStringSerializable
    {
        FLOOR("floor"),
        CEILING("ceiling"),
        WALLS("walls"),
        FLOOR_CEILING("floor_ceiling"),
        FLOOR_BOTTOM("floor_bottom"),
        ABOVE_FLOOR_BOTTOM("above_floor_bottom"),
        ALL("all");

        public static final Codec<CaveFace> codec;
        private final String name;
        private static final Map<String, CaveFace> VALUES_MAP;

        private CaveFace(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static CaveFace byName(String nameIn) {
            return VALUES_MAP.get(nameIn);
        }

        static {
            codec = IStringSerializable.func_233023_a_(CaveFace::values, CaveFace::byName);
            VALUES_MAP = Arrays.stream(CaveFace.values()).collect(Collectors.toMap(CaveFace::func_176610_l, p_236573_0_ -> p_236573_0_));
        }
    }

    public static final class FillerBlockType {
        public static final RuleTest BASE_STONE_OVERWORLD = new TagMatchRuleTest((ITag)BlockTags.field_242172_aH);
        public static final RuleTest NETHERRACK = new BlockMatchRuleTest(Blocks.field_150424_aL);
        public static final RuleTest BASE_STONE_NETHER = new TagMatchRuleTest((ITag)BlockTags.field_242173_aI);
    }
}

