/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.feature.cavier_caves;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.registries.ForgeRegistries;
import pugz.omni.common.block.cavier_caves.BuddingMalachiteBlock;
import pugz.omni.common.world.feature.cavier_caves.GeodeFeatureConfig;
import pugz.omni.common.world.noise.NormalNoise;
import pugz.omni.common.world.noise.WorldGenRandom;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniBlocks;

public class GeodeFeature
extends Feature<GeodeFeatureConfig> {
    private static final Direction[] directions = Direction.values();

    public GeodeFeature(Codec<GeodeFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, GeodeFeatureConfig config) {
        int var30;
        int var29;
        int minGenOffset = config.minGenOffset;
        int maxGenOffset = config.maxGenOffset;
        if (world.func_180495_p(pos.func_177982_a(0, maxGenOffset / 3, 0)).func_196958_f() || world.func_180495_p(pos.func_177977_b()).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) && world.func_226691_t_(pos).func_201856_r() == Biome.Category.OCEAN) {
            return false;
        }
        LinkedList var8 = Lists.newLinkedList();
        int var9 = config.minDistribution + rand.nextInt(config.maxDistribution - config.minDistribution);
        WorldGenRandom worldGenRandom = new WorldGenRandom(world.func_72905_C());
        NormalNoise noise = NormalNoise.a(worldGenRandom, -4, 1.0);
        LinkedList var12 = Lists.newLinkedList();
        double var13 = (double)var9 / (double)config.maxOuterDistance;
        double var18 = 1.0 / Math.sqrt(1.7);
        double var20 = 1.0 / Math.sqrt(2.2 + var13);
        double var22 = 1.0 / Math.sqrt(3.2 + var13);
        double var24 = 1.0 / Math.sqrt(4.2 + var13);
        double var26 = 1.0 / Math.sqrt(2.0 + rand.nextDouble() / 2.0 + (var9 > 3 ? var13 : 0.0));
        boolean var28 = (double)rand.nextFloat() < 0.95;
        for (var29 = 0; var29 < var9; ++var29) {
            var30 = config.minOuterDistance + rand.nextInt(config.maxOuterDistance - config.minOuterDistance);
            int var31 = config.minOuterDistance + rand.nextInt(config.maxOuterDistance - config.minOuterDistance);
            int var32 = config.minOuterDistance + rand.nextInt(config.maxOuterDistance - config.minOuterDistance);
            var8.add(Pair.of((Object)pos.func_177982_a(var30, var31, var32), (Object)(config.minOffset + rand.nextInt(config.maxOffset - config.minOffset))));
        }
        if (var28) {
            var29 = rand.nextInt(4);
            var30 = var9 * 2 + 1;
            if (var29 == 0) {
                var12.add(pos.func_177982_a(var30, 7, 0));
                var12.add(pos.func_177982_a(var30, 5, 0));
                var12.add(pos.func_177982_a(var30, 1, 0));
            } else if (var29 == 1) {
                var12.add(pos.func_177982_a(0, 7, var30));
                var12.add(pos.func_177982_a(0, 5, var30));
                var12.add(pos.func_177982_a(0, 1, var30));
            } else if (var29 == 2) {
                var12.add(pos.func_177982_a(var30, 7, var30));
                var12.add(pos.func_177982_a(var30, 5, var30));
                var12.add(pos.func_177982_a(var30, 1, var30));
            } else {
                var12.add(pos.func_177982_a(0, 7, 0));
                var12.add(pos.func_177982_a(0, 5, 0));
                var12.add(pos.func_177982_a(0, 1, 0));
            }
        }
        ArrayList var40 = Lists.newArrayList();
        Iterator var41 = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(minGenOffset, minGenOffset, minGenOffset), (BlockPos)pos.func_177982_a(maxGenOffset, maxGenOffset, maxGenOffset)).iterator();
        while (true) {
            if (!var41.hasNext()) {
                ImmutableList var42 = ImmutableList.of((Object)((Block)OmniBlocks.SMALL_MALACHITE_BUD.get()).func_176223_P(), (Object)((Block)OmniBlocks.MEDIUM_MALACHITE_BUD.get()).func_176223_P(), (Object)((Block)OmniBlocks.LARGE_MALACHITE_BUD.get()).func_176223_P(), (Object)((Block)OmniBlocks.MALACHITE_CLUSTER.get()).func_176223_P());
                block2: for (BlockPos var46 : var40) {
                    BlockState crystalBudState = (BlockState)var42.get(rand.nextInt(var42.size()));
                    for (Direction var37 : directions) {
                        if (crystalBudState.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
                            crystalBudState = (BlockState)crystalBudState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)var37);
                        }
                        BlockPos var50 = var46.func_177972_a(var37);
                        BlockState var52 = world.func_180495_p(var50);
                        if (crystalBudState.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                            crystalBudState = (BlockState)crystalBudState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(var52.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)));
                        }
                        if (!BuddingMalachiteBlock.isStateAir(var52)) continue;
                        world.func_180501_a(var50, crystalBudState, 3);
                        continue block2;
                    }
                }
                return true;
            }
            BlockPos var43 = (BlockPos)var41.next();
            double var45 = noise.a(var43.func_177958_n(), var43.func_177956_o(), var43.func_177952_p()) * config.noiseMultiplier;
            double var34 = 0.0;
            double var36 = 0.0;
            for (Pair var39 : var8) {
                var34 += MathHelper.func_181161_i((double)(var43.func_177951_i((Vector3i)var39.getFirst()) + (double)((Integer)var39.getSecond()).intValue())) + var45;
            }
            for (BlockPos var51 : var12) {
                var36 += MathHelper.func_181161_i((double)(var43.func_177951_i((Vector3i)var51) + 2.0)) + var45;
            }
            if (var34 < var24) continue;
            if (var28 && var36 >= var26 && var34 < var18) {
                if (!world.func_204610_c(var43).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    world.func_180501_a(var43, Blocks.field_150350_a.func_176223_P(), 3);
                }
                world.func_205220_G_().func_205360_a(var43, (Object)world.func_180495_p(var43).func_177230_c(), 3);
                continue;
            }
            if (var34 >= var18) {
                if (!world.func_204610_c(var43).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    world.func_180501_a(var43, Blocks.field_150350_a.func_176223_P(), 3);
                }
                world.func_205220_G_().func_205360_a(var43, (Object)world.func_180495_p(var43).func_177230_c(), 3);
                continue;
            }
            if (var34 >= var20) {
                boolean var49;
                boolean bl = var49 = (double)rand.nextFloat() < config.alternateLayer0Chance;
                if (var49) {
                    world.func_180501_a(var43, ((Block)OmniBlocks.BUDDING_MALACHITE.get()).func_176223_P(), 3);
                } else {
                    world.func_180501_a(var43, ((Block)OmniBlocks.MALACHITE_BLOCK.get()).func_176223_P(), 3);
                }
                if (config.requireLayer0Alternate && !var49 || !((double)rand.nextFloat() < config.potentialPlacementsChance)) continue;
                var40.add(var43.func_185334_h());
                continue;
            }
            if (var34 >= var22) {
                world.func_180501_a(var43, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)CoreModule.Configuration.COMMON.GEODE_SHELL_INNER_BLOCK.get()))).func_176223_P(), 3);
                continue;
            }
            if (!(var34 >= var24)) continue;
            world.func_180501_a(var43, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)CoreModule.Configuration.COMMON.GEODE_SHELL_OUTER_BLOCK.get()))).func_176223_P(), 3);
        }
    }
}

