/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.feature.cavier_caves.caves;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Features;
import pugz.omni.common.block.cavier_caves.CaveMushroomBlock;
import pugz.omni.common.world.feature.cavier_caves.caves.AbstractCaveBiomeFeature;
import pugz.omni.common.world.feature.cavier_caves.caves.CaveBiomeFeatureConfig;
import pugz.omni.core.registry.OmniBlocks;

public class MushroomCaveBiomeFeature
extends AbstractCaveBiomeFeature {
    public MushroomCaveBiomeFeature(Codec<CaveBiomeFeatureConfig> codec) {
        super(codec);
    }

    @Override
    public void placeCeiling(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, Direction direction, CaveBiomeFeatureConfig config) {
        if (world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() == Blocks.field_201941_jj && world.func_180495_p(pos.func_177972_a(direction.func_176734_d())).func_177230_c() != Blocks.field_201941_jj) {
            if (config.ceilingState != null) {
                world.func_180501_a(pos, config.ceilingState, 2);
            }
            if (config.fillerState != null) {
                world.func_180501_a(pos.func_177972_a(direction.func_176734_d()), config.fillerState, 2);
            }
        }
    }

    @Override
    public void placeWall(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, Direction direction, CaveBiomeFeatureConfig config) {
        if (world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() == Blocks.field_201941_jj && world.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c() != Blocks.field_201941_jj) {
            if (config.wallState != null) {
                world.func_180501_a(pos, config.wallState, 2);
            }
            if (config.fillerState != null) {
                world.func_180501_a(pos.func_177972_a(direction.func_176734_d()), config.fillerState, 2);
            }
        }
    }

    @Override
    public void placeFloor(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, Direction direction, CaveBiomeFeatureConfig config) {
        if (world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() == Blocks.field_201941_jj && world.func_180495_p(pos.func_177972_a(direction.func_176734_d())).func_177230_c() != Blocks.field_201941_jj) {
            if (config.floorState != null) {
                world.func_180501_a(pos, config.floorState, 2);
            }
            if (config.fillerState != null) {
                world.func_180501_a(pos.func_177972_a(direction.func_176734_d()), config.fillerState, 2);
            }
            if (rand.nextFloat() <= config.featureChance && world.func_180495_p(pos).func_177230_c() == Blocks.field_150391_bh) {
                if (rand.nextInt(3) == 0) {
                    world.func_180501_a(pos.func_177984_a(), (BlockState)this.getRandomSmallState(rand).func_206870_a((Property)CaveMushroomBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a))), 2);
                    return;
                }
                if (rand.nextInt(5) == 0) {
                    if (rand.nextBoolean()) {
                        Features.field_243842_ao.func_242765_a(world, generator, rand, pos.func_177984_a());
                    } else {
                        Features.field_243841_an.func_242765_a(world, generator, rand, pos.func_177984_a());
                    }
                }
                int height = rand.nextInt(4) + 1;
                BlockState state = this.getRandomState(rand);
                for (int y = pos.func_177984_a().func_177956_o(); y <= pos.func_177984_a().func_177956_o() + height; ++y) {
                    BlockPos place1 = new BlockPos(pos.func_177984_a().func_177958_n(), y, pos.func_177984_a().func_177952_p());
                    world.func_180501_a(place1, ((Block)OmniBlocks.CAVE_MUSHROOM_STEM.get()).func_176223_P(), 2);
                    if (y != pos.func_177984_a().func_177956_o() + height) continue;
                    for (Direction d : Direction.values()) {
                        if (world.func_180495_p(place1.func_177972_a(d)).func_200132_m()) continue;
                        world.func_180501_a(place1.func_177972_a(d), state, 2);
                    }
                }
            }
        }
    }

    private BlockState getRandomState(Random random) {
        int i = random.nextInt(4);
        switch (i) {
            case 3: {
                return ((Block)OmniBlocks.PURPLE_CAVE_MUSHROOM_BLOCK.get()).func_176223_P();
            }
            case 2: {
                return ((Block)OmniBlocks.BLUE_CAVE_MUSHROOM_BLOCK.get()).func_176223_P();
            }
            case 1: {
                return ((Block)OmniBlocks.GREEN_CAVE_MUSHROOM_BLOCK.get()).func_176223_P();
            }
        }
        return ((Block)OmniBlocks.YELLOW_CAVE_MUSHROOM_BLOCK.get()).func_176223_P();
    }

    private BlockState getRandomSmallState(Random random) {
        int i = random.nextInt(4);
        switch (i) {
            case 3: {
                return ((Block)OmniBlocks.PURPLE_CAVE_MUSHROOM.get()).func_176223_P();
            }
            case 2: {
                return ((Block)OmniBlocks.BLUE_CAVE_MUSHROOM.get()).func_176223_P();
            }
            case 1: {
                return ((Block)OmniBlocks.GREEN_CAVE_MUSHROOM.get()).func_176223_P();
            }
        }
        return ((Block)OmniBlocks.YELLOW_CAVE_MUSHROOM.get()).func_176223_P();
    }
}

