/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.feature.wild_west;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import pugz.omni.common.block.wild_west.SaguaroCactusBlock;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniBlocks;

public class SaguaroCactusFeature
extends Feature<NoFeatureConfig> {
    public SaguaroCactusFeature(Codec<NoFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        int xOffset = random.nextInt(8) - random.nextInt(8);
        int zOffset = random.nextInt(8) - random.nextInt(8);
        int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n() + xOffset, pos.func_177952_p() + zOffset);
        BlockPos place = new BlockPos(pos.func_177958_n() + xOffset, y, pos.func_177952_p() + zOffset);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(world.func_180495_p(place.func_177972_a(direction)).func_177230_c() instanceof SaguaroCactusBlock)) continue;
            return false;
        }
        if (world.func_180495_p(place.func_177972_a(Direction.DOWN)).func_177230_c() instanceof SaguaroCactusBlock && random.nextBoolean() && !((Boolean)CoreModule.Configuration.COMMON.FANTASTICAL_SAGUAROS.get()).booleanValue()) {
            return false;
        }
        return this.generateCactus(world, random.nextBoolean(), place, random, random.nextInt(50) == 0);
    }

    public boolean generateCactus(ISeedReader world, boolean northSouth, BlockPos pos, Random random, boolean isBig) {
        BlockPos nextPos;
        Direction[] directionArray;
        if (!((Block)OmniBlocks.SAGUARO_CACTUS.get()).func_176223_P().func_196955_c((IWorldReader)world, pos)) {
            return false;
        }
        boolean hasArms = random.nextInt(12) > 0;
        boolean twoArms = random.nextInt(5) != 0;
        int centerHeight = world.func_201674_k().nextInt(4) + 4;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        for (int y = 0; y <= centerHeight && (y <= 0 || world.func_180495_p((BlockPos)blockpos$mutable).func_196958_f()); ++y) {
            world.func_180501_a((BlockPos)blockpos$mutable, ((Block)OmniBlocks.SAGUARO_CACTUS.get()).func_176223_P(), 2);
            blockpos$mutable.func_189536_c(Direction.UP);
            if (y != centerHeight - 1 || random.nextInt(3) != 0) continue;
            world.func_180501_a((BlockPos)blockpos$mutable, ((Block)OmniBlocks.CACTUS_BLOOM.get()).func_176223_P(), 2);
        }
        if (!hasArms) {
            return true;
        }
        int yTop = blockpos$mutable.func_177956_o();
        int armStart = world.func_201674_k().nextInt(centerHeight - 3) + 1;
        if (northSouth) {
            Direction[] directionArray2 = new Direction[2];
            directionArray2[0] = Direction.NORTH;
            directionArray = directionArray2;
            directionArray2[1] = Direction.SOUTH;
        } else {
            Direction[] directionArray3 = new Direction[2];
            directionArray3[0] = Direction.EAST;
            directionArray = directionArray3;
            directionArray3[1] = Direction.WEST;
        }
        Direction[] directions = directionArray;
        if (twoArms) {
            for (Direction d : directions) {
                this.generateArm(world, d, blockpos$mutable.func_177958_n(), pos.func_177956_o() + armStart, blockpos$mutable.func_177952_p(), yTop);
                armStart = world.func_201674_k().nextInt(centerHeight - 3) + 1;
            }
        } else {
            this.generateArm(world, directions[random.nextInt(directions.length)], blockpos$mutable.func_177958_n(), pos.func_177956_o() + armStart, blockpos$mutable.func_177952_p(), yTop);
        }
        if ((!isBig && random.nextInt(10) == 0 || isBig && random.nextInt(50) == 0) && world.func_180495_p(nextPos = new BlockPos(pos.func_177958_n(), yTop, pos.func_177952_p())).func_196958_f()) {
            this.generateCactus(world, random.nextBoolean(), nextPos, random, true);
        }
        return true;
    }

    private void generateArm(ISeedReader world, Direction direction, int centerX, int armY, int centerZ, int centerHeight) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(centerX + direction.func_82601_c(), armY, centerZ + direction.func_82599_e());
        if (!world.func_180495_p((BlockPos)blockpos$mutable).func_196958_f()) {
            return;
        }
        BlockPos centerPos = blockpos$mutable.func_177972_a(direction.func_176734_d());
        BlockState centerState = world.func_180495_p(centerPos);
        if (!centerState.func_203425_a((Block)OmniBlocks.SAGUARO_CACTUS.get())) {
            return;
        }
        world.func_180501_a(centerPos, (BlockState)centerState.func_206870_a((Property)SaguaroCactusBlock.FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a((BlockPos)blockpos$mutable, (BlockState)((BlockState)((BlockState)((Block)OmniBlocks.SAGUARO_CACTUS.get()).func_176223_P().func_206870_a((Property)SaguaroCactusBlock.HORIZONTAL, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SaguaroCactusBlock.HORIZONTAL_DIRECTION, (Comparable)direction.func_176734_d())).func_206870_a((Property)SaguaroCactusBlock.FACING_PROPERTIES.get(direction.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
        blockpos$mutable.func_189536_c(Direction.UP);
        int armHeight = Math.max(1, centerHeight - blockpos$mutable.func_177956_o() + world.func_201674_k().nextInt(2) - 3);
        for (int i = 0; i <= armHeight; ++i) {
            if (!world.func_180495_p((BlockPos)blockpos$mutable).func_196958_f()) {
                return;
            }
            world.func_180501_a((BlockPos)blockpos$mutable, ((Block)OmniBlocks.SAGUARO_CACTUS.get()).func_176223_P(), 2);
            blockpos$mutable.func_189536_c(Direction.UP);
            if (i != armHeight - 1 || world.func_201674_k().nextInt(3) != 0) continue;
            world.func_180501_a((BlockPos)blockpos$mutable, ((Block)OmniBlocks.CACTUS_BLOOM.get()).func_176223_P(), 2);
        }
    }
}

