/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.stats.StatType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import pugz.omni.core.module.CavierCavesModule;
import pugz.omni.core.module.ColormaticModule;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.module.FieryNetherModule;
import pugz.omni.core.module.ForestryModule;
import pugz.omni.core.module.MiscellaneousModule;
import pugz.omni.core.module.ParadiseModule;
import pugz.omni.core.module.WildWestModule;
import pugz.omni.core.module.WintertimeModule;

@Mod(value="omni")
public class Omni {
    public static final String MOD_ID = "omni";

    public Omni() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Registries.BLOCKS.register(eventBus);
        OverrideRegistries.BLOCKS.register(eventBus);
        Registries.ITEMS.register(eventBus);
        OverrideRegistries.ITEMS.register(eventBus);
        Registries.TILE_ENTITIES.register(eventBus);
        Registries.ENTITIES.register(eventBus);
        Registries.BIOMES.register(eventBus);
        OverrideRegistries.BIOMES.register(eventBus);
        Registries.SURFACE_BUILDERS.register(eventBus);
        Registries.CARVERS.register(eventBus);
        Registries.FEATURES.register(eventBus);
        Registries.STRUCTURES.register(eventBus);
        Registries.ENCHANTMENTS.register(eventBus);
        OverrideRegistries.ENCHANTMENTS.register(eventBus);
        Registries.EFFECTS.register(eventBus);
        Registries.SOUNDS.register(eventBus);
        Registries.PARTICLES.register(eventBus);
        Registries.STATS.register(eventBus);
        this.registerModuleInit();
        eventBus.addListener(this::setupCommon);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> eventBus.addListener(EventPriority.LOWEST, this::setupClient));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CoreModule.Configuration.COMMON_SPEC);
    }

    private void registerModuleInit() {
        CoreModule.instance.initialize();
        CavierCavesModule.instance.initialize();
        ColormaticModule.instance.initialize();
        FieryNetherModule.instance.initialize();
        ForestryModule.instance.initialize();
        MiscellaneousModule.instance.initialize();
        ParadiseModule.instance.initialize();
        WildWestModule.instance.initialize();
        WintertimeModule.instance.initialize();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerModuleClient() {
        CoreModule.instance.initializeClient();
        CavierCavesModule.instance.initializeClient();
        ColormaticModule.instance.initializeClient();
        FieryNetherModule.instance.initializeClient();
        ForestryModule.instance.initializeClient();
        MiscellaneousModule.instance.initializeClient();
        ParadiseModule.instance.initializeClient();
        WildWestModule.instance.initializeClient();
        WintertimeModule.instance.initializeClient();
    }

    private void registerModulePost(FMLCommonSetupEvent event) {
        CoreModule.instance.initializePost(event);
        CavierCavesModule.instance.initializePost(event);
        ColormaticModule.instance.initializePost(event);
        FieryNetherModule.instance.initializePost(event);
        ForestryModule.instance.initializePost(event);
        MiscellaneousModule.instance.initializePost(event);
        ParadiseModule.instance.initializePost(event);
        WildWestModule.instance.initializePost(event);
        WintertimeModule.instance.initializePost(event);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TileEntityType.field_200978_i.field_223046_I = new HashSet(TileEntityType.field_200978_i.field_223046_I);
        });
        this.registerModulePost(event);
    }

    private void setupClient(FMLClientSetupEvent event) {
        this.registerModuleClient();
    }

    public static class OverrideRegistries {
        public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"minecraft");
        public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"minecraft");
        public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"minecraft");
        public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"minecraft");
    }

    public static class Registries {
        public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"omni");
        public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"omni");
        public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"omni");
        public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"omni");
        public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"omni");
        public static final DeferredRegister<SurfaceBuilder<?>> SURFACE_BUILDERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SURFACE_BUILDERS, (String)"omni");
        public static final DeferredRegister<WorldCarver<?>> CARVERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_CARVERS, (String)"omni");
        public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"omni");
        public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"omni");
        public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"omni");
        public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"omni");
        public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"omni");
        public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"omni");
        public static final DeferredRegister<StatType<?>> STATS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STAT_TYPES, (String)"omni");
    }
}

