/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import pugz.omni.core.util.IBaseBlock;

public abstract class AbstractModule {
    private final String name;

    public AbstractModule(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected abstract void onInitialize();

    protected abstract void onClientInitialize();

    protected abstract void onPostInitialize(FMLCommonSetupEvent var1);

    protected abstract void sendInitMessage();

    public void initialize() {
        this.registerBlocks();
        this.registerItems();
        this.registerTileEntities();
        this.registerEntities();
        this.registerBiomes();
        this.registerSurfaceBuilders();
        this.registerFeatures();
        this.registerPlacers();
        this.registerCarvers();
        this.registerDimensions();
        this.registerEnchantments();
        this.registerEffects();
        this.registerSounds();
        this.registerParticles();
        this.registerStats();
        this.onInitialize();
        this.sendInitMessage();
    }

    public void initializeClient() {
        this.onClientInitialize();
        ForgeRegistries.BLOCKS.getEntries().forEach(block -> {
            IBaseBlock baseBlock;
            if (block.getValue() instanceof IBaseBlock && (baseBlock = (IBaseBlock)block.getValue()).getRenderType() != RenderType.func_228639_c_()) {
                RenderTypeLookup.setRenderLayer((Block)((Block)baseBlock), (RenderType)baseBlock.getRenderType());
            }
        });
    }

    public void initializePost(FMLCommonSetupEvent event) {
        this.onPostInitialize(event);
        this.registerConfiguredFeatures();
        ForgeRegistries.BLOCKS.getValues().forEach(block -> {
            if (block instanceof IBaseBlock) {
                IBaseBlock baseBlock = (IBaseBlock)block;
                FireBlock fire = (FireBlock)Blocks.field_150480_ab;
                if (baseBlock.getFireFlammability() != 0 && baseBlock.getFireEncouragement() != 0) {
                    fire.func_180686_a((Block)baseBlock, baseBlock.getFireEncouragement(), baseBlock.getFireFlammability());
                }
                if (baseBlock.getCompostChance() != 0.0f) {
                    ComposterBlock.field_220299_b.put((Object)((Block)baseBlock).func_199767_j(), baseBlock.getCompostChance());
                }
            }
        });
    }

    protected void registerBlocks() {
    }

    protected void registerItems() {
    }

    protected void registerTileEntities() {
    }

    protected void registerEntities() {
    }

    protected void registerBiomes() {
    }

    protected void registerSurfaceBuilders() {
    }

    protected void registerFeatures() {
    }

    protected void registerConfiguredFeatures() {
    }

    protected void registerPlacers() {
    }

    protected void registerCarvers() {
    }

    protected void registerDimensions() {
    }

    protected void registerEnchantments() {
    }

    protected void registerEffects() {
    }

    protected void registerParticles() {
    }

    protected void registerSounds() {
    }

    protected void registerStats() {
    }
}

