/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SlimeBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.stats.IStatFormatter;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.DecoratedPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.StringUtils;
import pugz.omni.client.render.SizedCaveSpiderRenderer;
import pugz.omni.client.render.SpeleothemRenderer;
import pugz.omni.common.block.HorizontalFacingBlock;
import pugz.omni.common.block.OmniBeehiveBlock;
import pugz.omni.common.block.OmniChestBlock;
import pugz.omni.common.block.OmniLogBlock;
import pugz.omni.common.block.OmniStandingSignBlock;
import pugz.omni.common.block.OmniTrappedChestBlock;
import pugz.omni.common.block.OmniWallSignBlock;
import pugz.omni.common.block.VerticalSlabBlock;
import pugz.omni.common.block.cavier_caves.ArctissBlock;
import pugz.omni.common.block.cavier_caves.BlueCaveMushroomBlock;
import pugz.omni.common.block.cavier_caves.BuddingMalachiteBlock;
import pugz.omni.common.block.cavier_caves.CaveMushroomBlock;
import pugz.omni.common.block.cavier_caves.MalachiteBlock;
import pugz.omni.common.block.cavier_caves.MalachiteBudBlock;
import pugz.omni.common.block.cavier_caves.PurpleCaveMushroomBlock;
import pugz.omni.common.block.cavier_caves.SpeleothemBlock;
import pugz.omni.common.block.cavier_caves.YellowCaveMushroomBlock;
import pugz.omni.common.entity.cavier_caves.SizedCaveSpiderEntity;
import pugz.omni.common.item.OmniBoatItem;
import pugz.omni.common.item.OmniSignItem;
import pugz.omni.common.world.feature.cavier_caves.GeodeFeature;
import pugz.omni.common.world.feature.cavier_caves.GeodeFeatureConfig;
import pugz.omni.common.world.feature.cavier_caves.SpeleothemFeature;
import pugz.omni.common.world.feature.cavier_caves.SpeleothemFeatureConfig;
import pugz.omni.common.world.feature.cavier_caves.caves.CaveBiomeFeatureConfig;
import pugz.omni.common.world.feature.cavier_caves.caves.IcyCaveBiomeFeature;
import pugz.omni.common.world.feature.cavier_caves.caves.MushroomCaveBiomeFeature;
import pugz.omni.common.world.feature.cavier_caves.caves.TerracottaCaveBiomeFeature;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniEntities;
import pugz.omni.core.registry.OmniFeatures;
import pugz.omni.core.registry.OmniItems;
import pugz.omni.core.registry.OmniSoundEvents;
import pugz.omni.core.registry.OmniStats;
import pugz.omni.core.util.BiomeFeatures;
import pugz.omni.core.util.RegistryUtil;

public class CavierCavesModule
extends AbstractModule {
    public static final CavierCavesModule instance = new CavierCavesModule();

    public CavierCavesModule() {
        super("Cavier Caves");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Explored the Depths of the Cavier Caves!");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingJump);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onClientInitialize() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OmniEntities.CAVE_SPIDER.get()), SizedCaveSpiderRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OmniEntities.SPELEOTHEM.get()), SpeleothemRenderer::new);
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.CAVE_MUSHROOM_DOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.CAVE_MUSHROOM_TRAPDOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.CAVE_MUSHROOM_LADDER.get()), (RenderType)RenderType.func_228643_e_());
        RegistryUtil.sprites.add(new RenderMaterial(Atlases.field_228746_e_, new ResourceLocation("omni", "entity/sign/cave_mushroom")));
    }

    @Override
    protected void onPostInitialize(FMLCommonSetupEvent event) {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)OmniEntities.CAVE_SPIDER.get()), (AttributeModifierMap)SizedCaveSpiderEntity.func_234277_m_().func_233813_a_());
        event.enqueueWork(() -> {
            TileEntityType.field_200978_i.field_223046_I.add(OmniBlocks.CAVE_MUSHROOM_SIGN.get());
            TileEntityType.field_200978_i.field_223046_I.add(OmniBlocks.CAVE_MUSHROOM_WALL_SIGN.get());
        });
    }

    @Override
    protected void registerBlocks() {
        OmniBlocks.YELLOW_CAVE_MUSHROOM = RegistryUtil.createBlock("yellow_cave_mushroom", YellowCaveMushroomBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.GREEN_CAVE_MUSHROOM = RegistryUtil.createBlock("green_cave_mushroom", () -> new CaveMushroomBlock(MaterialColor.field_151651_C), ItemGroup.field_78031_c);
        OmniBlocks.BLUE_CAVE_MUSHROOM = RegistryUtil.createBlock("blue_cave_mushroom", BlueCaveMushroomBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.PURPLE_CAVE_MUSHROOM = RegistryUtil.createBlock("purple_cave_mushroom", PurpleCaveMushroomBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.YELLOW_CAVE_MUSHROOM_BLOCK = RegistryUtil.createBlock("yellow_cave_mushroom_block", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150419_aX)), ItemGroup.field_78030_b);
        OmniBlocks.GREEN_CAVE_MUSHROOM_BLOCK = RegistryUtil.createBlock("green_cave_mushroom_block", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150419_aX)), ItemGroup.field_78030_b);
        OmniBlocks.BLUE_CAVE_MUSHROOM_BLOCK = RegistryUtil.createBlock("blue_cave_mushroom_block", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150419_aX)), ItemGroup.field_78030_b);
        OmniBlocks.PURPLE_CAVE_MUSHROOM_BLOCK = RegistryUtil.createBlock("purple_cave_mushroom_block", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150419_aX)), ItemGroup.field_78030_b);
        OmniBlocks.STRIPPED_CAVE_MUSHROOM_STEM = RegistryUtil.createBlock("stripped_cave_mushroom_stem", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196617_K)), ItemGroup.field_78030_b);
        OmniBlocks.CAVE_MUSHROOM_STEM = RegistryUtil.createBlock("cave_mushroom_stem", () -> new OmniLogBlock((RotatedPillarBlock)OmniBlocks.STRIPPED_CAVE_MUSHROOM_STEM.get()), ItemGroup.field_78030_b);
        OmniBlocks.STRIPPED_CAVE_MUSHROOM_HYPHAE = RegistryUtil.createBlock("stripped_cave_mushroom_hyphae", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196617_K)), ItemGroup.field_78030_b);
        OmniBlocks.CAVE_MUSHROOM_HYPHAE = RegistryUtil.createBlock("cave_mushroom_hyphae", () -> new OmniLogBlock((RotatedPillarBlock)OmniBlocks.STRIPPED_CAVE_MUSHROOM_HYPHAE.get()), ItemGroup.field_78030_b);
        OmniBlocks.CAVE_MUSHROOM_PLANKS = RegistryUtil.createBlock("cave_mushroom_planks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196662_n)), ItemGroup.field_78030_b);
        OmniBlocks.CAVE_MUSHROOM_STAIRS = RegistryUtil.createBlock("cave_mushroom_stairs", () -> new StairsBlock(() -> ((Block)((Block)OmniBlocks.CAVE_MUSHROOM_PLANKS.get())).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.CAVE_MUSHROOM_PLANKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.CAVE_MUSHROOM_SLAB = RegistryUtil.createBlock("cave_mushroom_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.CAVE_MUSHROOM_PLANKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.CAVE_MUSHROOM_FENCE = RegistryUtil.createBlock("cave_mushroom_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.CAVE_MUSHROOM_PLANKS.get()))), ItemGroup.field_78031_c);
        OmniBlocks.CAVE_MUSHROOM_FENCE_GATE = RegistryUtil.createBlock("cave_mushroom_fence_gate", () -> new FenceGateBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.CAVE_MUSHROOM_PLANKS.get()))), ItemGroup.field_78028_d);
        OmniBlocks.CAVE_MUSHROOM_BUTTON = RegistryUtil.createBlock("cave_mushroom_button", () -> new WoodButtonBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196689_eF)), ItemGroup.field_78028_d);
        OmniBlocks.CAVE_MUSHROOM_PRESSURE_PLATE = RegistryUtil.createBlock("cave_mushroom_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196663_cq)), ItemGroup.field_78028_d);
        OmniBlocks.CAVE_MUSHROOM_DOOR = RegistryUtil.createDoor("cave_mushroom_door", () -> new DoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180413_ao)), ItemGroup.field_78028_d);
        OmniBlocks.CAVE_MUSHROOM_TRAPDOOR = RegistryUtil.createBlock("cave_mushroom_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196636_cW)), ItemGroup.field_78028_d);
        OmniBlocks.CAVE_MUSHROOM_LADDER = RegistryUtil.createBlock("cave_mushroom_ladder", () -> new LadderBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150468_ap)), ItemGroup.field_78031_c);
        OmniBlocks.CAVE_MUSHROOM_BOOKSHELF = RegistryUtil.createBlock("cave_mushroom_bookshelf", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180413_ao)), ItemGroup.field_78030_b);
        OmniBlocks.CAVE_MUSHROOM_CHEST = RegistryUtil.createBlock("cave_mushroom_chest", () -> new OmniChestBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180413_ao), "cave_mushroom"), ItemGroup.field_78031_c);
        OmniBlocks.CAVE_MUSHROOM_TRAPPED_CHEST = RegistryUtil.createBlock("cave_mushroom_trapped_chest", () -> new OmniTrappedChestBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180413_ao), "cave_mushroom"), ItemGroup.field_78028_d);
        OmniBlocks.CAVE_MUSHROOM_SIGN = RegistryUtil.createBlock("cave_mushroom_sign", () -> new OmniStandingSignBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222384_bX), "cave_mushroom"));
        OmniBlocks.CAVE_MUSHROOM_WALL_SIGN = RegistryUtil.createBlock("cave_mushroom_wall_sign", () -> new OmniWallSignBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222392_ch).func_222379_b((Block)OmniBlocks.CAVE_MUSHROOM_SIGN.get()), "cave_mushroom"));
        OmniBlocks.CAVE_MUSHROOM_BEEHIVE = RegistryUtil.createBlock("cave_mushroom_beehive", OmniBeehiveBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.VERTICAL_CAVE_MUSHROOM_PLANKS = RegistryUtil.createBlock("vertical_cave_mushroom_planks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.CAVE_MUSHROOM_PLANKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.CAVE_MUSHROOM_VERTICAL_SLAB = RegistryUtil.createBlock("cave_mushroom_vertical_slab", () -> new VerticalSlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.CAVE_MUSHROOM_PLANKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.STONE_SPELEOTHEM = RegistryUtil.createBlock("stone_speleothem", () -> new SpeleothemBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_235861_h_().func_200948_a(1.25f, 0.1f)), ItemGroup.field_78031_c);
        OmniBlocks.ICE_SPELEOTHEM = RegistryUtil.createBlock("ice_speleothem", () -> new SpeleothemBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151598_x).func_200941_a(0.98f).func_200948_a(0.4f, 0.1f).func_200947_a(SoundType.field_185853_f)), ItemGroup.field_78031_c);
        OmniBlocks.NETHERRACK_SPELEOTHEM = RegistryUtil.createBlock("netherrack_speleothem", () -> new SpeleothemBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151655_K).func_235861_h_().func_200948_a(0.3f, 0.1f)), ItemGroup.field_78031_c);
        OmniBlocks.MALACHITE_BLOCK = RegistryUtil.createBlock("malachite_block", MalachiteBlock::new, ItemGroup.field_78030_b);
        OmniBlocks.BUDDING_MALACHITE = RegistryUtil.createBlock("budding_malachite", BuddingMalachiteBlock::new, ItemGroup.field_78030_b);
        OmniBlocks.MALACHITE_CLUSTER = RegistryUtil.createBlock("malachite_cluster", () -> new MalachiteBudBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.5f, 9.5f), 3), ItemGroup.field_78031_c);
        OmniBlocks.LARGE_MALACHITE_BUD = RegistryUtil.createBlock("large_malachite_bud", () -> new MalachiteBudBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 9.0f), 2), ItemGroup.field_78031_c);
        OmniBlocks.MEDIUM_MALACHITE_BUD = RegistryUtil.createBlock("medium_malachite_bud", () -> new MalachiteBudBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.5f, 8.5f), 1), ItemGroup.field_78031_c);
        OmniBlocks.SMALL_MALACHITE_BUD = RegistryUtil.createBlock("small_malachite_bud", () -> new MalachiteBudBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 8.0f), 0), ItemGroup.field_78031_c);
        OmniBlocks.CARVED_MALACHITE = RegistryUtil.createBlock("carved_malachite", () -> new HorizontalFacingBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.MALACHITE_BLOCK.get()))), ItemGroup.field_78030_b);
        OmniBlocks.ARCTISS = RegistryUtil.createBlock("arctiss", ArctissBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.ARCTISS_BLOCK = RegistryUtil.createBlock("arctiss_block", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b)), ItemGroup.field_78030_b);
        OmniBlocks.LYCHGATE_BLOCK = RegistryUtil.createBlock("lychgate_block", () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(5.0f, 15.0f).func_235861_h_().func_200947_a(SoundType.field_235595_Q_)), ItemGroup.field_78030_b);
    }

    @Override
    protected void registerItems() {
        OmniItems.MALACHITE_SHARD = RegistryUtil.createItem("malachite_shard", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78035_l)));
        OmniItems.CAVE_MUSHROOM_BOAT = RegistryUtil.createItem("cave_mushroom_boat", () -> new OmniBoatItem(new Item.Properties().func_200916_a(ItemGroup.field_78029_e).func_200917_a(1), "cave_mushroom"));
        OmniItems.CAVE_MUSHROOM_SIGN = RegistryUtil.createItem("cave_mushroom_sign", () -> new OmniSignItem(new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_200917_a(16), (Block)OmniBlocks.CAVE_MUSHROOM_SIGN.get(), (Block)OmniBlocks.CAVE_MUSHROOM_WALL_SIGN.get()));
        OmniItems.LYCHMETAL_INGOT = RegistryUtil.createItem("lychmetal_ingot", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78035_l)));
    }

    @Override
    protected void registerEntities() {
        OmniEntities.CAVE_SPIDER = RegistryUtil.createEntity("cave_spider", () -> OmniEntities.createLivingEntity(SizedCaveSpiderEntity::new, EntityClassification.MONSTER, "cave_spider", 0.7f, 0.5f));
        OmniEntities.SPELEOTHEM = RegistryUtil.createEntity("speleothem", OmniEntities::createSpeleothemEntity);
    }

    @Override
    protected void registerFeatures() {
        OmniFeatures.MUSHROOM_CAVE = RegistryUtil.createFeature("mushroom_cave", () -> new MushroomCaveBiomeFeature(CaveBiomeFeatureConfig.CODEC));
        OmniFeatures.ICY_CAVE = RegistryUtil.createFeature("icy_cave", () -> new IcyCaveBiomeFeature(CaveBiomeFeatureConfig.CODEC));
        OmniFeatures.TERRACOTTA_CAVE = RegistryUtil.createFeature("terracotta_cave", () -> new TerracottaCaveBiomeFeature(CaveBiomeFeatureConfig.CODEC));
        OmniFeatures.SPELEOTHEM = RegistryUtil.createFeature("speleothem", () -> new SpeleothemFeature(SpeleothemFeatureConfig.CODEC));
        OmniFeatures.GEODE = RegistryUtil.createFeature("geode", () -> new GeodeFeature(GeodeFeatureConfig.CODEC));
    }

    @Override
    protected void registerConfiguredFeatures() {
        OmniFeatures.Configured.STONE_SPELEOTHEM = RegistryUtil.createConfiguredFeature("stone_speleothem", (ConfiguredFeature)((Feature)OmniFeatures.SPELEOTHEM.get()).func_225566_b_((IFeatureConfig)new SpeleothemFeatureConfig(SpeleothemFeatureConfig.Variant.STONE)).func_242729_a(2));
        OmniFeatures.Configured.ICICLE = RegistryUtil.createConfiguredFeature("icicle", (ConfiguredFeature)((Feature)OmniFeatures.SPELEOTHEM.get()).func_225566_b_((IFeatureConfig)new SpeleothemFeatureConfig(SpeleothemFeatureConfig.Variant.ICE)).func_242729_a(2));
        OmniFeatures.Configured.NETHERRACK_SPELEOTHEM = RegistryUtil.createConfiguredFeature("netherrack_speleothem", (ConfiguredFeature)((Feature)OmniFeatures.SPELEOTHEM.get()).func_225566_b_((IFeatureConfig)new SpeleothemFeatureConfig(SpeleothemFeatureConfig.Variant.NETHERRACK)).func_242729_a(2));
        OmniFeatures.Configured.MALACHITE_GEODE = RegistryUtil.createConfiguredFeature("malachite_geode", ((Feature)OmniFeatures.GEODE.get()).func_225566_b_((IFeatureConfig)new GeodeFeatureConfig(0.35, 0.083, true, 4, 7, 3, 5, 1, 3, -16, 16, 0.05)).func_227228_a_((ConfiguredPlacement)DecoratedPlacement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(6, 0, 47)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.MALACHITE_GEODE_SPAWN_CHANCE.get()).intValue())));
        OmniFeatures.Configured.MUSHROOM_CAVE = RegistryUtil.createConfiguredFeature("mushroom_cave", ((Feature)OmniFeatures.MUSHROOM_CAVE.get()).func_225566_b_((IFeatureConfig)new CaveBiomeFeatureConfig(Blocks.field_150391_bh.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), 64, 0.075f, OreFeatureConfig.FillerBlockType.field_241882_a, false)).func_227228_a_((ConfiguredPlacement)new ConfiguredPlacement(Placement.field_215039_y, (IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.AIR, 0.4f)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.MUSHROOM_CAVE_CHANCE.get()).intValue())));
        OmniFeatures.Configured.ICY_CAVE = RegistryUtil.createConfiguredFeature("icy_cave", ((Feature)OmniFeatures.ICY_CAVE.get()).func_225566_b_((IFeatureConfig)new CaveBiomeFeatureConfig(((Block)OmniBlocks.ARCTISS_BLOCK.get()).func_176223_P(), Blocks.field_150403_cj.func_176223_P(), Blocks.field_150403_cj.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 48, 0.1f, OreFeatureConfig.FillerBlockType.field_241882_a, true)).func_227228_a_((ConfiguredPlacement)new ConfiguredPlacement(Placement.field_215039_y, (IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.AIR, 0.3f)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.ICY_CAVE_CHANCE.get()).intValue())));
        OmniFeatures.Configured.TERRACOTTA_CAVE = RegistryUtil.createConfiguredFeature("terracotta_cave", ((Feature)OmniFeatures.TERRACOTTA_CAVE.get()).func_225566_b_((IFeatureConfig)new CaveBiomeFeatureConfig(Blocks.field_196611_F.func_176223_P(), Blocks.field_180395_cM.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), Blocks.field_180395_cM.func_176223_P(), 56, 0.075f, OreFeatureConfig.FillerBlockType.field_241882_a, true)).func_227228_a_((ConfiguredPlacement)new ConfiguredPlacement(Placement.field_215039_y, (IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.AIR, 0.4f)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.TERRACOTTA_CAVE_CHANCE.get()).intValue())));
    }

    @Override
    protected void registerSounds() {
        OmniSoundEvents.CRYSTAL_PLACE = RegistryUtil.createSoundEvent("block.crystal.place");
        OmniSoundEvents.CRYSTAL_BREAK = RegistryUtil.createSoundEvent("block.crystal.break");
        OmniSoundEvents.CRYSTAL_STEP = RegistryUtil.createSoundEvent("block.crystal.step");
        OmniSoundEvents.CRYSTAL_SHIMMER = RegistryUtil.createSoundEvent("block.crystal.shimmer");
        OmniSoundEvents.CRYSTAL_BUD_PLACE = RegistryUtil.createSoundEvent("block.crystal_bud.place");
        OmniSoundEvents.CRYSTAL_BUD_BREAK = RegistryUtil.createSoundEvent("block.crystal_bud.break");
        OmniSoundEvents.MUSHROOM_BOUNCE = RegistryUtil.createSoundEvent("block.mushroom.bounce");
    }

    @Override
    protected void registerStats() {
        OmniStats.ARCTISS_DISTURB = RegistryUtil.createStatType("arctiss_disturb", IStatFormatter.field_223218_b_);
        OmniStats.CAVE_MUSHROOM_BOUNCE = RegistryUtil.createStatType("cave_mushroom_bounce", IStatFormatter.field_223218_b_);
    }

    protected void onBiomeLoading(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        ResourceLocation name = event.getName();
        if (category != Biome.Category.NETHER && category != Biome.Category.THEEND && category != Biome.Category.NONE) {
            BiomeFeatures.addStoneSpeleothems(gen);
            BiomeFeatures.addMalachiteGeodes(gen);
        } else {
            for (String s : StringUtils.split((String)((String)CoreModule.Configuration.COMMON.MALACHITE_BIOME_BLACKLIST.get()), (String)",")) {
                if (!s.equals(name.toString())) continue;
                BiomeFeatures.addMalachiteGeodes(gen);
            }
        }
        if (category == Biome.Category.ICY) {
            BiomeFeatures.addIcicles(gen);
            BiomeFeatures.addIcyCaves(gen);
        }
        if (category == Biome.Category.NETHER) {
            BiomeFeatures.addNetherrackSpeleothems(gen);
        }
        if (category == Biome.Category.MUSHROOM) {
            BiomeFeatures.addMushroomCaves(gen);
        }
    }

    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity living = event.getEntityLiving();
        BlockPos pos = new BlockPos(living.func_213303_ch());
        World world = living.func_130014_f_();
        if (world.func_180495_p(pos).func_177230_c() == OmniBlocks.GREEN_CAVE_MUSHROOM.get() && !living.func_226272_bl_()) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof SlimeBlock) {
                living.func_70024_g(0.0, 0.9 * (double)((Integer)CoreModule.Configuration.COMMON.GREEN_CAVE_MUSHROOM_BOUNCE_MODIFIER.get()).intValue(), 0.0);
            } else {
                living.func_70024_g(0.0, 0.6, 0.0);
            }
        }
    }
}

