/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FungusBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import pugz.omni.client.render.FallingConcretePowderRenderer;
import pugz.omni.common.block.AbstractStackableBlock;
import pugz.omni.common.block.colormatic.FlowersBlock;
import pugz.omni.common.block.colormatic.FungiBlock;
import pugz.omni.common.block.colormatic.LayerConcreteBlock;
import pugz.omni.common.block.colormatic.LayerConcretePowderBlock;
import pugz.omni.common.block.colormatic.MushroomsBlock;
import pugz.omni.common.block.colormatic.QuiltedCarpetBlock;
import pugz.omni.common.block.colormatic.QuiltedWoolBlock;
import pugz.omni.common.entity.colormatic.FallingConcretePowderEntity;
import pugz.omni.common.world.biome.FlowerFieldBiome;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniBiomes;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniEntities;
import pugz.omni.core.util.CompatReferences;
import pugz.omni.core.util.RegistryUtil;
import pugz.omni.core.util.TradeUtils;

public class ColormaticModule
extends AbstractModule {
    public static final ColormaticModule instance = new ColormaticModule();
    public static List<Supplier<Block>> CONCRETES = new ArrayList<Supplier<Block>>();
    public static List<Supplier<Block>> CONCRETE_POWDERS = new ArrayList<Supplier<Block>>();
    public static List<Supplier<AbstractStackableBlock>> STACKABLES = new ArrayList<Supplier<AbstractStackableBlock>>();
    public static List<Supplier<Block>> QUILTEDS = new ArrayList<Supplier<Block>>();

    @Override
    protected void sendInitMessage() {
        System.out.println("Discovered the end of the Colormatic Rainbow!");
    }

    public ColormaticModule() {
        super("Colormatic");
    }

    @Override
    public void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onWandererTrades);
        MinecraftForge.EVENT_BUS.addListener(this::onRightClickBlock);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onClientInitialize() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OmniEntities.FALLING_CONCRETE_POWDER.get()), FallingConcretePowderRenderer::new);
    }

    @Override
    protected void onPostInitialize(FMLCommonSetupEvent event) {
    }

    @Override
    protected void registerBlocks() {
        for (DyeColor color : DyeColor.values()) {
            RegistryObject<Block> CONCRETE = RegistryUtil.createBlock(color.name().toLowerCase() + "_concrete", () -> new LayerConcreteBlock(color), null);
            CONCRETES.add((Supplier<Block>)CONCRETE);
            RegistryObject<Block> CONCRETE_POWDER = RegistryUtil.createBlock(color.name().toLowerCase() + "_concrete_powder", () -> new LayerConcretePowderBlock((Block)CONCRETE.get(), color), null);
            CONCRETE_POWDERS.add((Supplier<Block>)CONCRETE_POWDER);
            RegistryObject<Block> QUILTED_CARPET = RegistryUtil.createBlock(color.name().toLowerCase() + "_quilted_carpet", () -> new QuiltedCarpetBlock(color), ItemGroup.field_78031_c);
            RegistryObject<Block> QUILTED_WOOL = RegistryUtil.createBlock(color.name().toLowerCase() + "_quilted_wool", () -> new QuiltedWoolBlock(color), ItemGroup.field_78030_b);
            QUILTEDS.addAll((Collection<Supplier<Block>>)ImmutableSet.of(QUILTED_CARPET, QUILTED_WOOL));
        }
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ConfiguredFeature configuredFeature;
            if (!block.getRegistryName().func_110624_b().equals("minecraft")) continue;
            if (block instanceof FlowerBlock) {
                String name = block.getRegistryName().func_110623_a() + "s";
                if (StringUtils.endsWith((CharSequence)name, (CharSequence)"ss")) {
                    name = StringUtils.removeEnd((String)name, (String)"ss") + "ses";
                }
                RegistryObject<AbstractStackableBlock> FLOWERS = RegistryUtil.createBlock(name, () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block), block), null);
                STACKABLES.add((Supplier<AbstractStackableBlock>)FLOWERS);
                continue;
            }
            if (block instanceof MushroomBlock) {
                String name = block.getRegistryName().func_110623_a() + "s";
                configuredFeature = StringUtils.contains((CharSequence)name, (CharSequence)"red") ? Features.field_243861_bG : Features.field_243860_bF;
                RegistryObject<AbstractStackableBlock> MUSHROOMS = RegistryUtil.createBlock(name, () -> new MushroomsBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block), block, () -> configuredFeature), null);
                STACKABLES.add((Supplier<AbstractStackableBlock>)MUSHROOMS);
                continue;
            }
            if (!(block instanceof FungusBlock)) continue;
            String name = StringUtils.replace((String)block.getRegistryName().func_110623_a(), (String)"us", (String)"i");
            configuredFeature = StringUtils.contains((CharSequence)name, (CharSequence)"crimson") ? Features.field_243857_bC : Features.field_243859_bE;
            RegistryObject<AbstractStackableBlock> FUNGI = RegistryUtil.createBlock(name, () -> new FungiBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block), block, () -> configuredFeature), null);
            STACKABLES.add((Supplier<AbstractStackableBlock>)FUNGI);
        }
        if (ModList.get().isLoaded("quarkno")) {
            OmniBlocks.GLOWSHROOMS = RegistryUtil.createBlock("glowshrooms", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.GLOWSHROOM.get())), (Block)CompatReferences.GLOWSHROOM.get()), null);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.GLOWSHROOMS);
        }
        if (ModList.get().isLoaded("buzzier_beesno")) {
            OmniBlocks.BUTTERCUPS = RegistryUtil.createBlock("buttercups", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.BUTTERCUP.get())), (Block)CompatReferences.BUTTERCUP.get()), null);
            OmniBlocks.PINK_CLOVERS = RegistryUtil.createBlock("pink_clovers", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.PINK_CLOVER.get())), (Block)CompatReferences.PINK_CLOVER.get()), null);
            OmniBlocks.WHITE_CLOVERS = RegistryUtil.createBlock("white_clovers", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.WHITE_CLOVER.get())), (Block)CompatReferences.WHITE_CLOVER.get()), null);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.BUTTERCUPS);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.PINK_CLOVERS);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.WHITE_CLOVERS);
        }
        if (ModList.get().isLoaded("environmentalno")) {
            OmniBlocks.BLUEBELLS = RegistryUtil.createBlock("bluebells", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.BLUEBELL.get())), (Block)CompatReferences.BLUEBELL.get()), null);
            OmniBlocks.CARTWHEELS = RegistryUtil.createBlock("cartwheels", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.CARTWHEEL.get())), (Block)CompatReferences.CARTWHEEL.get()), null);
            OmniBlocks.DIANTHUSES = RegistryUtil.createBlock("dianthuses", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.DIANTHUS.get())), (Block)CompatReferences.DIANTHUS.get()), null);
            OmniBlocks.MAGENTA_HIBISCUSES = RegistryUtil.createBlock("magenta_hibiscuses", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.MAGENTA_HIBISCUS.get())), (Block)CompatReferences.MAGENTA_HIBISCUS.get()), null);
            OmniBlocks.ORANGE_HIBISCUSES = RegistryUtil.createBlock("orange_hibiscuses", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.ORANGE_HIBISCUS.get())), (Block)CompatReferences.ORANGE_HIBISCUS.get()), null);
            OmniBlocks.PINK_HIBISCUSES = RegistryUtil.createBlock("pink_hibiscuses", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.PINK_HIBISCUS.get())), (Block)CompatReferences.PINK_HIBISCUS.get()), null);
            OmniBlocks.PURPLE_HIBISCUSES = RegistryUtil.createBlock("purple_hibiscuses", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.PURPLE_HIBISCUS.get())), (Block)CompatReferences.PURPLE_HIBISCUS.get()), null);
            OmniBlocks.RED_HIBISCUSES = RegistryUtil.createBlock("red_hibiscuses", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.RED_HIBISCUS.get())), (Block)CompatReferences.RED_HIBISCUS.get()), null);
            OmniBlocks.RED_LOTUS_FLOWERS = RegistryUtil.createBlock("red_lotus_flowers", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.RED_LOTUS_FLOWER.get())), (Block)CompatReferences.RED_LOTUS_FLOWER.get()), null);
            OmniBlocks.VIOLETS = RegistryUtil.createBlock("violets", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.VIOLET.get())), (Block)CompatReferences.VIOLET.get()), null);
            OmniBlocks.WHITE_LOTUS_FLOWERS = RegistryUtil.createBlock("white_lotus_flowers", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.WHITE_LOTUS_FLOWER.get())), (Block)CompatReferences.WHITE_LOTUS_FLOWER.get()), null);
            OmniBlocks.YELLOW_HIBISCUSES = RegistryUtil.createBlock("yellow_hibiscuses", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.YELLOW_HIBISCUS.get())), (Block)CompatReferences.YELLOW_HIBISCUS.get()), null);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.BLUEBELLS);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.CARTWHEELS);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.DIANTHUSES);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.MAGENTA_HIBISCUSES);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.ORANGE_HIBISCUSES);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.PINK_HIBISCUSES);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.PURPLE_HIBISCUSES);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.RED_HIBISCUSES);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.RED_LOTUS_FLOWERS);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.VIOLETS);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.WHITE_LOTUS_FLOWERS);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.YELLOW_HIBISCUSES);
        }
        if (ModList.get().isLoaded("atmosphericno")) {
            OmniBlocks.GILIAS = RegistryUtil.createBlock("gilias", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.GILIA.get())), (Block)CompatReferences.GILIA.get()), null);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.GILIAS);
        }
        if (ModList.get().isLoaded("autumnityno")) {
            OmniBlocks.AUTUMN_CROCUSES = RegistryUtil.createBlock("autumn_crocuses", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.AUTUMN_CROCUS.get())), (Block)CompatReferences.AUTUMN_CROCUS.get()), null);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.AUTUMN_CROCUSES);
        }
        if (ModList.get().isLoaded("minibloomno")) {
            OmniBlocks.HONEY_SPROUTS = RegistryUtil.createBlock("honey_sprouts", () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)CompatReferences.HONEY_SPROUT.get())), (Block)CompatReferences.HONEY_SPROUT.get()), null);
            STACKABLES.add((Supplier<AbstractStackableBlock>)OmniBlocks.HONEY_SPROUTS);
        }
        OmniBlocks.TRADERS_QUILTED_CARPET = RegistryUtil.createBlock("traders_quilted_carpet", () -> new QuiltedCarpetBlock(DyeColor.BLUE), ItemGroup.field_78031_c);
        OmniBlocks.TRADERS_QUILTED_WOOL = RegistryUtil.createBlock("traders_quilted_wool", () -> new QuiltedWoolBlock(DyeColor.BLUE), ItemGroup.field_78030_b);
        OmniBlocks.ENCHANTERS_QUILTED_CARPET = RegistryUtil.createBlock("enchanters_quilted_carpet", () -> new QuiltedCarpetBlock(DyeColor.RED), ItemGroup.field_78031_c);
        OmniBlocks.ENCHANTERS_QUILTED_WOOL = RegistryUtil.createBlock("enchanters_quilted_wool", () -> new QuiltedWoolBlock(DyeColor.RED), ItemGroup.field_78030_b);
    }

    @Override
    protected void registerEntities() {
        OmniEntities.FALLING_CONCRETE_POWDER = RegistryUtil.createEntity("falling_concrete_powder", OmniEntities::createFallingBlockEntity);
    }

    @Override
    protected void registerBiomes() {
        OmniBiomes.FLOWER_FIELD = RegistryUtil.createBiome(new FlowerFieldBiome());
    }

    public void onWandererTrades(WandererTradesEvent event) {
        event.getGenericTrades().addAll(ImmutableSet.of((Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.TRADERS_QUILTED_WOOL.get()), (Integer)CoreModule.Configuration.COMMON.TRADERS_WOOL_TRADE_PRICE.get(), 8, 8, 2)));
    }

    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        ItemStack stack = event.getItemStack();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        Direction direction = event.getFace();
        if (((Boolean)CoreModule.Configuration.COMMON.STACK_FLOWERS.get()).booleanValue() && (state.func_177230_c() instanceof FlowerBlock || state.func_177230_c() instanceof MushroomBlock || state.func_177230_c() instanceof FungusBlock)) {
            for (Supplier<AbstractStackableBlock> supplier : STACKABLES) {
                AbstractStackableBlock stackable = supplier.get();
                if (stack.func_77973_b() != state.func_177230_c().func_199767_j() || stackable.getBase() != state.func_177230_c() || player.func_225608_bj_()) continue;
                if (!player.func_184812_l_() && !world.field_72995_K) {
                    stack.func_190918_g(1);
                }
                world.func_180501_a(pos, stackable.getBlock().func_176223_P(), 3);
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
                event.setCanceled(true);
            }
        }
        if (state.func_177230_c() instanceof ConcretePowderBlock && ((Boolean)CoreModule.Configuration.COMMON.LAYER_CONCRETE.get()).booleanValue() && stack.func_77973_b() instanceof ShovelItem && direction == Direction.UP) {
            for (Supplier<AbstractStackableBlock> supplier : CONCRETE_POWDERS) {
                Block block = (Block)supplier.get();
                if (!block.getRegistryName().func_110623_a().equals(state.func_177230_c().getRegistryName().func_110623_a())) continue;
                if (!player.func_184812_l_() && !world.field_72995_K) {
                    stack.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(hand));
                }
                world.func_180501_a(pos, (BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)LayerConcretePowderBlock.LAYERS, (Comparable)Integer.valueOf(7))).func_206870_a((Property)LayerConcretePowderBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a))), 3);
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
            }
        }
    }

    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        FallingBlockEntity fallingBlock;
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (entity instanceof FallingBlockEntity && (fallingBlock = (FallingBlockEntity)entity).func_195054_l().func_177230_c() instanceof ConcretePowderBlock) {
            for (Supplier<Block> supplier : CONCRETE_POWDERS) {
                Block block = supplier.get();
                if (!block.getRegistryName().func_110623_a().equals(fallingBlock.func_195054_l().func_177230_c().getRegistryName().func_110623_a())) continue;
                event.setCanceled(true);
                world.func_217377_a(fallingBlock.func_233580_cy_(), false);
                FallingConcretePowderEntity fallingConcretePowder = new FallingConcretePowderEntity(world, (double)fallingBlock.func_233580_cy_().func_177958_n() + 0.5, fallingBlock.func_233580_cy_().func_177956_o(), (double)fallingBlock.func_233580_cy_().func_177952_p() + 0.5, 8, block.func_176223_P());
                world.func_217376_c((Entity)fallingConcretePowder);
            }
        }
    }
}

