/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.tuple.Pair;
import pugz.omni.client.render.OmniBoatRenderer;
import pugz.omni.client.render.OmniChestTileEntityRenderer;
import pugz.omni.common.tileentity.OmniBeehiveTileEntity;
import pugz.omni.common.tileentity.OmniChestTileEntity;
import pugz.omni.common.tileentity.OmniTrappedChestTileEntity;
import pugz.omni.common.world.feature.ExposedOreFeature;
import pugz.omni.common.world.feature.ExposedOreFeatureConfig;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.module.CavierCavesModule;
import pugz.omni.core.module.ColormaticModule;
import pugz.omni.core.module.ForestryModule;
import pugz.omni.core.module.MiscellaneousModule;
import pugz.omni.core.module.ParadiseModule;
import pugz.omni.core.module.WildWestModule;
import pugz.omni.core.module.WintertimeModule;
import pugz.omni.core.registry.OmniEntities;
import pugz.omni.core.registry.OmniFeatures;
import pugz.omni.core.registry.OmniTileEntities;
import pugz.omni.core.util.RegistryUtil;

public class CoreModule
extends AbstractModule {
    public static final CoreModule instance = new CoreModule();

    public CoreModule() {
        super("Core");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Booted up the Core Module.");
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onClientInitialize() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)OmniTileEntities.CHEST.get()), OmniChestTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)OmniTileEntities.TRAPPED_CHEST.get()), OmniChestTileEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OmniEntities.BOAT.get()), OmniBoatRenderer::new);
    }

    @Override
    protected void onPostInitialize(FMLCommonSetupEvent event) {
    }

    @Override
    protected void registerTileEntities() {
        OmniTileEntities.BEEHIVE = RegistryUtil.createTileEntity("beehive", OmniBeehiveTileEntity::new, () -> OmniTileEntities.collectBlocks(OmniBeehiveTileEntity.class));
        OmniTileEntities.CHEST = RegistryUtil.createTileEntity("chest", OmniChestTileEntity::new, () -> OmniTileEntities.collectBlocks(OmniChestTileEntity.class));
        OmniTileEntities.TRAPPED_CHEST = RegistryUtil.createTileEntity("trapped_chest", OmniTrappedChestTileEntity::new, () -> OmniTileEntities.collectBlocks(OmniTrappedChestTileEntity.class));
    }

    @Override
    protected void registerEntities() {
        OmniEntities.BOAT = RegistryUtil.createEntity("boat", OmniEntities::createBoatEntity);
    }

    @Override
    protected void registerFeatures() {
        OmniFeatures.EXPOSED_ORE = RegistryUtil.createFeature("exposed_ore", () -> new ExposedOreFeature(ExposedOreFeatureConfig.CODEC));
    }

    public static class Configuration {
        public final ForgeConfigSpec.IntValue MALACHITE_GEODE_SPAWN_CHANCE;
        public final ForgeConfigSpec.ConfigValue<String> MALACHITE_BIOME_BLACKLIST;
        public final ForgeConfigSpec.ConfigValue<String> GEODE_SHELL_OUTER_BLOCK;
        public final ForgeConfigSpec.ConfigValue<String> GEODE_SHELL_INNER_BLOCK;
        public final ForgeConfigSpec.IntValue BUDDING_MALACHITE_GROWTH_CHANCE;
        public final ForgeConfigSpec.ConfigValue<Double> SPELEOTHEMS_SPAWN_PROBABILITY;
        public final ForgeConfigSpec.BooleanValue SPELEOTHEMS_FALL;
        public final ForgeConfigSpec.BooleanValue SPELEOTHEMS_FALL_BY_PROJECTILES;
        public final ForgeConfigSpec.BooleanValue SPELEOTHEMS_FILL_CAULDRONS;
        public final ForgeConfigSpec.IntValue MUSHROOM_CAVE_CHANCE;
        public final ForgeConfigSpec.IntValue GREEN_CAVE_MUSHROOM_BOUNCE_MODIFIER;
        public final ForgeConfigSpec.IntValue ICY_CAVE_CHANCE;
        public final ForgeConfigSpec.IntValue ARCTISS_FREEZE_DURATION;
        public final ForgeConfigSpec.BooleanValue ICY_CAVE_ICE_WINDOWS;
        public final ForgeConfigSpec.IntValue TERRACOTTA_CAVE_CHANCE;
        public final ForgeConfigSpec.BooleanValue CONNECTABLE_QUILTED_CARPETS;
        public final ForgeConfigSpec.IntValue TRADERS_WOOL_TRADE_PRICE;
        public final ForgeConfigSpec.BooleanValue STACK_FLOWERS;
        public final ForgeConfigSpec.IntValue FLOWER_FIELD_SPAWN_WEIGHT;
        public final ForgeConfigSpec.BooleanValue LAYER_CONCRETE;
        public final ForgeConfigSpec.BooleanValue CONCRETE_POWDER_FALLS;
        public final ForgeConfigSpec.ConfigValue<Double> GOLDEN_OAK_SPAWN_CHANCE;
        public final ForgeConfigSpec.IntValue TALL_FOREST_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Double> ENCHANTED_GOLDEN_CARROT_SPAWN_CHANCE;
        public final ForgeConfigSpec.BooleanValue ZOMBIE_HORSE_TRANSMUTATION;
        public final ForgeConfigSpec.IntValue SEAHORSE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.IntValue SEAHORSE_TAME_CHANCE;
        public final ForgeConfigSpec.BooleanValue RIDEABLE_SEAHORSES;
        public final ForgeConfigSpec.ConfigValue<String> SEAHORSE_SPAWN_BIOMES;
        public final ForgeConfigSpec.IntValue LARGE_SEAHORSE_SPAWN_CHANCE;
        public final ForgeConfigSpec.IntValue TROPICAL_PLAINS_SPAWN_WEIGHT;
        public final ForgeConfigSpec.IntValue LOTUS_FLOWER_SPAWN_CHANCE;
        public final ForgeConfigSpec.IntValue LOTUS_FLOWER_TRADE_PRICE;
        public final ForgeConfigSpec.IntValue BADLANDS_JUNGLE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.IntValue DESERT_JUNGLE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.IntValue RED_ROCK_GEN_SIZE;
        public final ForgeConfigSpec.IntValue WOODED_BADLANDS_SPAWN_WEIGHT;
        public final ForgeConfigSpec.IntValue WOODED_DESERT_SPAWN_WEIGHT;
        public final ForgeConfigSpec.BooleanValue FANTASTICAL_SAGUAROS;
        public final ForgeConfigSpec.IntValue POLAR_BEAR_JOCKEY_CHANCE;
        public static final ForgeConfigSpec COMMON_SPEC;
        public static final Configuration COMMON;

        public Configuration(ForgeConfigSpec.Builder builder) {
            builder.comment("Omni Configuration");
            builder.push(CavierCavesModule.instance.getName());
            this.MALACHITE_GEODE_SPAWN_CHANCE = builder.defineInRange("malachite_geode_spawn_chance", 48, 0, 1000);
            this.MALACHITE_BIOME_BLACKLIST = builder.define("malachite_biome_blacklist", (Object)"");
            this.GEODE_SHELL_OUTER_BLOCK = builder.define("geode_shell_outer_block", (Object)"minecraft:granite");
            this.GEODE_SHELL_INNER_BLOCK = builder.define("geode_shell_inner_block", (Object)"minecraft:diorite");
            this.BUDDING_MALACHITE_GROWTH_CHANCE = builder.defineInRange("budding_malachite_growth_chance", 5, 0, 1000);
            this.SPELEOTHEMS_SPAWN_PROBABILITY = builder.defineInRange("speleothems_spawn_probability", 0.04, 0.0, 1.0);
            this.SPELEOTHEMS_FALL = builder.define("speleothems_fall", true);
            this.SPELEOTHEMS_FALL_BY_PROJECTILES = builder.define("speleothems_fall_by_projectiles", true);
            this.SPELEOTHEMS_FILL_CAULDRONS = builder.define("speleothems_fill_cauldrons", true);
            this.MUSHROOM_CAVE_CHANCE = builder.defineInRange("mushroom_cave_chance", 15, 0, 1000);
            this.GREEN_CAVE_MUSHROOM_BOUNCE_MODIFIER = builder.defineInRange("green_cave_mushroom_bounce_modifier", 1, 0, 1000);
            this.ICY_CAVE_CHANCE = builder.defineInRange("icy_cave_chance", 18, 0, 1000);
            this.ARCTISS_FREEZE_DURATION = builder.defineInRange("arctiss_freeze_duration", 120, 0, 9600);
            this.ICY_CAVE_ICE_WINDOWS = builder.define("icy_cave_ice_windows", true);
            this.TERRACOTTA_CAVE_CHANCE = builder.defineInRange("terracotta_cave_chance", 18, 0, 1000);
            builder.pop();
            builder.push(ColormaticModule.instance.getName());
            this.CONNECTABLE_QUILTED_CARPETS = builder.define("connectable_quilted_carpets", true);
            this.TRADERS_WOOL_TRADE_PRICE = builder.defineInRange("traders_wool_trade_price", 1, 0, 64);
            this.STACK_FLOWERS = builder.define("stack_flowers", true);
            this.FLOWER_FIELD_SPAWN_WEIGHT = builder.defineInRange("flower_field_spawn_weight", 3, 0, 100);
            this.LAYER_CONCRETE = builder.define("layer_concrete", true);
            this.CONCRETE_POWDER_FALLS = builder.define("concrete_powder_falls", true);
            builder.pop();
            builder.push(ForestryModule.instance.getName());
            this.GOLDEN_OAK_SPAWN_CHANCE = builder.defineInRange("golden_oak_spawn_chance", 0.005, 0.0, 1.0);
            this.TALL_FOREST_SPAWN_WEIGHT = builder.defineInRange("tall_forest_spawn_weight", 3, 0, 100);
            builder.pop();
            builder.push(MiscellaneousModule.instance.getName());
            this.ENCHANTED_GOLDEN_CARROT_SPAWN_CHANCE = builder.defineInRange("enchanted_golden_carrot_spawn_chance", 0.03, 0.0, 1.0);
            this.ZOMBIE_HORSE_TRANSMUTATION = builder.define("zombie_horse_transmutation", true);
            builder.pop();
            builder.push(ParadiseModule.instance.getName());
            this.SEAHORSE_SPAWN_WEIGHT = builder.defineInRange("seahorse_spawn_weight", 8, 0, 1000);
            this.SEAHORSE_TAME_CHANCE = builder.defineInRange("seahorse_tame_chance", 5, 0, 1000);
            this.RIDEABLE_SEAHORSES = builder.define("rideable_seahorses", true);
            this.SEAHORSE_SPAWN_BIOMES = builder.define("seahorse_spawn_biomes", (Object)"minecraft:warm_ocean,minecraft:deep_warm_ocean");
            this.LARGE_SEAHORSE_SPAWN_CHANCE = builder.defineInRange("large_seahorse_spawn_chance", 25, 0, 1000);
            this.TROPICAL_PLAINS_SPAWN_WEIGHT = builder.defineInRange("tropical_plains_spawn_weight", 2, 0, 100);
            this.LOTUS_FLOWER_SPAWN_CHANCE = builder.defineInRange("lotus_flower_spawn_chance", 8, 0, 1000);
            this.LOTUS_FLOWER_TRADE_PRICE = builder.defineInRange("lotus_flower_trade_price", 1, 0, 64);
            this.BADLANDS_JUNGLE_SPAWN_WEIGHT = builder.defineInRange("badlands_jungle_spawn_weight", 2, 0, 100);
            this.DESERT_JUNGLE_SPAWN_WEIGHT = builder.defineInRange("desert_jungle_spawn_weight", 2, 0, 100);
            builder.pop();
            builder.push(WildWestModule.instance.getName());
            this.RED_ROCK_GEN_SIZE = builder.defineInRange("red_rock_gen_size", 36, 0, 128);
            this.WOODED_BADLANDS_SPAWN_WEIGHT = builder.defineInRange("wooded_badlands_spawn_weight", 2, 0, 100);
            this.WOODED_DESERT_SPAWN_WEIGHT = builder.defineInRange("wooded_desert_spawn_weight", 3, 0, 100);
            this.FANTASTICAL_SAGUAROS = builder.define("fantastical_saguaros", true);
            builder.pop();
            builder.push(WintertimeModule.instance.getName());
            this.POLAR_BEAR_JOCKEY_CHANCE = builder.defineInRange("polar_bear_jockey_chance", 40, 0, 1000);
            builder.pop();
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Configuration::new);
            COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
            COMMON = (Configuration)specPair.getLeft();
        }
    }
}

