/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import pugz.omni.common.block.OmniLeavesBlock;
import pugz.omni.common.block.forestry.CarvedLogBlock;
import pugz.omni.common.world.biome.TallForestBiome;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniBiomes;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniFeatures;
import pugz.omni.core.util.BiomeFeatures;
import pugz.omni.core.util.RegistryUtil;

public class ForestryModule
extends AbstractModule {
    public static final ForestryModule instance = new ForestryModule();

    public ForestryModule() {
        super("Forestry");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Relaxing within all the Forestry.");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onClientInitialize() {
    }

    @Override
    protected void onPostInitialize(FMLCommonSetupEvent event) {
    }

    @Override
    protected void registerBlocks() {
        OmniBlocks.CARVED_DARK_OAK_WOOD = RegistryUtil.createBlock("carved_dark_oak_wood", () -> new CarvedLogBlock(MaterialColor.field_151676_q), ItemGroup.field_78030_b);
        OmniBlocks.CARVED_ACACIA_WOOD = RegistryUtil.createBlock("carved_acacia_wood", () -> new CarvedLogBlock(MaterialColor.field_151650_B), ItemGroup.field_78030_b);
        OmniBlocks.CARVED_JUNGLE_WOOD = RegistryUtil.createBlock("carved_jungle_wood", () -> new CarvedLogBlock(MaterialColor.field_151664_l), ItemGroup.field_78030_b);
        OmniBlocks.CARVED_BIRCH_WOOD = RegistryUtil.createBlock("carved_birch_wood", () -> new CarvedLogBlock(MaterialColor.field_151658_d), ItemGroup.field_78030_b);
        OmniBlocks.CARVED_SPRUCE_WOOD = RegistryUtil.createBlock("carved_spruce_wood", () -> new CarvedLogBlock(MaterialColor.field_151654_J), ItemGroup.field_78030_b);
        OmniBlocks.CARVED_OAK_WOOD = RegistryUtil.createBlock("carved_oak_wood", () -> new CarvedLogBlock(MaterialColor.field_151663_o), ItemGroup.field_78030_b);
        OmniBlocks.GOLDEN_OAK_LEAVES = RegistryUtil.createBlock("golden_oak_leaves", OmniLeavesBlock::new, ItemGroup.field_78031_c);
    }

    @Override
    protected void registerBiomes() {
        OmniBiomes.TALL_FOREST = RegistryUtil.createBiome(new TallForestBiome());
    }

    @Override
    protected void registerConfiguredFeatures() {
        OmniFeatures.Configured.TALL_OAK_TREE = RegistryUtil.createConfiguredFeature("oak_tall", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 4), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243990_a)).func_225568_b_()).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        OmniFeatures.Configured.TALL_OAK_TREES = RegistryUtil.createConfiguredFeature("dense_savanna_trees", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)OmniFeatures.Configured.TALL_OAK_TREE.func_227227_a_(0.8f), (Object)Features.field_243940_cw.func_227227_a_(0.25f)), Features.field_243922_ce)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(12, 0.1f, 1))));
        OmniFeatures.Configured.GOLDEN_APPLE_TREE = RegistryUtil.createConfiguredFeature("golden_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.GOLDEN_OAK_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_())).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, ((Double)CoreModule.Configuration.COMMON.GOLDEN_OAK_SPAWN_CHANCE.get()).floatValue(), 1)));
    }

    protected void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        if (event.getCategory() == Biome.Category.FOREST) {
            BiomeFeatures.addGoldenOakTrees(gen);
            if (event.getName().func_110623_a().equals(OmniBiomes.TALL_FOREST.getRegistryName().func_110623_a())) {
                BiomeFeatures.addTallOakTrees(gen);
            }
        }
    }
}

