/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import pugz.omni.common.block.miscellaneous.VexedGlassBlock;
import pugz.omni.common.item.forestry.EnchantedGoldenCarrotItem;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniItems;
import pugz.omni.core.util.RegistryUtil;

public class MiscellaneousModule
extends AbstractModule {
    public static final MiscellaneousModule instance = new MiscellaneousModule();

    public MiscellaneousModule() {
        super("Miscellaneous");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Miscellaneous, random stuff initialized!");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onLootTableLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityStruckByLightning);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteractSpecific);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onClientInitialize() {
    }

    @Override
    protected void onPostInitialize(FMLCommonSetupEvent event) {
    }

    @Override
    protected void registerBlocks() {
        OmniBlocks.VEXED_GLASS = RegistryUtil.createBlock("vexed_glass", VexedGlassBlock::new, ItemGroup.field_78028_d);
    }

    @Override
    protected void registerItems() {
        OmniItems.ENCHANTED_GOLDEN_CARROT = RegistryUtil.createItem("enchanted_golden_carrot", EnchantedGoldenCarrotItem::new);
    }

    public void onLootTableLoad(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        ResourceLocation name = event.getName();
        if (name.toString().equals(LootTables.field_186424_f.toString()) || name.toString().equals(LootTables.field_186422_d.toString()) || name.toString().equals(LootTables.field_237380_L_.toString()) || name.toString().equals(LootTables.field_186429_k.toString()) || name.toString().equals(LootTables.field_237384_P_.toString()) || name.toString().equals(LootTables.field_191192_o.toString())) {
            float chance = ((Double)CoreModule.Configuration.COMMON.ENCHANTED_GOLDEN_CARROT_SPAWN_CHANCE.get()).floatValue();
            if (name.toString().equals(LootTables.field_237380_L_.toString())) {
                chance = (float)((double)chance * 3.0);
            }
            LootPool pool = new LootPool.Builder().name("egc_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("omni", "injects/enchanted_golden_carrot"))).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216044_b();
            table.addPool(pool);
        }
    }

    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        if (((Boolean)CoreModule.Configuration.COMMON.ZOMBIE_HORSE_TRANSMUTATION.get()).booleanValue()) {
            LightningBoltEntity lightning = event.getLightning();
            Entity entity = event.getEntity();
            World world = lightning.func_130014_f_();
            if (entity instanceof HorseEntity) {
                List list = world.func_175674_a((Entity)lightning, new AxisAlignedBB(lightning.func_226277_ct_() - 3.0, lightning.func_226278_cu_() - 3.0, lightning.func_226281_cx_() - 3.0, lightning.func_226277_ct_() + 3.0, lightning.func_226278_cu_() + 6.0 + 3.0, lightning.func_226281_cx_() + 3.0), Entity::func_70089_S);
                for (Entity target : list) {
                    if (!(target instanceof ZombieEntity)) continue;
                    lightning.func_233623_a_(true);
                    MiscellaneousModule.transmutateZombieHorse(world, (ZombieEntity)target, (HorseEntity)entity);
                    break;
                }
            }
        }
    }

    private static void transmutateZombieHorse(World world, ZombieEntity zombie, HorseEntity horse) {
        if (horse.func_145818_k_() || horse.func_110248_bS()) {
            return;
        }
        if (!world.field_72995_K) {
            zombie.func_70106_y();
            horse.func_70106_y();
            Entity entity = EntityType.field_200726_aE.func_220331_a((ServerWorld)world, null, null, horse.func_233580_cy_(), SpawnReason.CONVERSION, false, false);
            if (entity instanceof ZombieHorseEntity) {
                ZombieHorseEntity zombieHorse = (ZombieHorseEntity)entity;
                if (horse.func_70631_g_()) {
                    zombieHorse.func_82227_f(true);
                }
                if (!horse.field_110296_bG.func_233543_f_().isEmpty()) {
                    zombieHorse.field_110296_bG = horse.field_110296_bG;
                }
                zombieHorse.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, 0.0f);
                zombieHorse.func_213386_a((IServerWorld)((ServerWorld)world), new DifficultyInstance(world.func_175659_aa(), world.func_82737_E(), world.func_175726_f(entity.func_233580_cy_()).func_177416_w(), world.func_242413_ae()), SpawnReason.CONVERSION, null, null);
            }
        }
    }

    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        PlayerEntity player = event.getPlayer();
        if (entity instanceof ZombieHorseEntity && !event.getWorld().field_72995_K) {
            ZombieHorseEntity zombieHorse = (ZombieHorseEntity)entity;
            player.field_70177_z = zombieHorse.field_70177_z;
            player.field_70125_A = zombieHorse.field_70125_A;
            player.func_184220_m((Entity)zombieHorse);
        }
    }

    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof VexEntity) {
            BlockPos pos = living.func_233580_cy_();
            World world = living.func_130014_f_();
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150359_w) {
                world.func_180501_a(pos, ((Block)OmniBlocks.VEXED_GLASS.get()).func_176223_P(), 3);
            }
        }
    }
}

