/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.StringUtils;
import pugz.omni.client.render.SeahorseRenderer;
import pugz.omni.common.block.paradise.LotusFlowerBlock;
import pugz.omni.common.entity.paradise.SeahorseEntity;
import pugz.omni.common.item.OmniSpawnEggItem;
import pugz.omni.common.item.paradise.SeahorseBucketItem;
import pugz.omni.common.world.biome.BadlandsJungleBiome;
import pugz.omni.common.world.biome.DesertJungleBiome;
import pugz.omni.common.world.biome.TropicalPlainsBiome;
import pugz.omni.common.world.feature.SizedBlockBlobConfig;
import pugz.omni.common.world.feature.SizedBlockBlobFeature;
import pugz.omni.common.world.surface.LushBadlandsSurfaceBuilder;
import pugz.omni.common.world.surface.LushDesertSurfaceBuilder;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniBiomes;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniEntities;
import pugz.omni.core.registry.OmniFeatures;
import pugz.omni.core.registry.OmniItems;
import pugz.omni.core.registry.OmniSurfaceBuilders;
import pugz.omni.core.util.BiomeFeatures;
import pugz.omni.core.util.RegistryUtil;
import pugz.omni.core.util.TradeUtils;

public class ParadiseModule
extends AbstractModule {
    public static final ParadiseModule instance = new ParadiseModule();

    public ParadiseModule() {
        super("Paradise");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Ah, yes. Vibing in Paradise...");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onWandererTrades);
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onClientInitialize() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OmniEntities.SEAHORSE.get()), SeahorseRenderer::new);
        MinecraftForge.EVENT_BUS.addListener(this::onItemColorHandler);
    }

    @Override
    protected void onPostInitialize(FMLCommonSetupEvent event) {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)OmniEntities.SEAHORSE.get()), (AttributeModifierMap)SeahorseEntity.registerAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)OmniEntities.SEAHORSE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SeahorseEntity::canSeahorseSpawn);
    }

    @Override
    protected void registerBlocks() {
        OmniBlocks.RED_LOTUS_FLOWER = RegistryUtil.createBlock("red_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.YELLOW_LOTUS_FLOWER = RegistryUtil.createBlock("yellow_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.ORANGE_LOTUS_FLOWER = RegistryUtil.createBlock("orange_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.BLUE_LOTUS_FLOWER = RegistryUtil.createBlock("blue_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.PINK_LOTUS_FLOWER = RegistryUtil.createBlock("pink_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.PURPLE_LOTUS_FLOWER = RegistryUtil.createBlock("purple_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.BLACK_LOTUS_FLOWER = RegistryUtil.createBlock("black_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76440_q, 8), ItemGroup.field_78031_c);
        OmniBlocks.WHITE_LOTUS_FLOWER = RegistryUtil.createBlock("white_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76439_r, 8), ItemGroup.field_78031_c);
    }

    @Override
    protected void registerItems() {
        OmniItems.SEAHORSE_SPAWN_EGG = RegistryUtil.createItem("seahorse_spawn_egg", () -> new OmniSpawnEggItem(() -> (EntityType)OmniEntities.SEAHORSE.get(), 3966437, 14827318, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        OmniItems.SEAHORSE_BUCKET = RegistryUtil.createItem("seahorse_bucket", SeahorseBucketItem::new);
    }

    @Override
    protected void registerEntities() {
        OmniEntities.SEAHORSE = RegistryUtil.createEntity("seahorse", () -> OmniEntities.createLivingEntity(SeahorseEntity::new, EntityClassification.CREATURE, "seahorse", 0.3f, 0.85f));
    }

    @Override
    protected void registerBiomes() {
        OmniBiomes.TROPICAL_PLAINS = RegistryUtil.createBiome(new TropicalPlainsBiome());
        OmniBiomes.JUNGLE_BADLANDS = RegistryUtil.createBiome(new BadlandsJungleBiome());
        OmniBiomes.JUNGLE_DESERT = RegistryUtil.createBiome(new DesertJungleBiome());
    }

    @Override
    protected void registerSurfaceBuilders() {
        OmniSurfaceBuilders.JUNGLE_BADLANDS = RegistryUtil.createSurfaceBuilder("badlands_jungle", () -> new LushBadlandsSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_));
        OmniSurfaceBuilders.JUNGLE_DESERT = RegistryUtil.createSurfaceBuilder("desert_jungle", () -> new LushDesertSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_));
    }

    @Override
    protected void registerFeatures() {
        OmniFeatures.SIZED_BLOCK_BLOB = RegistryUtil.createFeature("sized_block_blob", () -> new SizedBlockBlobFeature(SizedBlockBlobConfig.CODEC));
    }

    @Override
    protected void registerConfiguredFeatures() {
        OmniFeatures.Configured.RED_LOTUS_FLOWER = RegistryUtil.createConfiguredFeature("red_lotus_flower", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.RED_LOTUS_FLOWER.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(6).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l)).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_SPAWN_CHANCE.get()).intValue()));
        OmniFeatures.Configured.ORANGE_LOTUS_FLOWER = RegistryUtil.createConfiguredFeature("orange_lotus_flower", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.ORANGE_LOTUS_FLOWER.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(6).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l)).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_SPAWN_CHANCE.get()).intValue()));
        OmniFeatures.Configured.YELLOW_LOTUS_FLOWER = RegistryUtil.createConfiguredFeature("yellow_lotus_flower", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.YELLOW_LOTUS_FLOWER.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(6).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l)).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_SPAWN_CHANCE.get()).intValue()));
        OmniFeatures.Configured.BLUE_LOTUS_FLOWER = RegistryUtil.createConfiguredFeature("blue_lotus_flower", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.BLUE_LOTUS_FLOWER.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(6).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l)).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_SPAWN_CHANCE.get()).intValue()));
        OmniFeatures.Configured.PINK_LOTUS_FLOWER = RegistryUtil.createConfiguredFeature("pink_lotus_flower", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.PINK_LOTUS_FLOWER.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(6).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l)).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_SPAWN_CHANCE.get()).intValue()));
        OmniFeatures.Configured.PURPLE_LOTUS_FLOWER = RegistryUtil.createConfiguredFeature("purple_lotus_flower", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.PURPLE_LOTUS_FLOWER.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(6).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l)).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(((Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_SPAWN_CHANCE.get()).intValue()));
        OmniFeatures.Configured.BLACK_LOTUS_FLOWER = RegistryUtil.createConfiguredFeature("black_lotus_flower", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.BLACK_LOTUS_FLOWER.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(3).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l)).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(Math.round((float)((Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_SPAWN_CHANCE.get()).intValue() * 1.5f)));
        OmniFeatures.Configured.WHITE_LOTUS_FLOWER = RegistryUtil.createConfiguredFeature("white_lotus_flower", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.WHITE_LOTUS_FLOWER.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(3).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l)).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(Math.round((float)((Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_SPAWN_CHANCE.get()).intValue() * 1.5f)));
        OmniFeatures.Configured.TERRACOTTA_ROCK = RegistryUtil.createConfiguredFeature("terracotta_rock", (ConfiguredFeature)((ConfiguredFeature)((Feature)OmniFeatures.SIZED_BLOCK_BLOB.get()).func_225566_b_((IFeatureConfig)new SizedBlockBlobConfig(Blocks.field_150405_ch.func_176223_P(), 1)).func_227228_a_(Features.Placements.field_244001_l).func_242729_a(2)).func_242732_c(2));
    }

    @Override
    protected void registerParticles() {
    }

    public void onWandererTrades(WandererTradesEvent event) {
        event.getGenericTrades().addAll(ImmutableSet.of((Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.RED_LOTUS_FLOWER.get()), (Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_TRADE_PRICE.get(), 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.BLUE_LOTUS_FLOWER.get()), (Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_TRADE_PRICE.get(), 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.PINK_LOTUS_FLOWER.get()), (Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_TRADE_PRICE.get(), 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.BLACK_LOTUS_FLOWER.get()), (Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_TRADE_PRICE.get(), 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.WHITE_LOTUS_FLOWER.get()), (Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_TRADE_PRICE.get(), 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.PURPLE_LOTUS_FLOWER.get()), (Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_TRADE_PRICE.get(), 1, 12, 1), (Object[])new TradeUtils.ItemsForEmeraldsTrade[]{new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.ORANGE_LOTUS_FLOWER.get()), (Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_TRADE_PRICE.get(), 1, 12, 1), new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.YELLOW_LOTUS_FLOWER.get()), (Integer)CoreModule.Configuration.COMMON.LOTUS_FLOWER_TRADE_PRICE.get(), 1, 12, 1)}));
    }

    protected void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        ResourceLocation name = event.getName();
        if (event.getCategory() == Biome.Category.JUNGLE) {
            BiomeFeatures.addLotuses(gen);
        }
        if (name != null) {
            if (StringUtils.contains((CharSequence)name.func_110623_a(), (CharSequence)"warm_ocean")) {
                event.getSpawns().func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)OmniEntities.SEAHORSE.get(), ((Integer)CoreModule.Configuration.COMMON.SEAHORSE_SPAWN_WEIGHT.get()).intValue(), 2, 3));
            } else {
                for (String s : StringUtils.split((String)((String)CoreModule.Configuration.COMMON.SEAHORSE_SPAWN_BIOMES.get()), (String)",")) {
                    if (!s.equals(name.toString())) continue;
                    event.getSpawns().func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)OmniEntities.SEAHORSE.get(), ((Integer)CoreModule.Configuration.COMMON.SEAHORSE_SPAWN_WEIGHT.get()).intValue(), 2, 3));
                }
            }
            if (name.func_110623_a().equals(OmniBiomes.JUNGLE_BADLANDS.getRegistryName().func_110623_a())) {
                gen.func_242517_a(OmniSurfaceBuilders.Configured.JUNGLE_BADLANDS);
                BiomeFeatures.addTerracottaRocks(gen);
            }
            if (name.func_110623_a().equals(OmniBiomes.JUNGLE_DESERT.getRegistryName().func_110623_a())) {
                gen.func_242517_a(OmniSurfaceBuilders.Configured.JUNGLE_DESERT);
            }
        }
    }

    public void onItemColorHandler(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, tintIndex) -> ((OmniSpawnEggItem)OmniItems.SEAHORSE_SPAWN_EGG.get()).func_195983_a(tintIndex), new IItemProvider[]{(IItemProvider)OmniItems.SEAHORSE_SPAWN_EGG.get()});
    }
}

