/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BushFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.StringUtils;
import pugz.omni.common.block.OmniBeehiveBlock;
import pugz.omni.common.block.OmniChestBlock;
import pugz.omni.common.block.OmniLeavesBlock;
import pugz.omni.common.block.OmniLogBlock;
import pugz.omni.common.block.OmniSaplingBlock;
import pugz.omni.common.block.OmniStandingSignBlock;
import pugz.omni.common.block.OmniTrappedChestBlock;
import pugz.omni.common.block.OmniWallSignBlock;
import pugz.omni.common.block.VerticalSlabBlock;
import pugz.omni.common.block.wild_west.CactusBloomBlock;
import pugz.omni.common.block.wild_west.RedRockBrickButton;
import pugz.omni.common.block.wild_west.RedRockBrickPressurePlate;
import pugz.omni.common.block.wild_west.SaguaroCactusBlock;
import pugz.omni.common.item.OmniBoatItem;
import pugz.omni.common.item.OmniSignItem;
import pugz.omni.common.world.biome.WoodedBadlandsBiome;
import pugz.omni.common.world.biome.WoodedDesertBiome;
import pugz.omni.common.world.feature.ExposedOreFeatureConfig;
import pugz.omni.common.world.feature.wild_west.SaguaroCactusFeature;
import pugz.omni.common.world.feature.wild_west.placers.PaloVerdeTrunkPlacer;
import pugz.omni.common.world.feature.wild_west.tree.PaloVerdeTree;
import pugz.omni.common.world.surface.WoodedBadlandsSurfaceBuilder;
import pugz.omni.common.world.surface.WoodedDesertSurfaceBuilder;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.module.CoreModule;
import pugz.omni.core.registry.OmniBiomes;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniFeatures;
import pugz.omni.core.registry.OmniItems;
import pugz.omni.core.registry.OmniSurfaceBuilders;
import pugz.omni.core.util.BiomeFeatures;
import pugz.omni.core.util.RegistryUtil;

public class WildWestModule
extends AbstractModule {
    public static final WildWestModule instance = new WildWestModule();

    public WildWestModule() {
        super("Wild West");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Saguaros and tumbleweeds coming soon woahh");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void onClientInitialize() {
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.PALO_VERDE_DOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.PALO_VERDE_TRAPDOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.PALO_VERDE_LADDER.get()), (RenderType)RenderType.func_228643_e_());
        RegistryUtil.sprites.add(new RenderMaterial(Atlases.field_228746_e_, new ResourceLocation("omni", "entity/sign/palo_verde")));
    }

    @Override
    protected void onPostInitialize(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TileEntityType.field_200978_i.field_223046_I.add(OmniBlocks.PALO_VERDE_SIGN.get());
            TileEntityType.field_200978_i.field_223046_I.add(OmniBlocks.PALO_VERDE_WALL_SIGN.get());
        });
    }

    @Override
    protected void registerBlocks() {
        OmniBlocks.RED_ROCK = RegistryUtil.createBlock("red_rock", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150322_A)), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_STAIRS = RegistryUtil.createBlock("red_rock_stairs", () -> new StairsBlock(() -> ((Block)OmniBlocks.RED_ROCK.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150347_e)), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_SLAB = RegistryUtil.createBlock("red_rock_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_WALL = RegistryUtil.createBlock("red_rock_wall", () -> new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78031_c);
        OmniBlocks.RED_ROCK_BRICKS = RegistryUtil.createBlock("red_rock_bricks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_STAIRS = RegistryUtil.createBlock("red_rock_brick_stairs", () -> new StairsBlock(() -> ((Block)OmniBlocks.RED_ROCK_BRICKS.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196696_di)), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_SLAB = RegistryUtil.createBlock("red_rock_brick_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_WALL = RegistryUtil.createBlock("red_rock_brick_wall", () -> new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78031_c);
        OmniBlocks.CHISELED_RED_ROCK_BRICKS = RegistryUtil.createBlock("chiseled_red_rock_bricks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.CRACKED_RED_ROCK_BRICKS = RegistryUtil.createBlock("cracked_red_rock_bricks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_PILLAR = RegistryUtil.createBlock("red_rock_pillar", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_BUTTON = RegistryUtil.createBlock("red_rock_brick_button", RedRockBrickButton::new, ItemGroup.field_78028_d);
        OmniBlocks.RED_ROCK_BRICK_PRESSURE_PLATE = RegistryUtil.createBlock("red_rock_brick_pressure_plate", RedRockBrickPressurePlate::new, ItemGroup.field_78028_d);
        OmniBlocks.RED_ROCK_VERTICAL_SLAB = RegistryUtil.createBlock("red_rock_vertical_slab", () -> new VerticalSlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_VERTICAL_SLAB = RegistryUtil.createBlock("red_rock_brick_vertical_slab", () -> new VerticalSlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_PAVEMENT = RegistryUtil.createBlock("red_rock_pavement", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.SAGUARO_CACTUS = RegistryUtil.createBlock("saguaro_cactus", SaguaroCactusBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.CACTUS_BLOOM = RegistryUtil.createBlock("cactus_bloom", CactusBloomBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.STRIPPED_PALO_VERDE_LOG = RegistryUtil.createBlock("stripped_palo_verde_log", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193574_Z).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)), ItemGroup.field_78030_b);
        OmniBlocks.PALO_VERDE_LOG = RegistryUtil.createBlock("palo_verde_log", () -> new OmniLogBlock((RotatedPillarBlock)OmniBlocks.STRIPPED_PALO_VERDE_LOG.get()), ItemGroup.field_78030_b);
        OmniBlocks.STRIPPED_PALO_VERDE_WOOD = RegistryUtil.createBlock("stripped_palo_verde_wood", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193566_R).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)), ItemGroup.field_78030_b);
        OmniBlocks.PALO_VERDE_WOOD = RegistryUtil.createBlock("palo_verde_wood", () -> new OmniLogBlock((RotatedPillarBlock)OmniBlocks.STRIPPED_PALO_VERDE_WOOD.get()), ItemGroup.field_78030_b);
        OmniBlocks.PALO_VERDE_PLANKS = RegistryUtil.createBlock("palo_verde_planks", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193574_Z).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)), ItemGroup.field_78030_b);
        OmniBlocks.PALO_VERDE_STAIRS = RegistryUtil.createBlock("palo_verde_stairs", () -> new StairsBlock(() -> ((Block)OmniBlocks.PALO_VERDE_PLANKS.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.PALO_VERDE_PLANKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.PALO_VERDE_SLAB = RegistryUtil.createBlock("palo_verde_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.PALO_VERDE_PLANKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.PALO_VERDE_FENCE = RegistryUtil.createBlock("palo_verde_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.PALO_VERDE_PLANKS.get()))), ItemGroup.field_78031_c);
        OmniBlocks.PALO_VERDE_FENCE_GATE = RegistryUtil.createBlock("palo_verde_fence_gate", () -> new FenceGateBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.PALO_VERDE_PLANKS.get()))), ItemGroup.field_78028_d);
        OmniBlocks.PALO_VERDE_DOOR = RegistryUtil.createDoor("palo_verde_door", () -> new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)((Block)OmniBlocks.PALO_VERDE_PLANKS.get()).func_235697_s_()).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()), ItemGroup.field_78028_d);
        OmniBlocks.PALO_VERDE_TRAPDOOR = RegistryUtil.createBlock("palo_verde_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193574_Z).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_((state, reader, pos, entity) -> false)), ItemGroup.field_78028_d);
        OmniBlocks.PALO_VERDE_BUTTON = RegistryUtil.createBlock("palo_verde_button", () -> new WoodButtonBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196689_eF)), ItemGroup.field_78028_d);
        OmniBlocks.PALO_VERDE_PRESSURE_PLATE = RegistryUtil.createBlock("palo_verde_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196663_cq)), ItemGroup.field_78028_d);
        OmniBlocks.PALO_VERDE_BOOKSHELF = RegistryUtil.createBlock("palo_verde_bookshelf", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193574_Z).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)), ItemGroup.field_78030_b);
        OmniBlocks.PALO_VERDE_CHEST = RegistryUtil.createBlock("palo_verde_chest", () -> new OmniChestBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150486_ae), "palo_verde"), ItemGroup.field_78031_c);
        OmniBlocks.PALO_VERDE_TRAPPED_CHEST = RegistryUtil.createBlock("palo_verde_trapped_chest", () -> new OmniTrappedChestBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150447_bR), "palo_verde"), ItemGroup.field_78028_d);
        OmniBlocks.PALO_VERDE_LEAVES = RegistryUtil.createBlock("palo_verde_leaves", OmniLeavesBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.PALO_VERDE_SAPLING = RegistryUtil.createBlock("palo_verde_sapling", () -> new OmniSaplingBlock(new PaloVerdeTree()), ItemGroup.field_78031_c);
        OmniBlocks.PALO_VERDE_SIGN = RegistryUtil.createBlock("palo_verde_sign", () -> new OmniStandingSignBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222384_bX), "palo_verde"));
        OmniBlocks.PALO_VERDE_WALL_SIGN = RegistryUtil.createBlock("palo_verde_wall_sign", () -> new OmniWallSignBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222392_ch).func_222379_b((Block)OmniBlocks.PALO_VERDE_SIGN.get()), "palo_verde"));
        OmniBlocks.PALO_VERDE_LADDER = RegistryUtil.createBlock("palo_verde_ladder", () -> new LadderBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150468_ap)), ItemGroup.field_78031_c);
        OmniBlocks.PALO_VERDE_BEEHIVE = RegistryUtil.createBlock("palo_verde_beehive", OmniBeehiveBlock::new, ItemGroup.field_78031_c);
        OmniBlocks.VERTICAL_PALO_VERDE_PLANKS = RegistryUtil.createBlock("vertical_palo_verde_planks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.PALO_VERDE_PLANKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.PALO_VERDE_VERTICAL_SLAB = RegistryUtil.createBlock("palo_verde_vertical_slab", () -> new VerticalSlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.PALO_VERDE_PLANKS.get()))), ItemGroup.field_78030_b);
    }

    @Override
    protected void registerItems() {
        OmniItems.PALO_VERDE_BOAT = RegistryUtil.createItem("palo_verde_boat", () -> new OmniBoatItem(new Item.Properties().func_200916_a(ItemGroup.field_78029_e).func_200917_a(1), "palo_verde"));
        OmniItems.PALO_VERDE_SIGN = RegistryUtil.createItem("palo_verde_sign", () -> new OmniSignItem(new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_200917_a(16), (Block)OmniBlocks.PALO_VERDE_SIGN.get(), (Block)OmniBlocks.PALO_VERDE_WALL_SIGN.get()));
    }

    @Override
    protected void registerBiomes() {
        OmniBiomes.WOODED_BADLANDS = RegistryUtil.createBiome(new WoodedBadlandsBiome());
        OmniBiomes.WOODED_DESERT = RegistryUtil.createBiome(new WoodedDesertBiome());
    }

    @Override
    protected void registerSurfaceBuilders() {
        OmniSurfaceBuilders.WOODED_BADLANDS = RegistryUtil.createSurfaceBuilder("wooded_badlands", () -> new WoodedBadlandsSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_));
        OmniSurfaceBuilders.WOODED_DESERT = RegistryUtil.createSurfaceBuilder("wooded_desert", () -> new WoodedDesertSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_));
    }

    @Override
    protected void registerFeatures() {
        OmniFeatures.SAGUARO_CACTUS = RegistryUtil.createFeature("saguaro_cactus", () -> new SaguaroCactusFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    }

    @Override
    protected void registerConfiguredFeatures() {
        OmniFeatures.Configured.RED_ROCK = RegistryUtil.createConfiguredFeature("red_rock", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)OmniFeatures.EXPOSED_ORE.get()).func_225566_b_((IFeatureConfig)new ExposedOreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)OmniBlocks.RED_ROCK.get()).func_176223_P(), null, (Integer)CoreModule.Configuration.COMMON.RED_ROCK_GEN_SIZE.get(), ExposedOreFeatureConfig.CaveFace.ALL)).func_227228_a_((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 128)).func_242729_a(1)).func_242733_d(80)).func_242728_a()).func_242731_b(10));
        OmniFeatures.Configured.SAGUARO_CACTUS = (ConfiguredFeature)RegistryUtil.createConfiguredFeature("saguaro_cacti", (ConfiguredFeature)((Feature)OmniFeatures.SAGUARO_CACTUS.get()).func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(12)).func_242729_a(12);
        OmniFeatures.Configured.PALO_VERDE_TREE = RegistryUtil.createConfiguredFeature("palo_verde", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.PALO_VERDE_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)OmniBlocks.PALO_VERDE_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BushFoliagePlacer(FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242252_a((int)0), 1), (AbstractTrunkPlacer)new PaloVerdeTrunkPlacer(3, 0, 1), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243990_a)).func_225568_b_()));
        OmniFeatures.Configured.PALO_VERDE_TREES = RegistryUtil.createConfiguredFeature("palo_verde_trees", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)OmniFeatures.Configured.PALO_VERDE_TREE.func_227227_a_(0.8f)), OmniFeatures.Configured.PALO_VERDE_TREE)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(5, 0.5f, 1))));
        OmniFeatures.Configured.DENSE_SAVANNA_TREES = RegistryUtil.createConfiguredFeature("dense_savanna_trees", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Features.field_243865_bK.func_227227_a_(0.8f)), Features.field_243862_bH)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
    }

    @Override
    protected void registerPlacers() {
        OmniFeatures.Placers.PALO_VERDE_TRUNK_PLACER = RegistryUtil.createTrunkPlacer("palo_verde_trunk_placer", PaloVerdeTrunkPlacer.CODEC);
    }

    protected void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        ResourceLocation name = event.getName();
        if (event.getCategory() == Biome.Category.MESA || StringUtils.contains((CharSequence)name.func_110623_a(), (CharSequence)"badland")) {
            BiomeFeatures.addRedRock(gen);
            BiomeFeatures.addTerracottaCaves(gen);
            BiomeFeatures.addSaguaroCacti(gen);
        }
        if (name.func_110623_a().equals(OmniBiomes.WOODED_BADLANDS.getRegistryName().func_110623_a())) {
            gen.func_242517_a(OmniSurfaceBuilders.Configured.WOODED_BADLANDS);
            BiomeFeatures.addDenseSavannaTrees(gen);
            BiomeFeatures.addTerracottaRocks(gen);
            BiomeFeatures.addPaloVerdeTrees(gen);
        }
        if (name.func_110623_a().equals(OmniBiomes.WOODED_DESERT.getRegistryName().func_110623_a())) {
            gen.func_242517_a(OmniSurfaceBuilders.Configured.WOODED_DESERT);
            BiomeFeatures.addDenseSavannaTrees(gen);
            BiomeFeatures.addPaloVerdeTrees(gen);
        }
    }
}

