/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.util;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;

public class BaseGenUtils {
    public static boolean isBlockWithinRange(World world, BlockPos pos, int rangeX, int rangeY, int rangeZ, Block ... blocks) {
        for (int x = pos.func_177958_n() - rangeX; x <= pos.func_177958_n() + rangeX; ++x) {
            for (int y = pos.func_177956_o() - rangeY; y <= pos.func_177956_o() + rangeY; ++y) {
                for (int z = pos.func_177952_p() - rangeZ; z <= pos.func_177952_p() + rangeZ; ++z) {
                    for (Block block : blocks) {
                        if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != block) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isBlockWithinRange(World world, BlockPos pos, int range, Block ... blocks) {
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    for (Block block : blocks) {
                        if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != block) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static List<BlockPos> getBlocksPosWithinRange(World world, BlockPos pos, int range, Block block) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    blockpos$mutable.func_181079_c(x, y, z);
                    if (world.func_180495_p((BlockPos)blockpos$mutable).func_177230_c() != block) continue;
                    positions.add((BlockPos)blockpos$mutable);
                }
            }
        }
        return positions;
    }

    public static boolean isAirPresent(ISeedReader world, BlockPos minimum, BlockPos maximum, float percent) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int volume = (maximum.func_177958_n() - minimum.func_177958_n()) * (maximum.func_177952_p() - minimum.func_177952_p()) * (maximum.func_177956_o() - minimum.func_177956_o());
        int air = 0;
        for (int x = minimum.func_177958_n(); x <= maximum.func_177958_n(); ++x) {
            for (int y = minimum.func_177956_o(); y <= maximum.func_177956_o(); ++y) {
                for (int z = minimum.func_177952_p(); z <= maximum.func_177952_p(); ++z) {
                    blockpos$mutable.func_181079_c(x, y, z);
                    if (!world.func_175623_d((BlockPos)blockpos$mutable)) continue;
                    ++air;
                }
            }
        }
        return (float)air / (float)volume <= percent;
    }
}

