/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.util;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.TallBlockItem;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.stats.IStatFormatter;
import net.minecraft.stats.StatType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import net.minecraftforge.fml.RegistryObject;
import pugz.omni.common.world.biome.AbstractBiome;
import pugz.omni.core.Omni;

public class RegistryUtil {
    public static final List<RenderMaterial> sprites = new ArrayList<RenderMaterial>();

    public static <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = Omni.Registries.BLOCKS.register(name, supplier);
        if (group != null) {
            Omni.Registries.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        }
        return block;
    }

    public static <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier) {
        return Omni.Registries.BLOCKS.register(name, supplier);
    }

    public static <B extends Block> RegistryObject<B> createDoor(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = Omni.Registries.BLOCKS.register(name, supplier);
        if (group != null) {
            Omni.Registries.ITEMS.register(name, () -> new TallBlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        }
        return block;
    }

    public static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        return Omni.Registries.ITEMS.register(name, supplier);
    }

    public static <I extends Item> RegistryObject<I> createOverrideItem(String name, Supplier<? extends I> supplier) {
        return Omni.OverrideRegistries.ITEMS.register(name, supplier);
    }

    public static <T extends TileEntity> RegistryObject<TileEntityType<T>> createTileEntity(String name, Supplier<? extends T> supplier, Supplier<Block[]> blocks) {
        return Omni.Registries.TILE_ENTITIES.register(name, () -> new TileEntityType(supplier, (Set)Sets.newHashSet((Object[])((Object[])blocks.get())), null));
    }

    public static <E extends Entity> RegistryObject<EntityType<E>> createEntity(String name, Supplier<EntityType<E>> supplier) {
        return Omni.Registries.ENTITIES.register(name, supplier);
    }

    public static Biome createBiome(AbstractBiome biome) {
        Omni.Registries.BIOMES.register(biome.getName(), biome::getBiome);
        return biome.getBiome();
    }

    public static <S extends SurfaceBuilder<?>> RegistryObject<S> createSurfaceBuilder(String name, Supplier<? extends S> surfaceBuilder) {
        return Omni.Registries.SURFACE_BUILDERS.register(name, surfaceBuilder);
    }

    public static ConfiguredSurfaceBuilder<SurfaceBuilderConfig> createConfiguredSurfaceBuilder(String name, ConfiguredSurfaceBuilder<SurfaceBuilderConfig> surfaceBuilder) {
        return (ConfiguredSurfaceBuilder)Registry.func_218322_a((Registry)WorldGenRegistries.field_243651_c, (ResourceLocation)new ResourceLocation("omni", name), surfaceBuilder);
    }

    public static <F extends Feature<?>> RegistryObject<F> createFeature(String name, Supplier<? extends F> supplier) {
        return Omni.Registries.FEATURES.register(name, supplier);
    }

    public static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> createConfiguredFeature(String name, ConfiguredFeature<FC, ?> feature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("omni", name), feature);
    }

    public static <P extends AbstractTrunkPlacer> TrunkPlacerType<P> createTrunkPlacer(String name, Codec<P> codec) {
        return (TrunkPlacerType)Registry.func_218325_a((Registry)Registry.field_239701_aw_, (String)name, (Object)new TrunkPlacerType(codec));
    }

    public static <F extends Structure<?>> RegistryObject<F> createStructure(String name, Supplier<? extends F> supplier) {
        return Omni.Registries.STRUCTURES.register(name, supplier);
    }

    public static <FC extends IFeatureConfig> StructureFeature<FC, ?> createStructureFeature(String name, StructureFeature<FC, ?> feature) {
        return (StructureFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("omni", name), feature);
    }

    public static <C extends WorldCarver<?>> RegistryObject<C> createCarver(String name, Supplier<? extends C> supplier) {
        return Omni.Registries.CARVERS.register(name, supplier);
    }

    public static <E extends Enchantment> RegistryObject<E> createEnchantment(String name, Supplier<? extends E> supplier) {
        return Omni.Registries.ENCHANTMENTS.register(name, supplier);
    }

    public static RegistryObject<SoundEvent> createSoundEvent(String name) {
        return Omni.Registries.SOUNDS.register(name, () -> new SoundEvent(new ResourceLocation("omni", name)));
    }

    public static RegistryObject<BasicParticleType> createParticle(String name) {
        return Omni.Registries.PARTICLES.register(name, () -> new BasicParticleType(false));
    }

    public static RegistryObject<StatType<?>> createStatType(String name, IStatFormatter formatter) {
        return Omni.Registries.STATS.register(name, () -> new StatType(Registry.field_212623_l));
    }
}

