/*
 * Decompiled with CFR 0.152.
 */
package movement_arrows.network;

import java.util.function.Supplier;
import movement_arrows.MovementArrowsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MovementArrowsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MovementArrowsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MovementArrowsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.DashCooldown = message.data.DashCooldown;
                    variables.JumpCountHandler = message.data.JumpCountHandler;
                    variables.isparryKeyPressed = message.data.isparryKeyPressed;
                    variables.Parrypresscooldown = message.data.Parrypresscooldown;
                    variables.JumpCountX = message.data.JumpCountX;
                    variables.UpperCutActive = message.data.UpperCutActive;
                    variables.UppercutCoolDown = message.data.UppercutCoolDown;
                    variables.Uppercutting = message.data.Uppercutting;
                    variables.WhiteJumpCountHandler = message.data.WhiteJumpCountHandler;
                    variables.SlidingHeldDown = message.data.SlidingHeldDown;
                    variables.PARRYFLASH = message.data.PARRYFLASH;
                    variables.SmashCooldown = message.data.SmashCooldown;
                    variables.SmashAirPowerCalculator = message.data.SmashAirPowerCalculator;
                    variables.xdelta2 = message.data.xdelta2;
                    variables.zdelta2 = message.data.zdelta2;
                    variables.redparryheldownguishow = message.data.redparryheldownguishow;
                    variables.Smashfill = message.data.Smashfill;
                    variables.smashjumonumbercalc = message.data.smashjumonumbercalc;
                    variables.hasjumped = message.data.hasjumped;
                    variables.currentplayerspeed = message.data.currentplayerspeed;
                    variables.CANSMASHJUMPNOW = message.data.CANSMASHJUMPNOW;
                    variables.LOOKANGLEX = message.data.LOOKANGLEX;
                    variables.LOOKANGLEZ = message.data.LOOKANGLEZ;
                    variables.SpeedometerspeedbutnoY = message.data.SpeedometerspeedbutnoY;
                    variables.playersmashingfallmasg = message.data.playersmashingfallmasg;
                    variables.disableplayermovementinputs = message.data.disableplayermovementinputs;
                    variables.startwallslidingdirection = message.data.startwallslidingdirection;
                    variables.wallrunhasbeenwallrunning = message.data.wallrunhasbeenwallrunning;
                    variables.Wallrunkeyisheldown = message.data.Wallrunkeyisheldown;
                    variables.SmashFallAnimationLevel = message.data.SmashFallAnimationLevel;
                    variables.Crawlstatefromslide = message.data.Crawlstatefromslide;
                    variables.smashlogicplusonedashexception = message.data.smashlogicplusonedashexception;
                    variables.movementarrowsJUMPaftersmashcalcLOGIC = message.data.movementarrowsJUMPaftersmashcalcLOGIC;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double DashCooldown = 0.0;
        public boolean JumpCountHandler = false;
        public boolean isparryKeyPressed = false;
        public double Parrypresscooldown = 0.0;
        public double JumpCountX = 0.0;
        public boolean UpperCutActive = false;
        public double UppercutCoolDown = 0.0;
        public boolean Uppercutting = false;
        public boolean WhiteJumpCountHandler = true;
        public boolean SlidingHeldDown = false;
        public boolean PARRYFLASH = false;
        public double SmashCooldown = 0.0;
        public double SmashAirPowerCalculator = 0.0;
        public double xdelta2 = 0.0;
        public double zdelta2 = 0.0;
        public boolean redparryheldownguishow = false;
        public double Smashfill = 0.0;
        public double smashjumonumbercalc = 0.0;
        public boolean hasjumped = false;
        public double currentplayerspeed = 0.0;
        public boolean CANSMASHJUMPNOW = false;
        public double LOOKANGLEX = 0.0;
        public double LOOKANGLEZ = 0.0;
        public double SpeedometerspeedbutnoY = 0.0;
        public boolean playersmashingfallmasg = false;
        public boolean disableplayermovementinputs = false;
        public Direction startwallslidingdirection = Direction.DOWN;
        public boolean wallrunhasbeenwallrunning = false;
        public boolean Wallrunkeyisheldown = false;
        public double SmashFallAnimationLevel = 0.0;
        public boolean Crawlstatefromslide = false;
        public boolean smashlogicplusonedashexception = false;
        public boolean movementarrowsJUMPaftersmashcalcLOGIC = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MovementArrowsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("DashCooldown", this.DashCooldown);
            nbt.m_128379_("JumpCountHandler", this.JumpCountHandler);
            nbt.m_128379_("isparryKeyPressed", this.isparryKeyPressed);
            nbt.m_128347_("Parrypresscooldown", this.Parrypresscooldown);
            nbt.m_128347_("JumpCountX", this.JumpCountX);
            nbt.m_128379_("UpperCutActive", this.UpperCutActive);
            nbt.m_128347_("UppercutCoolDown", this.UppercutCoolDown);
            nbt.m_128379_("Uppercutting", this.Uppercutting);
            nbt.m_128379_("WhiteJumpCountHandler", this.WhiteJumpCountHandler);
            nbt.m_128379_("SlidingHeldDown", this.SlidingHeldDown);
            nbt.m_128379_("PARRYFLASH", this.PARRYFLASH);
            nbt.m_128347_("SmashCooldown", this.SmashCooldown);
            nbt.m_128347_("SmashAirPowerCalculator", this.SmashAirPowerCalculator);
            nbt.m_128347_("xdelta2", this.xdelta2);
            nbt.m_128347_("zdelta2", this.zdelta2);
            nbt.m_128379_("redparryheldownguishow", this.redparryheldownguishow);
            nbt.m_128347_("Smashfill", this.Smashfill);
            nbt.m_128347_("smashjumonumbercalc", this.smashjumonumbercalc);
            nbt.m_128379_("hasjumped", this.hasjumped);
            nbt.m_128347_("currentplayerspeed", this.currentplayerspeed);
            nbt.m_128379_("CANSMASHJUMPNOW", this.CANSMASHJUMPNOW);
            nbt.m_128347_("LOOKANGLEX", this.LOOKANGLEX);
            nbt.m_128347_("LOOKANGLEZ", this.LOOKANGLEZ);
            nbt.m_128347_("SpeedometerspeedbutnoY", this.SpeedometerspeedbutnoY);
            nbt.m_128379_("playersmashingfallmasg", this.playersmashingfallmasg);
            nbt.m_128379_("disableplayermovementinputs", this.disableplayermovementinputs);
            nbt.m_128405_("startwallslidingdirection", this.startwallslidingdirection.m_122411_());
            nbt.m_128379_("wallrunhasbeenwallrunning", this.wallrunhasbeenwallrunning);
            nbt.m_128379_("Wallrunkeyisheldown", this.Wallrunkeyisheldown);
            nbt.m_128347_("SmashFallAnimationLevel", this.SmashFallAnimationLevel);
            nbt.m_128379_("Crawlstatefromslide", this.Crawlstatefromslide);
            nbt.m_128379_("smashlogicplusonedashexception", this.smashlogicplusonedashexception);
            nbt.m_128379_("movementarrowsJUMPaftersmashcalcLOGIC", this.movementarrowsJUMPaftersmashcalcLOGIC);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.DashCooldown = nbt.m_128459_("DashCooldown");
            this.JumpCountHandler = nbt.m_128471_("JumpCountHandler");
            this.isparryKeyPressed = nbt.m_128471_("isparryKeyPressed");
            this.Parrypresscooldown = nbt.m_128459_("Parrypresscooldown");
            this.JumpCountX = nbt.m_128459_("JumpCountX");
            this.UpperCutActive = nbt.m_128471_("UpperCutActive");
            this.UppercutCoolDown = nbt.m_128459_("UppercutCoolDown");
            this.Uppercutting = nbt.m_128471_("Uppercutting");
            this.WhiteJumpCountHandler = nbt.m_128471_("WhiteJumpCountHandler");
            this.SlidingHeldDown = nbt.m_128471_("SlidingHeldDown");
            this.PARRYFLASH = nbt.m_128471_("PARRYFLASH");
            this.SmashCooldown = nbt.m_128459_("SmashCooldown");
            this.SmashAirPowerCalculator = nbt.m_128459_("SmashAirPowerCalculator");
            this.xdelta2 = nbt.m_128459_("xdelta2");
            this.zdelta2 = nbt.m_128459_("zdelta2");
            this.redparryheldownguishow = nbt.m_128471_("redparryheldownguishow");
            this.Smashfill = nbt.m_128459_("Smashfill");
            this.smashjumonumbercalc = nbt.m_128459_("smashjumonumbercalc");
            this.hasjumped = nbt.m_128471_("hasjumped");
            this.currentplayerspeed = nbt.m_128459_("currentplayerspeed");
            this.CANSMASHJUMPNOW = nbt.m_128471_("CANSMASHJUMPNOW");
            this.LOOKANGLEX = nbt.m_128459_("LOOKANGLEX");
            this.LOOKANGLEZ = nbt.m_128459_("LOOKANGLEZ");
            this.SpeedometerspeedbutnoY = nbt.m_128459_("SpeedometerspeedbutnoY");
            this.playersmashingfallmasg = nbt.m_128471_("playersmashingfallmasg");
            this.disableplayermovementinputs = nbt.m_128471_("disableplayermovementinputs");
            this.startwallslidingdirection = Direction.m_122376_((int)nbt.m_128451_("startwallslidingdirection"));
            this.wallrunhasbeenwallrunning = nbt.m_128471_("wallrunhasbeenwallrunning");
            this.Wallrunkeyisheldown = nbt.m_128471_("Wallrunkeyisheldown");
            this.SmashFallAnimationLevel = nbt.m_128459_("SmashFallAnimationLevel");
            this.Crawlstatefromslide = nbt.m_128471_("Crawlstatefromslide");
            this.smashlogicplusonedashexception = nbt.m_128471_("smashlogicplusonedashexception");
            this.movementarrowsJUMPaftersmashcalcLOGIC = nbt.m_128471_("movementarrowsJUMPaftersmashcalcLOGIC");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("movement_arrows", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "movement_arrows_mapvars";
        public boolean messagewarningissent = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.messagewarningissent = nbt.m_128471_("messagewarningissent");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("messagewarningissent", this.messagewarningissent);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MovementArrowsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "movement_arrows_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MovementArrowsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            if (!event.isWasDeath()) {
                clone.DashCooldown = original.DashCooldown;
                clone.JumpCountHandler = original.JumpCountHandler;
                clone.isparryKeyPressed = original.isparryKeyPressed;
                clone.Parrypresscooldown = original.Parrypresscooldown;
                clone.JumpCountX = original.JumpCountX;
                clone.UpperCutActive = original.UpperCutActive;
                clone.UppercutCoolDown = original.UppercutCoolDown;
                clone.Uppercutting = original.Uppercutting;
                clone.WhiteJumpCountHandler = original.WhiteJumpCountHandler;
                clone.SlidingHeldDown = original.SlidingHeldDown;
                clone.PARRYFLASH = original.PARRYFLASH;
                clone.SmashCooldown = original.SmashCooldown;
                clone.SmashAirPowerCalculator = original.SmashAirPowerCalculator;
                clone.xdelta2 = original.xdelta2;
                clone.zdelta2 = original.zdelta2;
                clone.redparryheldownguishow = original.redparryheldownguishow;
                clone.Smashfill = original.Smashfill;
                clone.smashjumonumbercalc = original.smashjumonumbercalc;
                clone.hasjumped = original.hasjumped;
                clone.currentplayerspeed = original.currentplayerspeed;
                clone.CANSMASHJUMPNOW = original.CANSMASHJUMPNOW;
                clone.LOOKANGLEX = original.LOOKANGLEX;
                clone.LOOKANGLEZ = original.LOOKANGLEZ;
                clone.SpeedometerspeedbutnoY = original.SpeedometerspeedbutnoY;
                clone.playersmashingfallmasg = original.playersmashingfallmasg;
                clone.disableplayermovementinputs = original.disableplayermovementinputs;
                clone.startwallslidingdirection = original.startwallslidingdirection;
                clone.wallrunhasbeenwallrunning = original.wallrunhasbeenwallrunning;
                clone.Wallrunkeyisheldown = original.Wallrunkeyisheldown;
                clone.SmashFallAnimationLevel = original.SmashFallAnimationLevel;
                clone.Crawlstatefromslide = original.Crawlstatefromslide;
                clone.smashlogicplusonedashexception = original.smashlogicplusonedashexception;
                clone.movementarrowsJUMPaftersmashcalcLOGIC = original.movementarrowsJUMPaftersmashcalcLOGIC;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MovementArrowsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MovementArrowsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MovementArrowsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

