/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.pack.AnimationParameters;
import nl.enjarai.a_good_place.pack.AnimationsManager;
import nl.enjarai.a_good_place.particles.ConfiguredPlacingParticle;
import nl.enjarai.a_good_place.particles.PlacingBlockParticle;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class BlocksParticlesManager {
    protected static final Map<BlockPos, PlacingBlockParticle> PARTICLES = new HashMap<BlockPos, PlacingBlockParticle>();
    private static final Set<BlockPos> HIDDEN_BLOCKS = new CopyOnWriteArraySet<BlockPos>();

    public static void addParticle(BlockState state, BlockPos pos, ClientLevel level, Direction face, Player player, InteractionHand hand) {
        Camera camera;
        AnimationParameters param = AnimationsManager.getAnimation(state, pos, (Level)level);
        if (param != null && (camera = Minecraft.getInstance().gameRenderer.getMainCamera()).getPosition().distanceToSqr(pos.getCenter()) <= 1024.0) {
            boolean isJustModel;
            ConfiguredPlacingParticle p = new ConfiguredPlacingParticle(level, pos, face, player, hand, param);
            PlacingBlockParticle old = PARTICLES.put(pos, p);
            if (old != null) {
                old.remove();
            }
            boolean bl = isJustModel = state.getRenderShape() == RenderShape.MODEL;
            if (isJustModel) {
                p.canRender = true;
                BlocksParticlesManager.hideBlock(pos);
            } else {
                p.canRender = false;
            }
            if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES) {
                Minecraft.getInstance().particleEngine.add((Particle)p);
            }
        }
    }

    public static void hideBlock(BlockPos pos) {
        HIDDEN_BLOCKS.add(pos);
    }

    public static boolean isBlockHidden(BlockPos pos) {
        return HIDDEN_BLOCKS.contains(pos);
    }

    public static void unHideBlock(BlockPos pos) {
        boolean success = HIDDEN_BLOCKS.remove(pos);
        PARTICLES.remove(pos);
        if (success) {
            BlocksParticlesManager.markBlockForRender(pos);
        }
    }

    private static void markBlockForRender(BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockState state = level.getBlockState(pos);
        level.sendBlockUpdated(pos, state, state, 2);
    }

    public static void tickParticles(ClientLevel level) {
        if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES) {
            return;
        }
        Iterator<Map.Entry<BlockPos, PlacingBlockParticle>> iterator = PARTICLES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, PlacingBlockParticle> entry = iterator.next();
            PlacingBlockParticle p = entry.getValue();
            p.tick();
            if (p.isAlive()) continue;
            iterator.remove();
        }
    }

    public static void renderParticles(PoseStack poseStack, float tickDelta) {
        if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES || PARTICLES.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        RenderSystem.enableDepthTest();
        Matrix4fStack poseStack2 = RenderSystem.getModelViewStack();
        poseStack2.pushMatrix();
        poseStack2.mul((Matrix4fc)poseStack.last().pose());
        RenderSystem.applyModelViewMatrix();
        for (PlacingBlockParticle p : PARTICLES.values()) {
            p.render(null, camera, tickDelta);
        }
        bufferSource.endBatch();
        poseStack2.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public static void modifyTilePosition(BlockPos pos, PoseStack pose, float partialTicks) {
        PlacingBlockParticle particle = PARTICLES.get(pos);
        if (particle != null) {
            particle.applyAnimation(pose, partialTicks);
        }
    }

    public static void clear() {
        PARTICLES.clear();
        HIDDEN_BLOCKS.clear();
    }
}

