/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import nl.enjarai.a_good_place.pack.AnimationParameters;
import nl.enjarai.a_good_place.particles.PlacingBlockParticle;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ConfiguredPlacingParticle
extends PlacingBlockParticle {
    private final AnimationParameters params;
    private final float yAngle;
    private final Vec2 slideStart;
    private final Vec3 rotStart;

    public ConfiguredPlacingParticle(ClientLevel level, BlockPos blockPos, Direction face, Player placer, InteractionHand hand, AnimationParameters settings) {
        super(level, blockPos, face);
        int rightHandMul;
        settings.sound().ifPresent(sound -> level.playLocalSound(blockPos, (SoundEvent)sound.value(), SoundSource.PLAYERS, 1.0f, 1.0f, false));
        this.params = settings;
        this.lifetime = this.params.duration();
        this.extraLifeTicks = 2;
        Vector3f playerHorizLook = placer.getLookAngle().toVector3f().mul(-1.0f, 0.0f, -1.0f).normalize();
        int n = rightHandMul = placer.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        if (hand != InteractionHand.MAIN_HAND) {
            rightHandMul *= -1;
        }
        Vector3f xVec = new Vector3f(playerHorizLook.z, 0.0f, -playerHorizLook.x).mul((float)rightHandMul);
        Matrix3f changeOfBasis = new Matrix3f((Vector3fc)xVec, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)playerHorizLook);
        Vector3f tr = this.params.translation().toVector3f();
        float slidePow = tr.length();
        if (placer.getXRot() > 0.0f) {
            tr.mul(1.0f, 1.0f, 1.0f);
        } else {
            tr.mul(1.0f, -1.0f, 1.0f);
        }
        Vector3f slideDir = tr.mul((Matrix3fc)changeOfBasis);
        slideDir = this.adjustDirectionBasedOnNeighbors(level, placer, slideDir);
        Vec3 animationDirection = new Vec3(slideDir.normalize());
        this.yAngle = (float)Math.atan2(slideDir.x(), slideDir.z());
        Vec3 temp = animationDirection.yRot(-this.yAngle);
        this.slideStart = new Vec2((float)temp.z, (float)temp.y).scale(slidePow);
        this.rotStart = this.params.rotation();
    }

    @Override
    public void applyAnimation(PoseStack poseStack, float time, float partialTicks) {
        poseStack.translate(0.5, 0.5, 0.5);
        Vec3 offset = this.blockState.getOffset((BlockGetter)this.level, this.pos);
        poseStack.translate(offset.x, offset.y, offset.z);
        poseStack.mulPose(Axis.YP.rotation(this.yAngle));
        float progress = this.fancyExponent(time, this.params.translationCurve());
        Vec2 translate = this.slideStart.scale(1.0f - progress);
        poseStack.translate(0.0f, translate.y, translate.x);
        progress = this.fancyExponent(time, this.params.rotationCurve());
        Vec3 rotation = this.rotStart.scale((double)(1.0f - progress));
        Vec3 rotationPivot = this.params.pivot();
        if (this.slideStart.y < 0.0f) {
            rotationPivot = rotationPivot.multiply(1.0, -1.0, 1.0);
            rotation = rotation.multiply(-1.0, 1.0, -1.0);
        }
        poseStack.translate(rotationPivot.x, rotationPivot.y, rotationPivot.z);
        poseStack.mulPose(Axis.YP.rotation((float)rotation.y));
        poseStack.mulPose(Axis.ZP.rotation((float)rotation.z));
        poseStack.mulPose(Axis.XP.rotation((float)rotation.x));
        poseStack.translate(-rotationPivot.x, -rotationPivot.y, -rotationPivot.z);
        progress = this.fancyExponent(time, this.params.scaleCurve());
        float scaleStart = this.params.scaleStart();
        float scale = scaleStart + (0.999f - scaleStart) * progress;
        poseStack.scale(scale, scale, scale);
        progress = this.fancyExponent(time, this.params.heightCurve());
        float heightStart = this.params.heightStart();
        float height = heightStart + (1.0f - heightStart) * progress;
        poseStack.translate(0.0, -0.5, 0.0);
        poseStack.scale(1.0f, height, 1.0f);
        poseStack.translate(0.0f, 0.5f, 0.0f);
        poseStack.mulPose(Axis.YP.rotation(-this.yAngle));
        poseStack.translate(-offset.x, -offset.y, -offset.z);
        poseStack.translate(-0.5, -0.5, -0.5);
    }

    private float parabula(float t, float exp, float startSlope) {
        float a = 1.0f - startSlope;
        return a * (float)Math.pow(t, exp) + (1.0f - a) * t;
    }

    private float exponent(float t, float base) {
        return (float)((double)base * Math.pow(1.0f / base + 1.0f, t) - (double)base);
    }

    private float fancyExponent(float t, float curve) {
        if (curve == 0.0f) {
            return t;
        }
        float base = curve > 0.0f ? (float)(-Math.log(curve)) : (float)(Math.log(-curve) - 1.0);
        return this.exponent(t, base);
    }

    private float addSomeRandom(float t) {
        return t;
    }

    public static List<Direction> getAffectedDirections(float x, float y, float z) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (z > 0.0f) {
            list.add(Direction.SOUTH);
        }
        if (z < 0.0f) {
            list.add(Direction.NORTH);
        }
        if (x > 0.0f) {
            list.add(Direction.EAST);
        }
        if (x < 0.0f) {
            list.add(Direction.WEST);
        }
        if (y > 0.0f) {
            list.add(Direction.UP);
        }
        if (y < 0.0f) {
            list.add(Direction.DOWN);
        }
        return list;
    }

    @NotNull
    private Vector3f adjustDirectionBasedOnNeighbors(ClientLevel world, Player placer, Vector3f slideDir) {
        List<Direction> affectedDir = ConfiguredPlacingParticle.getAffectedDirections(slideDir.x(), slideDir.y(), slideDir.z());
        ArrayList<Direction> emptyDirections = new ArrayList<Direction>();
        for (Direction d : Direction.values()) {
            BlockPos neighbor = this.pos.relative(d);
            BlockState state = world.getBlockState(neighbor);
            VoxelShape collision = state.getCollisionShape((BlockGetter)world, neighbor);
            if (collision.isEmpty()) {
                emptyDirections.add(d);
                continue;
            }
            if (d.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                if (!(collision.min(d.getAxis()) > 0.25)) continue;
                emptyDirections.add(d);
                continue;
            }
            if (!(collision.max(d.getAxis()) < 0.75)) continue;
            emptyDirections.add(d);
        }
        for (Direction d : affectedDir) {
            if (emptyDirections.contains(d)) continue;
            slideDir.sub((Vector3fc)d.step().mul((Vector3fc)d.step()).mul((Vector3fc)slideDir));
        }
        if (slideDir.length() == 0.0f && !emptyDirections.isEmpty()) {
            List<Direction> nearest = List.of(Direction.orderedByNearest((Entity)placer));
            emptyDirections.sort(Comparator.comparingInt(nearest::indexOf));
            slideDir = ((Direction)emptyDirections.get(0)).step();
        }
        return slideDir;
    }
}

