/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.particles.BlocksParticlesManager;

public abstract class PlacingBlockParticle
extends Particle {
    protected final BlockPos pos;
    protected final BlockState blockState;
    private final BakedModel model;
    private final long seed;
    private final BlockRenderDispatcher renderer;
    protected int extraLifeTicks = 0;
    public boolean canRender;

    public PlacingBlockParticle(ClientLevel world, BlockPos blockPos, Direction face) {
        super(world, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        Minecraft client = Minecraft.getInstance();
        this.pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        this.blockState = world.getBlockState(this.pos);
        this.model = client.getBlockRenderer().getBlockModel(this.blockState);
        this.seed = this.blockState.getSeed(this.pos);
        this.renderer = client.getBlockRenderer();
        this.hasPhysics = false;
        this.lifetime = 7;
        this.setSize(1.0f, 1.0f);
    }

    public void tick() {
        if (this.removed) {
            return;
        }
        ++this.age;
        if (this.age >= this.lifetime + this.extraLifeTicks) {
            this.remove();
        }
        if (this.finishedAnimation()) {
            BlocksParticlesManager.unHideBlock(this.pos);
        }
        if (this.level.getBlockState(this.pos) != this.blockState) {
            this.remove();
            BlocksParticlesManager.unHideBlock(this.pos);
        }
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        if (!this.canRender) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        Vec3 cameraPos = camera.getPosition();
        float px = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float py = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float pz = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        poseStack.translate(px, py, pz);
        this.applyAnimation(poseStack, partialTicks);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        AGoodPlace.renderBlock(this.model, this.seed, poseStack, (MultiBufferSource)bufferSource, this.blockState, (Level)this.level, this.pos, this.renderer);
        if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES) {
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
        }
    }

    public final void applyAnimation(PoseStack poseStack, float partialTicks) {
        float t = Math.min(1.0f, ((float)this.age + partialTicks) / (float)(this.lifetime + 1));
        this.applyAnimation(poseStack, t, partialTicks);
    }

    protected abstract void applyAnimation(PoseStack var1, float var2, float var3);

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public boolean finishedAnimation() {
        return this.age >= this.lifetime;
    }
}

