/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.traversableleaves.config;

import com.dreu.traversableleaves.TraversableLeaves;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.toml.TomlParser;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class TLConfig {
    public static boolean configNeedsRepair = false;
    static final String fileName = "config/traversable_leaves/general.toml";
    static final String defaultConfig = "#Movement Speed penalty while traversing leaves, 0 = no penalty (Range : 0 - 100)\nSpeedPenalty = 27 #Default: 27\n\n#Whether Armor value reduces movement penalty\nArmorBonus = true #Defualt: true\n\n#List of leaves (false = Blacklist)\nLeavesWhitelist = true #Default: true\nTraversable=[\n \"minecraft:jungle_leaves\",\n \"minecraft:oak_leaves\",\n \"minecraft:spruce_leaves\",\n \"minecraft:dark_oak_leaves\",\n \"minecraft:acacia_leaves\",\n \"minecraft:birch_leaves\",\n \"minecraft:azalea_leaves\",\n \"minecraft:flowering_azalea_leaves\",\n \"minecraft:mangrove_leaves\"\n]\n\n#List of Entities that can/cannot traverse leaves (false = Blacklist)\nEntityWhitelist = false #Default: false\nEntities=[\n \"minecraft:sheep\",\n \"minecraft:pig\",\n \"minecraft:cow\",\n \"minecraft:chicken\",\n \"minecraft:donkey\",\n \"minecraft:llama\",\n \"minecraft:trader_llama\",\n \"minecraft:mule\",\n \"minecraft:frog\",\n \"minecraft:goat\",\n \"minecraft:mooshroom\",\n \"minecraft:turtle\"\n]\n";
    private static final Config CONFIG = TLConfig.parseFileOrDefault();
    private static final Config DEFAULT_CONFIG = new TomlParser().parse("#Movement Speed penalty while traversing leaves, 0 = no penalty (Range : 0 - 100)\nSpeedPenalty = 27 #Default: 27\n\n#Whether Armor value reduces movement penalty\nArmorBonus = true #Defualt: true\n\n#List of leaves (false = Blacklist)\nLeavesWhitelist = true #Default: true\nTraversable=[\n \"minecraft:jungle_leaves\",\n \"minecraft:oak_leaves\",\n \"minecraft:spruce_leaves\",\n \"minecraft:dark_oak_leaves\",\n \"minecraft:acacia_leaves\",\n \"minecraft:birch_leaves\",\n \"minecraft:azalea_leaves\",\n \"minecraft:flowering_azalea_leaves\",\n \"minecraft:mangrove_leaves\"\n]\n\n#List of Entities that can/cannot traverse leaves (false = Blacklist)\nEntityWhitelist = false #Default: false\nEntities=[\n \"minecraft:sheep\",\n \"minecraft:pig\",\n \"minecraft:cow\",\n \"minecraft:chicken\",\n \"minecraft:donkey\",\n \"minecraft:llama\",\n \"minecraft:trader_llama\",\n \"minecraft:mule\",\n \"minecraft:frog\",\n \"minecraft:goat\",\n \"minecraft:mooshroom\",\n \"minecraft:turtle\"\n]\n");
    public static final Set<ResourceLocation> LEAVES = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> ENTITIES = new HashSet<ResourceLocation>();
    public static final float MOVEMENT_PENALTY = (float)TLConfig.getOrDefault("SpeedPenalty", Integer.class).intValue() * 0.02f;
    public static final float ARMOR_SCALE_FACTOR = (2.0f - MOVEMENT_PENALTY) * 0.05f;
    public static final boolean ARMOR_HELPS = TLConfig.getOrDefault("ArmorBonus", Boolean.class);
    public static final boolean IS_LEAVES_WHITELIST = TLConfig.getOrDefault("LeavesWhitelist", Boolean.class);
    public static final boolean IS_ENTITIES_WHITELIST = TLConfig.getOrDefault("EntityWhitelist", Boolean.class);

    static <T> T getOrDefault(String key, Class<T> clas) {
        try {
            if (CONFIG.get(key) == null) {
                TraversableLeaves.LOGGER.error("Key [{}] is missing from Config: {}", (Object)key, (Object)fileName);
                configNeedsRepair = true;
                return clas.cast(DEFAULT_CONFIG.get(key));
            }
            return (T)CONFIG.get(key);
        }
        catch (Exception e) {
            TraversableLeaves.LOGGER.error("Value for [{}] is an invalid type in Config: {}", (Object)key, (Object)fileName);
            configNeedsRepair = true;
            return clas.cast(DEFAULT_CONFIG.get(key));
        }
    }

    static Config parseFileOrDefault() {
        try {
            Files.createDirectories(Path.of("config/traversable_leaves", new String[0]), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TomlParser().parse(Path.of(fileName, new String[0]).toAbsolutePath(), (path, configFormat) -> {
            FileWriter writer = new FileWriter(path.toFile().getAbsolutePath());
            writer.write(defaultConfig);
            writer.close();
            return true;
        });
    }

    public static void repairConfig() {
    }

    static {
        List leafStrings = TLConfig.getOrDefault("Traversable", List.class);
        leafStrings.forEach(leaf -> LEAVES.add(new ResourceLocation(leaf)));
        List entityStrings = TLConfig.getOrDefault("Entities", List.class);
        entityStrings.forEach(entity -> ENTITIES.add(new ResourceLocation(entity)));
    }
}

