/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.block;

import com.chefmooon.breezebounce.common.block.SimpleBreezeBounceBlock;
import com.chefmooon.breezebounce.common.registry.ModParticleTypes;
import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BreezeBounceBlock
extends Block
implements SimpleBreezeBounceBlock {
    public static final MapCodec<BreezeBounceBlock> CODEC = BreezeBounceBlock.simpleCodec(BreezeBounceBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<? extends BreezeBounceBlock> codec() {
        return CODEC;
    }

    public BreezeBounceBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SimpleBreezeBounceBlock.bounceSoundType()));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public void fallOn(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float f) {
        if (entity.isSuppressingBounce()) {
            super.fallOn(level, blockState, blockPos, entity, f);
        } else {
            entity.causeFallDamage(f, 0.0f, level.damageSources().fall());
        }
    }

    public void updateEntityMovementAfterFallOn(BlockGetter blockGetter, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(blockGetter, entity);
        } else {
            BlockPos blockPos = entity.getBlockPosBelowThatAffectsMyMovement();
            if (blockGetter.getBlockState(blockPos).getBlock() instanceof BreezeBounceBlock) {
                this.bounceUp(entity, (Boolean)blockGetter.getBlockState(blockPos).getValue((Property)POWERED), 1.0);
            }
        }
    }

    public float getJumpFactor() {
        return this.jumpFactor + 0.5f;
    }

    protected void onExplosionHit(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Explosion explosion, BiConsumer<ItemStack, BlockPos> biConsumer) {
        if (explosion.canTriggerBlocks() && !((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.inflate(this, blockState, (Level)serverLevel, blockPos, null);
        }
        super.onExplosionHit(blockState, serverLevel, blockPos, explosion, biConsumer);
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.checkPower(this, blockState, (Level)serverLevel, blockPos);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.spawnParticles(level, blockPos);
        }
    }

    @Override
    public void spawnParticles(Level level, BlockPos blockPos) {
        Direction[] directions;
        double d = 0.5625;
        RandomSource randomSource = level.random;
        for (Direction direction : directions = Direction.values()) {
            BlockPos blockPos2 = blockPos.relative(direction);
            if (level.getBlockState(blockPos2).isSolidRender()) continue;
            Direction.Axis axis = direction.getAxis();
            double e = axis == Direction.Axis.X ? 0.5 + d * (double)direction.getStepX() : (double)randomSource.nextFloat();
            double f = axis == Direction.Axis.Y ? 0.5 + d * (double)direction.getStepY() : (double)randomSource.nextFloat();
            double g = axis == Direction.Axis.Z ? 0.5 + d * (double)direction.getStepZ() : (double)randomSource.nextFloat();
            level.addParticle((ParticleOptions)ModParticleTypes.BOUNCE_WHITE.get(), (double)blockPos.getX() + e, (double)blockPos.getY() + f, (double)blockPos.getZ() + g, 0.0, 0.0, 0.0);
        }
    }
}

