/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.block;

import com.chefmooon.breezebounce.common.block.SimpleBreezeBounceBlock;
import com.chefmooon.breezebounce.common.registry.ModParticleTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class BreezeBounceStairBlock
extends StairBlock
implements SimpleBreezeBounceBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<BreezeBounceStairBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("base_state").forGetter(stairBlock -> stairBlock.baseState), (App)BreezeBounceStairBlock.propertiesCodec()).apply((Applicative)instance, BreezeBounceStairBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<? extends BreezeBounceStairBlock> codec() {
        return CODEC;
    }

    public BreezeBounceStairBlock(BlockState blockState, BlockBehaviour.Properties properties) {
        super(blockState, properties.sound(SimpleBreezeBounceBlock.bounceSoundType()));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public void fallOn(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float f) {
        if (entity.isSuppressingBounce()) {
            super.fallOn(level, blockState, blockPos, entity, f);
        } else {
            entity.causeFallDamage(f, 0.0f, level.damageSources().fall());
        }
    }

    public void updateEntityMovementAfterFallOn(BlockGetter blockGetter, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(blockGetter, entity);
        } else {
            BlockPos blockPos = entity.getBlockPosBelowThatAffectsMyMovement().above();
            if (blockGetter.getBlockState(blockPos).getBlock() instanceof BreezeBounceStairBlock) {
                if (blockGetter.getBlockState(blockPos).getValue((Property)HALF) == Half.BOTTOM) {
                    this.bounceUp(entity, (Boolean)blockGetter.getBlockState(blockPos).getValue((Property)POWERED), 1.0);
                }
            } else if (blockGetter.getBlockState(blockPos.below()).getBlock() instanceof BreezeBounceStairBlock) {
                this.bounceUp(entity, (Boolean)blockGetter.getBlockState(blockPos.below()).getValue((Property)POWERED), 1.0);
            }
        }
    }

    public float getJumpFactor() {
        return this.jumpFactor + 0.5f;
    }

    protected void onExplosionHit(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Explosion explosion, BiConsumer<ItemStack, BlockPos> biConsumer) {
        if (explosion.canTriggerBlocks() && !((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.inflate((Block)this, blockState, (Level)serverLevel, blockPos, null);
        }
        super.onExplosionHit(blockState, serverLevel, blockPos, explosion, biConsumer);
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.checkPower((Block)this, blockState, (Level)serverLevel, blockPos);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.spawnParticles(level, blockPos);
        }
    }

    @Override
    public void spawnParticles(Level level, BlockPos blockPos) {
        double d = 0.5625;
        RandomSource randomSource = level.random;
        Direction[] directions = Direction.values();
        BlockState blockState = level.getBlockState(blockPos);
        Half half = (Half)blockState.getValue((Property)HALF);
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        for (Direction direction : directions) {
            BlockPos blockPos2 = blockPos.relative(direction);
            if (level.getBlockState(blockPos2).isSolidRender()) continue;
            this.spawnSlabParticles(level, blockPos, randomSource, direction, half, facing, d);
            this.spawnOtherParticles(level, blockPos, randomSource, direction, half, facing, d);
        }
    }

    private void spawnSlabParticles(Level level, BlockPos blockPos, RandomSource randomSource, Direction direction, Half half, Direction facing, double d) {
        boolean canSpawn;
        boolean bl = canSpawn = !(direction == Direction.UP && half == Half.TOP || direction == Direction.DOWN && half == Half.BOTTOM);
        if (canSpawn) {
            Direction.Axis axis = direction.getAxis();
            double e = axis == Direction.Axis.X ? 0.5 + d * (double)direction.getStepX() : (double)randomSource.nextFloat();
            double f = switch (half) {
                default -> throw new MatchException(null, null);
                case Half.BOTTOM -> d * (double)randomSource.nextFloat();
                case Half.TOP -> 0.48 + d * (double)randomSource.nextFloat();
            };
            double g = axis == Direction.Axis.Z ? 0.5 + d * (double)direction.getStepZ() : (double)randomSource.nextFloat();
            level.addParticle((ParticleOptions)ModParticleTypes.BOUNCE_WHITE.get(), (double)blockPos.getX() + e, (double)blockPos.getY() + f, (double)blockPos.getZ() + g, 0.0, 0.0, 0.0);
        }
    }

    private void spawnOtherParticles(Level level, BlockPos blockPos, RandomSource randomSource, Direction direction, Half half, Direction facing, double d) {
        boolean canSpawn;
        boolean bl = canSpawn = !(direction == Direction.UP && half == Half.TOP || direction == Direction.DOWN && half == Half.BOTTOM);
        if (canSpawn) {
            double g;
            double f;
            double e;
            Direction.Axis axis = direction.getAxis();
            if (facing == Direction.EAST || facing == Direction.WEST) {
                e = switch (facing.getAxisDirection()) {
                    default -> throw new MatchException(null, null);
                    case Direction.AxisDirection.NEGATIVE -> d * (double)randomSource.nextFloat();
                    case Direction.AxisDirection.POSITIVE -> 0.5 + d * (double)randomSource.nextFloat();
                };
            } else {
                e = axis == Direction.Axis.X ? 0.5 + d * (double)direction.getStepX() : (double)randomSource.nextFloat();
            }
            switch (half) {
                default: {
                    throw new MatchException(null, null);
                }
                case TOP: {
                    double d2 = d * (double)randomSource.nextFloat();
                    break;
                }
                case BOTTOM: {
                    double d2 = f = 0.5 + d * (double)randomSource.nextFloat();
                }
            }
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                g = switch (facing.getAxisDirection()) {
                    default -> throw new MatchException(null, null);
                    case Direction.AxisDirection.NEGATIVE -> d * (double)randomSource.nextFloat();
                    case Direction.AxisDirection.POSITIVE -> 0.5 + d * (double)randomSource.nextFloat();
                };
            } else {
                g = axis == Direction.Axis.Z ? 0.5 + d * (double)direction.getStepZ() : (double)randomSource.nextFloat();
            }
            level.addParticle((ParticleOptions)ModParticleTypes.BOUNCE_WHITE.get(), (double)blockPos.getX() + e, (double)blockPos.getY() + f, (double)blockPos.getZ() + g, 0.0, 0.0, 0.0);
        }
    }
}

