/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.breezebounce.common.block;

import com.chefmooon.breezebounce.common.block.BreezeBounceBlock;
import com.chefmooon.breezebounce.common.registry.ModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BreezeBounceWallBlock
extends BreezeBounceBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    protected static final float AABB_MIN = 6.0f;
    protected static final float AABB_MAX = 10.0f;
    protected static final VoxelShape Y_AXIS_AABB = BreezeBounceWallBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = BreezeBounceWallBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = BreezeBounceWallBlock.box((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    protected static final VoxelShape Y_AXIS_AABB_COLLISION = BreezeBounceWallBlock.box((double)4.75, (double)0.0, (double)4.75, (double)11.25, (double)16.0, (double)11.25);
    protected static final VoxelShape Z_AXIS_AABB_COLLISION = BreezeBounceWallBlock.box((double)4.75, (double)4.75, (double)0.0, (double)11.25, (double)11.25, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB_COLLISION = BreezeBounceWallBlock.box((double)0.0, (double)4.75, (double)4.75, (double)16.0, (double)11.25, (double)11.25);

    public BreezeBounceWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED, AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER))).setValue(AXIS, (Comparable)context.getClickedFace().getAxis());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos arg6, BlockState arg7, RandomSource arg8) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return state;
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        switch ((Direction.Axis)blockState.getValue(AXIS)) {
            default: {
                return X_AXIS_AABB;
            }
            case Z: {
                return Z_AXIS_AABB;
            }
            case Y: 
        }
        return Y_AXIS_AABB;
    }

    protected VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        switch ((Direction.Axis)blockState.getValue(AXIS)) {
            default: {
                return X_AXIS_AABB_COLLISION;
            }
            case Z: {
                return Z_AXIS_AABB_COLLISION;
            }
            case Y: 
        }
        return Y_AXIS_AABB_COLLISION;
    }

    @Override
    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.spawnParticles(level, blockPos);
        }
    }

    @Override
    public void spawnParticles(Level level, BlockPos blockPos) {
        double d = 0.1625;
        double dNorm = 0.5625;
        RandomSource randomSource = level.random;
        Direction[] directions = Direction.values();
        Direction.Axis facingAxis = (Direction.Axis)level.getBlockState(blockPos).getValue(AXIS);
        for (Direction direction : directions) {
            double g;
            BlockPos blockPos2;
            Direction.Axis axis = direction.getAxis();
            if (facingAxis == axis && level.getBlockState(blockPos2 = blockPos.relative(direction)).isSolidRender()) continue;
            double e = axis == Direction.Axis.X ? d * (double)direction.getStepX() : (double)randomSource.nextFloat() * 0.4 - 0.2;
            double f = axis == Direction.Axis.Y ? d * (double)direction.getStepY() : (double)randomSource.nextFloat() * 0.4 - 0.2;
            double d2 = g = axis == Direction.Axis.Z ? d * (double)direction.getStepZ() : (double)randomSource.nextFloat() * 0.4 - 0.2;
            if (facingAxis == Direction.Axis.X) {
                e = axis == Direction.Axis.X ? dNorm * (double)direction.getStepX() : (double)randomSource.nextFloat() - 0.5;
            } else if (facingAxis == Direction.Axis.Y) {
                f = axis == Direction.Axis.Y ? dNorm * (double)direction.getStepY() : (double)randomSource.nextFloat() - 0.5;
            } else if (facingAxis == Direction.Axis.Z) {
                g = axis == Direction.Axis.Z ? dNorm * (double)direction.getStepZ() : (double)randomSource.nextFloat() - 0.5;
            }
            level.addParticle((ParticleOptions)ModParticleTypes.BOUNCE_WHITE.get(), blockPos.getCenter().x() + e, blockPos.getCenter().y() + f, blockPos.getCenter().z() + g, 0.0, 0.0, 0.0);
        }
    }

    protected BlockState rotate(BlockState blockState, Rotation rotation) {
        return BreezeBounceWallBlock.rotatePost(blockState, rotation);
    }

    public static BlockState rotatePost(BlockState blockState, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)blockState.getValue(AXIS)) {
                    case X: {
                        return (BlockState)blockState.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)blockState.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return blockState;
            }
        }
        return blockState;
    }
}

