/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mango_mod.world.dimension;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.mango_mod.MangoModModElements;
import net.mcreator.mango_mod.block.WithericobsidianBlock;
import net.mcreator.mango_mod.item.WithericLandItem;
import net.mcreator.mango_mod.particle.SoulpaticleParticle;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@MangoModModElements.ModElement.Tag
public class WithericLandDimension
extends MangoModModElements.ModElement {
    @ObjectHolder(value="mango_mod:witheric_land_portal")
    public static final CustomPortalBlock portal = null;
    private static PointOfInterestType poi = null;
    public static final TicketType<BlockPos> CUSTOM_PORTAL = TicketType.func_223183_a((String)"witheric_land_portal", Vector3i::compareTo, (int)300);

    public WithericLandDimension(MangoModModElements instance) {
        super(instance, 2968);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new POIRegisterHandler());
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        HashSet<Block> replaceableBlocks = new HashSet<Block>();
        replaceableBlocks.add(Blocks.field_150424_aL);
        replaceableBlocks.add(((ConfiguredSurfaceBuilder)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("mango_mod:soul_valley"))).func_242440_e().func_242500_d().get()).func_215452_a().func_204108_a().func_177230_c());
        replaceableBlocks.add(((ConfiguredSurfaceBuilder)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("mango_mod:soul_valley"))).func_242440_e().func_242500_d().get()).func_215452_a().func_204109_b().func_177230_c());
        replaceableBlocks.add(((ConfiguredSurfaceBuilder)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("mango_mod:netherforest"))).func_242440_e().func_242500_d().get()).func_215452_a().func_204108_a().func_177230_c());
        replaceableBlocks.add(((ConfiguredSurfaceBuilder)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("mango_mod:netherforest"))).func_242440_e().func_242500_d().get()).func_215452_a().func_204109_b().func_177230_c());
        replaceableBlocks.add(((ConfiguredSurfaceBuilder)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("mango_mod:netherrack"))).func_242440_e().func_242500_d().get()).func_215452_a().func_204108_a().func_177230_c());
        replaceableBlocks.add(((ConfiguredSurfaceBuilder)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("mango_mod:netherrack"))).func_242440_e().func_242500_d().get()).func_215452_a().func_204109_b().func_177230_c());
        replaceableBlocks.add(((ConfiguredSurfaceBuilder)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("mango_mod:blackstonecliff"))).func_242440_e().func_242500_d().get()).func_215452_a().func_204108_a().func_177230_c());
        replaceableBlocks.add(((ConfiguredSurfaceBuilder)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("mango_mod:blackstonecliff"))).func_242440_e().func_242500_d().get()).func_215452_a().func_204109_b().func_177230_c());
        DeferredWorkQueue.runLater(() -> {
            try {
                ObfuscationReflectionHelper.setPrivateValue(WorldCarver.class, (Object)WorldCarver.field_222709_a, (Object)new ImmutableSet.Builder().addAll((Iterable)((Set)ObfuscationReflectionHelper.getPrivateValue(WorldCarver.class, (Object)WorldCarver.field_222709_a, (String)"field_222718_j"))).addAll((Iterable)replaceableBlocks).build(), (String)"field_222718_j");
                ObfuscationReflectionHelper.setPrivateValue(WorldCarver.class, (Object)WorldCarver.field_222711_c, (Object)new ImmutableSet.Builder().addAll((Iterable)((Set)ObfuscationReflectionHelper.getPrivateValue(WorldCarver.class, (Object)WorldCarver.field_222711_c, (String)"field_222718_j"))).addAll((Iterable)replaceableBlocks).build(), (String)"field_222718_j");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientLoad(FMLClientSetupEvent event) {
        DimensionRenderInfo customEffect = new DimensionRenderInfo(Float.NaN, true, DimensionRenderInfo.FogType.NONE, false, false){

            public Vector3d func_230494_a_(Vector3d color, float sunHeight) {
                return new Vector3d(0.2, 0.0, 0.0);
            }

            public boolean func_230493_a_(int x, int y) {
                return false;
            }
        };
        DeferredWorkQueue.runLater(() -> {
            try {
                Object2ObjectMap effectsRegistry = (Object2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(DimensionRenderInfo.class, null, (String)"field_239208_a_");
                effectsRegistry.put((Object)new ResourceLocation("mango_mod:witheric_land"), (Object)customEffect);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        RenderTypeLookup.setRenderLayer((Block)portal, (RenderType)RenderType.func_228645_f_());
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new CustomPortalBlock());
        this.elements.items.add(() -> (Item)new WithericLandItem().setRegistryName("witheric_land"));
    }

    public static class TeleporterDimensionMod
    implements ITeleporter {
        private final ServerWorld world;
        private final BlockPos entityEnterPos;

        public TeleporterDimensionMod(ServerWorld worldServer, BlockPos entityEnterPos) {
            this.world = worldServer;
            this.entityEnterPos = entityEnterPos;
        }

        public Optional<TeleportationRepositioner.Result> getExistingPortal(BlockPos pos, boolean isNether) {
            PointOfInterestManager pointofinterestmanager = this.world.func_217443_B();
            int i = isNether ? 16 : 128;
            pointofinterestmanager.func_226347_a_((IWorldReader)this.world, pos, i);
            Optional<PointOfInterest> optional = pointofinterestmanager.func_226353_b_(poiType -> poiType == poi, pos, i, PointOfInterestManager.Status.ANY).sorted(Comparator.comparingDouble(poi -> poi.func_218261_f().func_177951_i((Vector3i)pos)).thenComparingInt(poi -> poi.func_218261_f().func_177956_o())).filter(poi -> this.world.func_180495_p(poi.func_218261_f()).func_235901_b_((Property)BlockStateProperties.field_208199_z)).findFirst();
            return optional.map(poi -> {
                BlockPos blockpos = poi.func_218261_f();
                this.world.func_72863_F().func_217228_a(CUSTOM_PORTAL, new ChunkPos(blockpos), 3, (Object)blockpos);
                BlockState blockstate = this.world.func_180495_p(blockpos);
                return TeleportationRepositioner.func_243676_a((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posIn -> this.world.func_180495_p(posIn) == blockstate);
            });
        }

        public Optional<TeleportationRepositioner.Result> makePortal(BlockPos pos, Direction.Axis axis) {
            Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
            double d0 = -1.0;
            BlockPos blockpos = null;
            double d1 = -1.0;
            BlockPos blockpos1 = null;
            WorldBorder worldborder = this.world.func_175723_af();
            int i = this.world.func_234938_ad_() - 1;
            BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
            for (BlockPos.Mutable blockpos$mutable1 : BlockPos.func_243514_a((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
                int j = Math.min(i, this.world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, blockpos$mutable1.func_177958_n(), blockpos$mutable1.func_177952_p()));
                boolean k = true;
                if (!worldborder.func_177746_a((BlockPos)blockpos$mutable1) || !worldborder.func_177746_a((BlockPos)blockpos$mutable1.func_189534_c(direction, 1))) continue;
                blockpos$mutable1.func_189534_c(direction.func_176734_d(), 1);
                for (int l = j; l >= 0; --l) {
                    int j1;
                    blockpos$mutable1.func_185336_p(l);
                    if (!this.world.func_175623_d((BlockPos)blockpos$mutable1)) continue;
                    int i1 = l;
                    while (l > 0 && this.world.func_175623_d((BlockPos)blockpos$mutable1.func_189536_c(Direction.DOWN))) {
                        --l;
                    }
                    if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                    blockpos$mutable1.func_185336_p(l);
                    if (!this.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, 0)) continue;
                    double d2 = pos.func_177951_i((Vector3i)blockpos$mutable1);
                    if (this.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, -1) && this.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                        d0 = d2;
                        blockpos = blockpos$mutable1.func_185334_h();
                    }
                    if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                    d1 = d2;
                    blockpos1 = blockpos$mutable1.func_185334_h();
                }
            }
            if (d0 == -1.0 && d1 != -1.0) {
                blockpos = blockpos1;
                d0 = d1;
            }
            if (d0 == -1.0) {
                blockpos = new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)70, (int)(this.world.func_234938_ad_() - 10)), pos.func_177952_p()).func_185334_h();
                Direction direction1 = direction.func_176746_e();
                if (!worldborder.func_177746_a(blockpos)) {
                    return Optional.empty();
                }
                for (int l1 = -1; l1 < 2; ++l1) {
                    for (int k2 = 0; k2 < 2; ++k2) {
                        for (int i3 = -1; i3 < 3; ++i3) {
                            BlockState blockstate1 = i3 < 0 ? WithericobsidianBlock.block.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                            blockpos$mutable.func_239621_a_((Vector3i)blockpos, k2 * direction.func_82601_c() + l1 * direction1.func_82601_c(), i3, k2 * direction.func_82599_e() + l1 * direction1.func_82599_e());
                            this.world.func_175656_a((BlockPos)blockpos$mutable, blockstate1);
                        }
                    }
                }
            }
            for (int k1 = -1; k1 < 3; ++k1) {
                for (int i2 = -1; i2 < 4; ++i2) {
                    if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                    blockpos$mutable.func_239621_a_((Vector3i)blockpos, k1 * direction.func_82601_c(), i2, k1 * direction.func_82599_e());
                    this.world.func_180501_a((BlockPos)blockpos$mutable, WithericobsidianBlock.block.func_176223_P(), 3);
                }
            }
            BlockState blockstate = (BlockState)portal.func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)axis);
            for (int j2 = 0; j2 < 2; ++j2) {
                for (int l2 = 0; l2 < 3; ++l2) {
                    blockpos$mutable.func_239621_a_((Vector3i)blockpos, j2 * direction.func_82601_c(), l2, j2 * direction.func_82599_e());
                    this.world.func_180501_a((BlockPos)blockpos$mutable, blockstate, 18);
                    this.world.func_217443_B().func_219135_a((BlockPos)blockpos$mutable, poi);
                }
            }
            return Optional.of(new TeleportationRepositioner.Result(blockpos.func_185334_h(), 2, 3));
        }

        private boolean checkRegionForPlacement(BlockPos originalPos, BlockPos.Mutable offsetPos, Direction directionIn, int offsetScale) {
            Direction direction = directionIn.func_176746_e();
            for (int i = -1; i < 3; ++i) {
                for (int j = -1; j < 4; ++j) {
                    offsetPos.func_239621_a_((Vector3i)originalPos, directionIn.func_82601_c() * i + direction.func_82601_c() * offsetScale, j, directionIn.func_82599_e() * i + direction.func_82599_e() * offsetScale);
                    if (j < 0 && !this.world.func_180495_p((BlockPos)offsetPos).func_185904_a().func_76220_a()) {
                        return false;
                    }
                    if (j < 0 || this.world.func_175623_d((BlockPos)offsetPos)) continue;
                    return false;
                }
            }
            return true;
        }

        public Entity placeEntity(Entity entity, ServerWorld serverworld, ServerWorld server, float yaw, Function<Boolean, Entity> repositionEntity) {
            PortalInfo portalinfo = this.getPortalInfo(entity, server);
            if (entity instanceof ServerPlayerEntity) {
                entity.func_70029_a((World)server);
                server.func_217447_b((ServerPlayerEntity)entity);
                entity.field_70177_z = portalinfo.field_242960_c % 360.0f;
                entity.field_70125_A = portalinfo.field_242961_d % 360.0f;
                entity.func_225653_b_(portalinfo.field_222505_a.field_72450_a, portalinfo.field_222505_a.field_72448_b, portalinfo.field_222505_a.field_72449_c);
                return entity;
            }
            Entity entityNew = entity.func_200600_R().func_200721_a((World)server);
            if (entityNew != null) {
                entityNew.func_180432_n(entity);
                entityNew.func_70012_b(portalinfo.field_222505_a.field_72450_a, portalinfo.field_222505_a.field_72448_b, portalinfo.field_222505_a.field_72449_c, portalinfo.field_242960_c, entityNew.field_70125_A);
                entityNew.func_213317_d(portalinfo.field_222506_b);
                server.func_217460_e(entityNew);
            }
            return entityNew;
        }

        private PortalInfo getPortalInfo(Entity entity, ServerWorld server) {
            WorldBorder worldborder = server.func_175723_af();
            double d0 = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
            double d1 = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
            double d2 = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
            double d3 = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
            double d4 = DimensionType.func_242715_a((DimensionType)entity.field_70170_p.func_230315_m_(), (DimensionType)server.func_230315_m_());
            BlockPos blockpos1 = new BlockPos(MathHelper.func_151237_a((double)(entity.func_226277_ct_() * d4), (double)d0, (double)d2), entity.func_226278_cu_(), MathHelper.func_151237_a((double)(entity.func_226281_cx_() * d4), (double)d1, (double)d3));
            return this.getPortalRepositioner(entity, blockpos1).map(repositioner -> {
                Vector3d vector3d;
                Direction.Axis direction$axis;
                BlockState blockstate = entity.field_70170_p.func_180495_p(this.entityEnterPos);
                if (blockstate.func_235901_b_((Property)BlockStateProperties.field_208199_z)) {
                    direction$axis = (Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z);
                    TeleportationRepositioner.Result teleportationrepositioner$result = TeleportationRepositioner.func_243676_a((BlockPos)this.entityEnterPos, (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.field_70170_p.func_180495_p(pos) == blockstate);
                    vector3d = CustomPortalSize.func_242973_a(teleportationrepositioner$result, direction$axis, entity.func_213303_ch(), entity.func_213305_a(entity.func_213283_Z()));
                } else {
                    direction$axis = Direction.Axis.X;
                    vector3d = new Vector3d(0.5, 0.0, 0.0);
                }
                return CustomPortalSize.func_242963_a(server, repositioner, direction$axis, vector3d, entity.func_213305_a(entity.func_213283_Z()), entity.func_213322_ci(), entity.field_70177_z, entity.field_70125_A);
            }).orElse(new PortalInfo(entity.func_213303_ch(), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A));
        }

        protected Optional<TeleportationRepositioner.Result> getPortalRepositioner(Entity entity, BlockPos pos) {
            Optional<TeleportationRepositioner.Result> optional = this.getExistingPortal(pos, false);
            if (entity instanceof ServerPlayerEntity) {
                if (optional.isPresent()) {
                    return optional;
                }
                Direction.Axis direction$axis = entity.field_70170_p.func_180495_p(this.entityEnterPos).func_235903_d_((Property)NetherPortalBlock.field_176550_a).orElse(Direction.Axis.X);
                return this.makePortal(pos, direction$axis);
            }
            return optional;
        }
    }

    public static class CustomPortalSize {
        private static final AbstractBlock.IPositionPredicate POSITION_PREDICATE = (state, blockReader, pos) -> state.func_177230_c() == WithericobsidianBlock.block;
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public static Optional<CustomPortalSize> func_242964_a(IWorld world, BlockPos pos, Direction.Axis axis) {
            return CustomPortalSize.func_242965_a(world, pos, size -> size.isValid() && size.portalBlockCount == 0, axis);
        }

        public static Optional<CustomPortalSize> func_242965_a(IWorld world, BlockPos pos, Predicate<CustomPortalSize> sizePredicate, Direction.Axis axis) {
            Optional<CustomPortalSize> optional = Optional.of(new CustomPortalSize(world, pos, axis)).filter(sizePredicate);
            if (optional.isPresent()) {
                return optional;
            }
            Direction.Axis direction$axis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            return Optional.of(new CustomPortalSize(world, pos, direction$axis)).filter(sizePredicate);
        }

        public CustomPortalSize(IWorld worldIn, BlockPos pos, Direction.Axis axisIn) {
            this.world = worldIn;
            this.axis = axisIn;
            this.rightDir = axisIn == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.func_242971_a(pos);
            if (this.bottomLeft == null) {
                this.bottomLeft = pos;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.func_242974_d();
                if (this.width > 0) {
                    this.height = this.func_242975_e();
                }
            }
        }

        @Nullable
        private BlockPos func_242971_a(BlockPos pos) {
            int i = Math.max(0, pos.func_177956_o() - 21);
            while (pos.func_177956_o() > i && CustomPortalSize.canConnect(this.world.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            Direction direction = this.rightDir.func_176734_d();
            int j = this.func_242972_a(pos, direction) - 1;
            return j < 0 ? null : pos.func_177967_a(direction, j);
        }

        private int func_242974_d() {
            int i = this.func_242972_a(this.bottomLeft, this.rightDir);
            return i >= 2 && i <= 21 ? i : 0;
        }

        private int func_242972_a(BlockPos pos, Direction direction) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int i = 0; i <= 21; ++i) {
                blockpos$mutable.func_189533_g((Vector3i)pos).func_189534_c(direction, i);
                BlockState blockstate = this.world.func_180495_p((BlockPos)blockpos$mutable);
                if (!CustomPortalSize.canConnect(blockstate)) {
                    if (!POSITION_PREDICATE.test(blockstate, (IBlockReader)this.world, (BlockPos)blockpos$mutable)) break;
                    return i;
                }
                BlockState blockstate1 = this.world.func_180495_p((BlockPos)blockpos$mutable.func_189536_c(Direction.DOWN));
                if (!POSITION_PREDICATE.test(blockstate1, (IBlockReader)this.world, (BlockPos)blockpos$mutable)) break;
            }
            return 0;
        }

        private int func_242975_e() {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = this.func_242969_a(blockpos$mutable);
            return i >= 3 && i <= 21 && this.func_242970_a(blockpos$mutable, i) ? i : 0;
        }

        private boolean func_242970_a(BlockPos.Mutable mutablePos, int upDisplacement) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.Mutable blockpos$mutable = mutablePos.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, upDisplacement).func_189534_c(this.rightDir, i);
                if (POSITION_PREDICATE.test(this.world.func_180495_p((BlockPos)blockpos$mutable), (IBlockReader)this.world, (BlockPos)blockpos$mutable)) continue;
                return false;
            }
            return true;
        }

        private int func_242969_a(BlockPos.Mutable mutablePos) {
            for (int i = 0; i < 21; ++i) {
                mutablePos.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, -1);
                if (!POSITION_PREDICATE.test(this.world.func_180495_p((BlockPos)mutablePos), (IBlockReader)this.world, (BlockPos)mutablePos)) {
                    return i;
                }
                mutablePos.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, this.width);
                if (!POSITION_PREDICATE.test(this.world.func_180495_p((BlockPos)mutablePos), (IBlockReader)this.world, (BlockPos)mutablePos)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    mutablePos.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, j);
                    BlockState blockstate = this.world.func_180495_p((BlockPos)mutablePos);
                    if (!CustomPortalSize.canConnect(blockstate)) {
                        return i;
                    }
                    if (blockstate.func_177230_c() != portal) continue;
                    ++this.portalBlockCount;
                }
            }
            return 21;
        }

        private static boolean canConnect(BlockState state) {
            return state.func_196958_f() || state.func_177230_c() == portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            BlockState blockstate = (BlockState)portal.func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)this.axis);
            BlockPos.func_218278_a((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.func_177967_a(Direction.UP, this.height - 1).func_177967_a(this.rightDir, this.width - 1)).forEach(pos -> {
                this.world.func_180501_a(pos, blockstate, 18);
                if (this.world instanceof ServerWorld) {
                    ((ServerWorld)this.world).func_217443_B().func_219135_a(pos, poi);
                }
            });
        }

        public boolean validatePortal() {
            return this.isValid() && this.portalBlockCount == this.width * this.height;
        }

        public static Vector3d func_242973_a(TeleportationRepositioner.Result result, Direction.Axis axis, Vector3d positionVector, EntitySize size) {
            double d4;
            double d2;
            double d0 = (double)result.field_243680_b - (double)size.field_220315_a;
            double d1 = (double)result.field_243681_c - (double)size.field_220316_b;
            BlockPos blockpos = result.field_243679_a;
            if (d0 > 0.0) {
                float f = (float)blockpos.func_243648_a(axis) + size.field_220315_a / 2.0f;
                d2 = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(positionVector.func_216370_a(axis) - (double)f), (double)0.0, (double)d0), (double)0.0, (double)1.0);
            } else {
                d2 = 0.5;
            }
            if (d1 > 0.0) {
                Direction.Axis direction$axis = Direction.Axis.Y;
                d4 = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(positionVector.func_216370_a(direction$axis) - (double)blockpos.func_243648_a(direction$axis)), (double)0.0, (double)d1), (double)0.0, (double)1.0);
            } else {
                d4 = 0.0;
            }
            Direction.Axis direction$axis1 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            double d3 = positionVector.func_216370_a(direction$axis1) - ((double)blockpos.func_243648_a(direction$axis1) + 0.5);
            return new Vector3d(d2, d4, d3);
        }

        public static PortalInfo func_242963_a(ServerWorld world, TeleportationRepositioner.Result result, Direction.Axis axis, Vector3d offsetVector, EntitySize size, Vector3d motion, float rotationYaw, float rotationPitch) {
            BlockPos blockpos = result.field_243679_a;
            BlockState blockstate = world.func_180495_p(blockpos);
            Direction.Axis direction$axis = (Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z);
            double d0 = result.field_243680_b;
            double d1 = result.field_243681_c;
            int i = axis == direction$axis ? 0 : 90;
            Vector3d vector3d = axis == direction$axis ? motion : new Vector3d(motion.field_72449_c, motion.field_72448_b, -motion.field_72450_a);
            double d2 = (double)size.field_220315_a / 2.0 + (d0 - (double)size.field_220315_a) * offsetVector.func_82615_a();
            double d3 = (d1 - (double)size.field_220316_b) * offsetVector.func_82617_b();
            double d4 = 0.5 + offsetVector.func_82616_c();
            boolean flag = direction$axis == Direction.Axis.X;
            Vector3d vector3d1 = new Vector3d((double)blockpos.func_177958_n() + (flag ? d2 : d4), (double)blockpos.func_177956_o() + d3, (double)blockpos.func_177952_p() + (flag ? d4 : d2));
            return new PortalInfo(vector3d1, vector3d, rotationYaw + (float)i, rotationPitch);
        }
    }

    public static class CustomPortalBlock
    extends NetherPortalBlock {
        public CustomPortalBlock() {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200942_a().func_200944_c().func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(s -> 3).func_222380_e());
            this.setRegistryName("witheric_land_portal");
        }

        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        }

        public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        }

        public void portalSpawn(World world, BlockPos pos) {
            Optional<CustomPortalSize> optional = CustomPortalSize.func_242964_a((IWorld)world, pos, Direction.Axis.X);
            if (optional.isPresent()) {
                optional.get().placePortalBlocks();
            }
        }

        public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
            Direction.Axis direction$axis = facing.func_176740_k();
            Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b((Property)field_176550_a);
            boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
            return !flag && !facingState.func_203425_a((Block)this) && !new CustomPortalSize(worldIn, currentPos, direction$axis1).validatePortal() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
            for (int i = 0; i < 4; ++i) {
                double px = (float)pos.func_177958_n() + random.nextFloat();
                double py = (float)pos.func_177956_o() + random.nextFloat();
                double pz = (float)pos.func_177952_p() + random.nextFloat();
                double vx = ((double)random.nextFloat() - 0.5) / 2.0;
                double vy = ((double)random.nextFloat() - 0.5) / 2.0;
                double vz = ((double)random.nextFloat() - 0.5) / 2.0;
                int j = random.nextInt(4) - 1;
                if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                    px = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                    vx = random.nextFloat() * 2.0f * (float)j;
                } else {
                    pz = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                    vz = random.nextFloat() * 2.0f * (float)j;
                }
                world.func_195594_a((IParticleData)SoulpaticleParticle.particle, px, py, pz, vx, vy, vz);
            }
            if (random.nextInt(110) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.portal.ambient")), SoundCategory.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
            }
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && !entity.field_70170_p.field_72995_K) {
                if (entity.func_242280_ah()) {
                    entity.func_242279_ag();
                } else if (entity.field_70170_p.func_234923_W_() != RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("mango_mod:witheric_land"))) {
                    entity.func_242279_ag();
                    this.teleportToDimension(entity, pos, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("mango_mod:witheric_land")));
                } else {
                    entity.func_242279_ag();
                    this.teleportToDimension(entity, pos, (RegistryKey<World>)World.field_234918_g_);
                }
            }
        }

        private void teleportToDimension(Entity entity, BlockPos pos, RegistryKey<World> destinationType) {
            entity.changeDimension(entity.func_184102_h().func_71218_a(destinationType), (ITeleporter)new TeleporterDimensionMod(entity.func_184102_h().func_71218_a(destinationType), pos));
        }
    }

    public static class POIRegisterHandler {
        @SubscribeEvent
        public void registerPointOfInterest(RegistryEvent.Register<PointOfInterestType> event) {
            poi = (PointOfInterestType)new PointOfInterestType("witheric_land_portal", (Set)Sets.newHashSet((Iterable)ImmutableSet.copyOf((Collection)portal.func_176194_O().func_177619_a())), 0, 1).setRegistryName("witheric_land_portal");
            ForgeRegistries.POI_TYPES.register((IForgeRegistryEntry)poi);
        }
    }
}

