/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.artillerysupport;

import net.genzyuro.artillerysupport.particle.ArtillerySupportParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;

public class MortarUtils {
    public static void spawnMortarProjectileWithDirection(Level level, BlockPos hitBlockPos, double angle, double radius, double speed, EntityType<?> entityType, String direction) {
        if (direction == null) {
            direction = "North";
        }
        double spawnX = (double)hitBlockPos.m_123341_() + Math.cos(angle) * radius;
        double spawnZ = (double)hitBlockPos.m_123343_() + Math.sin(angle) * radius;
        double spawnY = hitBlockPos.m_123342_() + 200;
        double targetX = (double)hitBlockPos.m_123341_() + Math.cos(angle) * radius;
        double targetZ = (double)hitBlockPos.m_123343_() + Math.sin(angle) * radius;
        double targetY = hitBlockPos.m_123342_();
        switch (direction) {
            case "North": {
                spawnZ -= 255.0;
                targetZ += 49.0;
                break;
            }
            case "North-East": {
                spawnX += 180.0;
                spawnZ -= 180.0;
                targetX -= 35.0;
                targetZ += 35.0;
                break;
            }
            case "East": {
                spawnX += 255.0;
                targetX -= 49.0;
                break;
            }
            case "South-East": {
                spawnX += 180.0;
                spawnZ += 180.0;
                targetX -= 35.0;
                targetZ -= 35.0;
                break;
            }
            case "South": {
                spawnZ += 255.0;
                targetZ -= 49.0;
                break;
            }
            case "South-West": {
                spawnX -= 180.0;
                spawnZ += 180.0;
                targetX += 35.0;
                targetZ -= 35.0;
                break;
            }
            case "West": {
                spawnX -= 255.0;
                targetX += 49.0;
                break;
            }
            case "North-West": {
                spawnX -= 180.0;
                spawnZ -= 180.0;
                targetX += 35.0;
                targetZ += 35.0;
            }
        }
        double dx = targetX - spawnX;
        double dy = targetY - spawnY;
        double dz = targetZ - spawnZ;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double velocityX = dx / distance * speed;
        double velocityY = dy / distance * speed;
        double velocityZ = dz / distance * speed;
        ThrowableItemProjectile mortar = (ThrowableItemProjectile)entityType.m_20615_(level);
        if (mortar != null) {
            mortar.m_6034_(spawnX, spawnY, spawnZ);
            mortar.m_20334_(velocityX, velocityY, velocityZ);
            level.m_7967_((Entity)mortar);
        }
    }

    public static void spawnHighAngleMortarProjectileWithDirection(Level level, BlockPos hitBlockPos, double angle, double radius, double speed, EntityType<?> entityType, String direction) {
        if (direction == null) {
            direction = "North";
        }
        double spawnX = (double)hitBlockPos.m_123341_() + Math.cos(angle) * radius;
        double spawnZ = (double)hitBlockPos.m_123343_() + Math.sin(angle) * radius;
        double spawnY = hitBlockPos.m_123342_() + 350;
        double targetX = (double)hitBlockPos.m_123341_() + Math.cos(angle) * radius;
        double targetZ = (double)hitBlockPos.m_123343_() + Math.sin(angle) * radius;
        double targetY = hitBlockPos.m_123342_();
        switch (direction) {
            case "North": {
                spawnZ -= 127.0;
                targetZ += 15.0;
                break;
            }
            case "North-East": {
                spawnX += 90.0;
                spawnZ -= 90.0;
                targetX -= 10.0;
                targetZ += 10.0;
                break;
            }
            case "East": {
                spawnX += 127.0;
                targetX -= 15.0;
                break;
            }
            case "South-East": {
                spawnX += 90.0;
                spawnZ += 90.0;
                targetX -= 10.0;
                targetZ -= 10.0;
                break;
            }
            case "South": {
                spawnZ += 127.0;
                targetZ -= 15.0;
                break;
            }
            case "South-West": {
                spawnX -= 90.0;
                spawnZ += 90.0;
                targetX += 10.0;
                targetZ -= 10.0;
                break;
            }
            case "West": {
                spawnX -= 127.0;
                targetX += 15.0;
                break;
            }
            case "North-West": {
                spawnX -= 90.0;
                spawnZ -= 90.0;
                targetX += 10.0;
                targetZ += 10.0;
            }
        }
        double dx = targetX - spawnX;
        double dy = targetY - spawnY;
        double dz = targetZ - spawnZ;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double velocityX = dx / distance * speed;
        double velocityY = dy / distance * speed;
        double velocityZ = dz / distance * speed;
        ThrowableItemProjectile mortar = (ThrowableItemProjectile)entityType.m_20615_(level);
        if (mortar != null) {
            mortar.m_6034_(spawnX, spawnY, spawnZ);
            mortar.m_20334_(velocityX, velocityY, velocityZ);
            level.m_7967_((Entity)mortar);
        }
    }

    public static void spawnSmokeParticles(Level level, double x, double y, double z) {
        for (int i = 0; i < 5; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.8;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.8;
            double offsetY = level.f_46441_.m_188500_() * 0.5;
            double velocity = level.f_46441_.m_188500_() * 0.01;
            level.m_7106_((ParticleOptions)ArtillerySupportParticles.SIGNAL_SMOKE_PARTICLES.get(), x + offsetX, y + offsetY, z + offsetZ, velocity, 0.15, velocity);
        }
    }

    public static String getDirectionFromYaw(float yaw) {
        if ((double)(yaw = (yaw + 360.0f) % 360.0f) >= 337.5 || (double)yaw < 22.5) {
            return "North";
        }
        if ((double)yaw >= 22.5 && (double)yaw < 67.5) {
            return "North-East";
        }
        if ((double)yaw >= 67.5 && (double)yaw < 112.5) {
            return "East";
        }
        if ((double)yaw >= 112.5 && (double)yaw < 157.5) {
            return "South-East";
        }
        if ((double)yaw >= 157.5 && (double)yaw < 202.5) {
            return "South";
        }
        if ((double)yaw >= 202.5 && (double)yaw < 247.5) {
            return "South-West";
        }
        if ((double)yaw >= 247.5 && (double)yaw < 292.5) {
            return "West";
        }
        return "North-West";
    }
}

