/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.artillerysupport.entity.smokebomb;

import net.genzyuro.artillerysupport.MortarUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractSmokeBombProjectileEntity
extends ThrowableItemProjectile {
    protected boolean isWeightless = false;
    protected int ticksDelay = 0;
    protected int ticksOperation = 0;
    protected BlockPos hitBlockPos;
    protected String initialDirection;
    protected double playerX;
    protected double playerZ;

    public AbstractSmokeBombProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractSmokeBombProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level, LivingEntity owner) {
        super(entityType, owner, level);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            this.initialDirection = MortarUtils.getDirectionFromYaw(player.m_146908_());
            this.playerX = player.m_20185_();
            this.playerZ = player.m_20189_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            this.hitBlockPos = result.m_82425_();
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_20242_(true);
            this.isWeightless = true;
        }
    }

    protected int getWeightlessDelay() {
        return 100;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isWeightless) {
            ++this.ticksDelay;
            if (this.ticksDelay >= this.getWeightlessDelay()) {
                ++this.ticksOperation;
                this.handleTick();
            }
            if (this.ticksOperation >= this.getDespawnTicks()) {
                this.m_146870_();
            }
            if (!this.m_9236_().f_46443_) {
                if (this.ticksOperation <= 300 && this.ticksOperation % 2 == 0) {
                    this.m_9236_().m_7605_((Entity)this, (byte)88);
                }
            } else if (this.ticksOperation <= 300 && this.ticksOperation % 2 == 0) {
                this.spawnSmokeParticles();
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 88) {
            this.spawnSmokeParticles();
        } else {
            super.m_7822_(id);
        }
    }

    private void spawnSmokeParticles() {
        MortarUtils.spawnSmokeParticles(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    protected abstract void handleTick();

    protected abstract int getDespawnTicks();
}

