/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thermal_shock.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.thermal_shock.ThermalShockMod;
import net.mcreator.thermal_shock.procedures.Dabguide2to3Procedure;
import net.mcreator.thermal_shock.procedures.Fabguide2to1Procedure;
import net.mcreator.thermal_shock.procedures.FlintRifleOpenProcedure;
import net.mcreator.thermal_shock.procedures.GhostSwordOpenProcedure;
import net.mcreator.thermal_shock.procedures.HailstormOpenProcedure;
import net.mcreator.thermal_shock.procedures.MagnetCrossbowOpenProcedure;
import net.mcreator.thermal_shock.procedures.VolcanoOpenProcedure;
import net.mcreator.thermal_shock.procedures.ZerkerGauntletOpenProcedure;
import net.mcreator.thermal_shock.world.inventory.FabicGuidePageTwoMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FabicGuidePageTwoButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public FabicGuidePageTwoButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public FabicGuidePageTwoButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(FabicGuidePageTwoButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(FabicGuidePageTwoButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            FabicGuidePageTwoButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = FabicGuidePageTwoMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Fabguide2to1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            Dabguide2to3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GhostSwordOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            FlintRifleOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            VolcanoOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            HailstormOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            MagnetCrossbowOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            ZerkerGauntletOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ThermalShockMod.addNetworkMessage(FabicGuidePageTwoButtonMessage.class, FabicGuidePageTwoButtonMessage::buffer, FabicGuidePageTwoButtonMessage::new, FabicGuidePageTwoButtonMessage::handler);
    }
}

