/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import java.util.Optional;
import mod.chloeprime.aaaparticles.client.internal.ReloadTrackable;
import mod.chloeprime.aaaparticles.client.internal.RenderStateCapture;
import mod.chloeprime.aaaparticles.client.render.forge.RenderUtilImpl;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class RenderUtil {
    public static final Minecraft MC = Minecraft.m_91087_();

    public static void copyDepthSafely(RenderTarget from, RenderTarget to) {
        int read = GL11.glGetInteger((int)36010);
        int draw = GL11.glGetInteger((int)36006);
        to.m_83945_(from);
        GL30.glBindFramebuffer((int)36008, (int)read);
        GL30.glBindFramebuffer((int)36009, (int)draw);
    }

    public static void copyCurrentDepthTo(RenderTarget target) {
        int frameBuffer = GL11.glGetInteger((int)36006);
        Window window = MC.m_91268_();
        RenderUtil.copyDepthSafely(frameBuffer, window.m_85441_(), window.m_85442_(), target);
    }

    public static void copyCurrentTo(RenderTarget target) {
        int frameBuffer = GL11.glGetInteger((int)36006);
        Window window = MC.m_91268_();
        RenderUtil.copyDepthSafely(frameBuffer, window.m_85441_(), window.m_85442_(), target);
    }

    public static void pasteToCurrentDepthFrom(RenderTarget source) {
        int frameBuffer = GL11.glGetInteger((int)36006);
        Window window = MC.m_91268_();
        RenderUtil.copyDepthSafely(source, frameBuffer, window.m_85441_(), window.m_85442_());
    }

    public static void copyDepthSafely(int src, int srcWidth, int srcHeight, RenderTarget target) {
        int readBackup = GL11.glGetInteger((int)36010);
        int drawBackup = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36008, (int)src);
        GL30.glBindFramebuffer((int)36009, (int)target.f_83920_);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)srcWidth, (int)srcHeight, (int)0, (int)0, (int)target.f_83915_, (int)target.f_83916_, (int)256, (int)9728);
        GL30.glBindFramebuffer((int)36008, (int)readBackup);
        GL30.glBindFramebuffer((int)36009, (int)drawBackup);
    }

    public static void copyDepthSafely(RenderTarget src, int target, int targetWidth, int targetHeight) {
        int readBackup = GL11.glGetInteger((int)36010);
        int drawBackup = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36008, (int)src.f_83920_);
        GL30.glBindFramebuffer((int)36009, (int)target);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)src.f_83915_, (int)src.f_83916_, (int)0, (int)0, (int)targetWidth, (int)targetHeight, (int)256, (int)9728);
        GL30.glBindFramebuffer((int)36008, (int)readBackup);
        GL30.glBindFramebuffer((int)36009, (int)drawBackup);
    }

    public static void copySafely(RenderTarget src, RenderTarget target) {
        int readBackup = GL11.glGetInteger((int)36010);
        int drawBackup = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36008, (int)src.f_83920_);
        GL30.glBindFramebuffer((int)36009, (int)target.f_83920_);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)src.f_83915_, (int)src.f_83916_, (int)0, (int)0, (int)target.f_83915_, (int)target.f_83916_, (int)16640, (int)9728);
        GL30.glBindFramebuffer((int)36008, (int)readBackup);
        GL30.glBindFramebuffer((int)36009, (int)drawBackup);
    }

    public static void runFrameBufferCodeSafely(Runnable code) {
        int readBackup = GL11.glGetInteger((int)36010);
        int drawBackup = GL11.glGetInteger((int)36006);
        int texture = GL11.glGetInteger((int)32873);
        code.run();
        GL30.glBindFramebuffer((int)36008, (int)readBackup);
        GL30.glBindFramebuffer((int)36009, (int)drawBackup);
        GL30.glBindTexture((int)3553, (int)texture);
    }

    @ApiStatus.Internal
    public static void runPixelStoreCodeSafely(Runnable code) {
        int packAlignment = GL30.glGetInteger((int)3333);
        int unpackRowLength = GL30.glGetInteger((int)3314);
        int unpackSkipRows = GL30.glGetInteger((int)3315);
        int unpackSkipPixels = GL30.glGetInteger((int)3316);
        int unpackAlignment = GL30.glGetInteger((int)3317);
        code.run();
        GL30.glPixelStorei((int)3333, (int)packAlignment);
        GL30.glPixelStorei((int)3314, (int)unpackRowLength);
        GL30.glPixelStorei((int)3315, (int)unpackSkipRows);
        GL30.glPixelStorei((int)3316, (int)unpackSkipPixels);
        GL30.glPixelStorei((int)3317, (int)unpackAlignment);
    }

    public static void runPixelStoreCodeHealthily(Runnable code) {
        if (Platform.isFabric()) {
            code.run();
            return;
        }
        RenderUtil.runPixelStoreCodeSafely(() -> {
            GL30.glPixelStorei((int)3314, (int)0);
            GL30.glPixelStorei((int)3315, (int)0);
            GL30.glPixelStorei((int)3316, (int)0);
            code.run();
        });
    }

    public static boolean isReloadingResourcePacks() {
        return ((ReloadTrackable)MC).aaa_particles$isReloading();
    }

    public static void refreshBackgroundFrameBuffer() {
        RenderUtil.refreshFrameBuffer(RenderStateCapture.DISTORTION_BACKGROUND);
    }

    public static Optional<RenderTarget> prepareBackgroundBuffer() {
        if (RenderUtil.isReloadingResourcePacks()) {
            return Optional.empty();
        }
        RenderTarget background = RenderStateCapture.DISTORTION_BACKGROUND;
        RenderUtil.syncStencilState(MC.m_91385_(), background);
        RenderUtil.copySafely(MC.m_91385_(), background);
        return Optional.of(background);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void syncStencilState(RenderTarget from, RenderTarget to) {
        void var1_1;
        RenderUtilImpl.syncStencilState(from, (RenderTarget)var1_1);
    }

    private static void refreshFrameBuffer(RenderTarget fb) {
        RenderUtil.runPixelStoreCodeHealthily(() -> fb.m_83941_(fb.f_83915_, fb.f_83916_, Minecraft.f_91002_));
    }
}

